/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.IRepl;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.javainterop.DynamicInvocationHandler;
import com.github.jlangch.venice.impl.repl.ReplConfig;
import com.github.jlangch.venice.impl.repl.ReplDirs;
import com.github.jlangch.venice.impl.repl.ReplRestart;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.repackage.org.jline.terminal.Terminal;
import org.repackage.org.jline.utils.InfoCmp;
import org.repackage.org.jline.utils.NonBlockingReader;

public class ReplFunctions {
    public static Env register(Env env, IRepl repl, Terminal terminal, ReplConfig config, boolean macroExpandOnLoad, ReplDirs replDirs) {
        Env e = env;
        for (VncFunction fn : ReplFunctions.createFunctions(env, repl, terminal, config, macroExpandOnLoad, replDirs)) {
            e = ReplFunctions.registerFn(e, fn);
        }
        return e;
    }

    private static Env registerFn(Env env, VncFunction fn) {
        return env.setGlobal(new Var(new VncSymbol(fn.getQualifiedName()), fn, false, Var.Scope.Global));
    }

    private static List<VncFunction> createFunctions(Env env, IRepl repl, Terminal terminal, ReplConfig config, boolean macroExpandOnLoad, ReplDirs replDirs) {
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        fns.add(ReplFunctions.createReplInfoFn(terminal, config));
        fns.add(ReplFunctions.createReplRestartFn(config, macroExpandOnLoad));
        fns.add(ReplFunctions.createTermRowsFn(terminal));
        fns.add(ReplFunctions.createTermColsFn(terminal));
        fns.add(ReplFunctions.createReplHomeDirFn(replDirs));
        fns.add(ReplFunctions.createReplLibsDirFn(replDirs));
        fns.add(ReplFunctions.createPromptFn(repl));
        fns.add(ReplFunctions.setHandlerFn(repl));
        fns.add(ReplFunctions.getColorTheme(config));
        fns.add(ReplFunctions.setColorTheme(env, config));
        fns.add(ReplFunctions.waitAnyKeyPressed(terminal));
        fns.add(ReplFunctions.exit(repl));
        return fns;
    }

    private static VncFunction createReplInfoFn(final Terminal terminal, final ReplConfig config) {
        return new VncFunction("repl/info", VncFunction.meta().arglists("(repl/info)").doc("Returns information on the REPL.\n\nNote: This function is only available when called from within a REPL!\n\nE.g.: \n\n```\n{ :term-name \"JLine terminal\" \n  :term-type \"xterm-256color\" \n  :term-cols 80 \n  :term-rows 24 \n  :term-colors 256 \n  :term-class :org.repackage.org.jline.terminal.impl.PosixSysTerminal \n  :color-mode :light }").seeAlso("repl?", "repl/term-rows", "repl/term-cols").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                if (terminal != null) {
                    try {
                        return VncOrderedMap.of(new VncKeyword("term-name"), new VncString(terminal.getName()), new VncKeyword("term-type"), new VncString(terminal.getType()), new VncKeyword("term-cols"), new VncLong(terminal.getSize().getColumns()), new VncKeyword("term-rows"), new VncLong(terminal.getSize().getRows()), new VncKeyword("term-colors"), new VncLong(terminal.getNumericCapability(InfoCmp.Capability.max_colors).intValue()), new VncKeyword("term-class"), new VncKeyword(terminal.getClass().getName()), new VncKeyword("color-mode"), new VncKeyword(config.getColorMode().toString().toLowerCase()));
                    }
                    catch (Exception ex) {
                        throw new VncException("Failed to get the REPL terminal info", ex);
                    }
                }
                return VncOrderedMap.of(new VncKeyword("term-name"), new VncString("unknown"), new VncKeyword("term-type"), new VncString("unknown"), new VncKeyword("term-cols"), new VncLong(0L), new VncKeyword("term-rows"), new VncLong(0L), new VncKeyword("term-colors"), new VncLong(0L), new VncKeyword("term-class"), new VncKeyword("unknown"), new VncKeyword("color-mode"), new VncKeyword("unknown"));
            }
        };
    }

    private static VncFunction createReplRestartFn(final ReplConfig config, final boolean macroExpandOnLoad) {
        return new VncFunction("repl/restart", VncFunction.meta().arglists("(repl/restart)").doc("Restarts the REPL.\n\nNote: This function is only available when called from within a REPL!").seeAlso("repl?").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                ReplRestart.restart(macroExpandOnLoad, config.getColorMode());
                return Constants.Nil;
            }
        };
    }

    private static VncFunction createTermRowsFn(final Terminal terminal) {
        return new VncFunction("repl/term-rows", VncFunction.meta().arglists("(repl/term-rows)").doc("Returns number of rows in the REPL terminal.\n\nNote: This function is only available when called from within a REPL!").seeAlso("repl?", "repl/term-cols", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                return new VncLong(terminal == null ? 0L : (long)terminal.getSize().getRows());
            }
        };
    }

    private static VncFunction createTermColsFn(final Terminal terminal) {
        return new VncFunction("repl/term-cols", VncFunction.meta().arglists("(repl/term-cols)").doc("Returns number of columns in the REPL terminal.\n\nNote: This function is only available when called from within a REPL!").seeAlso("repl?", "repl/term-rows", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                return new VncLong(terminal == null ? 0L : (long)terminal.getSize().getColumns());
            }
        };
    }

    private static VncFunction createReplHomeDirFn(final ReplDirs replDirs) {
        return new VncFunction("repl/home-dir", VncFunction.meta().arglists("(repl/home-dir)").doc("Returns the REPL home directory.\n\nNote: This function is only available when called from within a REPL!").seeAlso("repl?", "repl/libs-dir").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                return replDirs.getHomeDir() == null ? Constants.Nil : new VncJavaObject(replDirs.getHomeDir());
            }
        };
    }

    private static VncFunction createReplLibsDirFn(final ReplDirs replDirs) {
        return new VncFunction("repl/libs-dir", VncFunction.meta().arglists("(repl/libs-dir)").doc("Returns the REPL libs directory\n\nNote: This function is only available when called from within a REPL!").seeAlso("repl?", "repl/home-dir").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                return replDirs.getLibsDir() == null ? Constants.Nil : new VncJavaObject(replDirs.getLibsDir());
            }
        };
    }

    private static VncFunction getColorTheme(final ReplConfig config) {
        return new VncFunction("repl/color-theme", VncFunction.meta().arglists("(repl/color-theme)").doc("Returns REPL's color theme (:light, :dark, :none) ").examples("(repl/color-theme)").seeAlso("repl?", "repl/color-theme!", "repl/prompt!", "repl/handler!", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                ReplConfig.ColorMode theme = config.getColorMode();
                return new VncKeyword(theme.name().toLowerCase());
            }
        };
    }

    private static VncFunction setColorTheme(Env env, final ReplConfig config) {
        return new VncFunction("repl/color-theme!", VncFunction.meta().arglists("(repl/color-theme! theme)").doc("Set the REPL's color theme (:light, :dark) ").examples("(repl/color-theme!)").seeAlso("repl?", "repl/color-theme", "repl/prompt!", "repl/handler!", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ReplConfig.ColorMode mode;
                ArityExceptions.assertArity(this, args, 1);
                VncKeyword theme = Coerce.toVncKeyword(args.first());
                switch (theme.getSimpleName()) {
                    case "light": {
                        mode = ReplConfig.ColorMode.Light;
                        break;
                    }
                    case "dark": {
                        mode = ReplConfig.ColorMode.Dark;
                        break;
                    }
                    case "none": {
                        mode = ReplConfig.ColorMode.None;
                        break;
                    }
                    default: {
                        mode = ReplConfig.ColorMode.Light;
                    }
                }
                config.switchColorMode(mode);
                return new VncKeyword(mode.name().toLowerCase());
            }
        };
    }

    private static VncFunction createPromptFn(final IRepl repl) {
        return new VncFunction("repl/prompt!", VncFunction.meta().arglists("(repl/prompt! s)").doc("Sets the REPL prompt string").examples("(repl/prompt! \"venice> \")").seeAlso("repl?", "repl/handler!", "repl/color-theme", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 1);
                String prompt = Coerce.toVncString(args.first()).getValue();
                if (repl != null) {
                    repl.setPrompt(prompt);
                }
                return Constants.Nil;
            }
        };
    }

    private static VncFunction setHandlerFn(final IRepl repl) {
        return new VncFunction("repl/handler!", VncFunction.meta().arglists("(repl/handler! f)").doc("Sets the REPL command handler").examples("(do                                \n  (defn handle-command [cmd]       \n     ;; run the command 'cmd'      \n     (println \"Demo:\" cmd))      \n                                   \n  (repl/handler! handle-command))   ").seeAlso("repl?", "repl/prompt!", "repl/color-theme", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 1);
                VncFunction handlerFn = Coerce.toVncFunction(args.first());
                if (repl != null) {
                    Object handler = DynamicInvocationHandler.proxify(new CallFrame("proxify(:" + Consumer.class.getName() + ")", args.getMeta()), Consumer.class, VncHashMap.of(new VncString("accept"), handlerFn));
                    repl.setHandler((Consumer)handler);
                }
                return Constants.Nil;
            }
        };
    }

    private static VncFunction waitAnyKeyPressed(final Terminal terminal) {
        return new VncFunction("repl/wait-any-key-pressed", VncFunction.meta().arglists("(repl/wait-any-key-pressed)").doc("Returns REPL's color theme (:light, :dark, :none) ").examples("(repl/color-theme)").seeAlso("repl?", "repl/color-theme!", "repl/prompt!", "repl/handler!", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                terminal.enterRawMode();
                NonBlockingReader reader = terminal.reader();
                try {
                    int c = reader.read();
                    return new VncChar((char)c);
                }
                catch (IOException ex) {
                    return Constants.Nil;
                }
            }
        };
    }

    private static VncFunction exit(IRepl repl) {
        return new VncFunction("repl/exit!", (VncVal)VncFunction.meta().arglists("(repl/exit!)").doc("Exit from the REPL").examples("(repl/exit!)").seeAlso("repl?", "repl/prompt!", "repl/color-theme", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                throw new EofException("exit");
            }
        };
    }
}

