/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.excel;

import com.github.jlangch.venice.impl.util.excel.Excel;
import com.github.jlangch.venice.util.excel.ExcelCellStyleBuilder;
import com.github.jlangch.venice.util.excel.ExcelFontBuilder;
import com.github.jlangch.venice.util.excel.ExcelReader;
import com.github.jlangch.venice.util.excel.ExcelSheetWriter;
import java.io.OutputStream;

public class ExcelWriter {
    private final Excel managedExcel;

    public ExcelWriter(Excel managedExcel) {
        this.managedExcel = managedExcel;
    }

    public static ExcelWriter createXls() {
        return new ExcelWriter(Excel.createXls());
    }

    public static ExcelWriter createXlsx() {
        return new ExcelWriter(Excel.createXlsx());
    }

    public ExcelFontBuilder withFont(String name) {
        return new ExcelFontBuilder(this, this.managedExcel, name);
    }

    public ExcelCellStyleBuilder withCellStyle(String name) {
        return new ExcelCellStyleBuilder(this, this.managedExcel, name);
    }

    public <T> ExcelSheetWriter<T> withSheet(String name, Class<T> type) {
        return new ExcelSheetWriter(this, this.managedExcel.createSheet(name));
    }

    public int getNumberOfSheets() {
        return this.managedExcel.getNumberOfSheets();
    }

    public void evaluateAllFormulas() {
        this.managedExcel.evaluateAllFormulas();
    }

    public Excel toExcel() {
        return this.managedExcel;
    }

    public void write(OutputStream outputStream) {
        this.managedExcel.write(outputStream);
    }

    public byte[] writeToBytes() {
        return this.managedExcel.writeToBytes();
    }

    public ExcelReader reader() {
        this.managedExcel.close();
        return new ExcelReader(this.managedExcel);
    }

    public ExcelWriter end() {
        this.managedExcel.close();
        return this;
    }

    public <T> ExcelSheetWriter<T> getSheet(String name) {
        return new ExcelSheetWriter(this, this.managedExcel.getSheet(name));
    }

    public <T> ExcelSheetWriter<T> getSheetAt(int sheetIdx) {
        return new ExcelSheetWriter(this, this.managedExcel.getSheetAt(sheetIdx - 1));
    }
}

