/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.word;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.docx4j.dml.CTBlip;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Body;

public class DocxMerge {
    private final WordprocessingMLPackage mainDoc;

    public static DocxMerge of(byte[] mainDoc) throws Exception {
        if (mainDoc == null) {
            throw new IllegalArgumentException("A mainDoc must not be null!");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(mainDoc);){
            DocxMerge docxMerge = new DocxMerge(WordprocessingMLPackage.load((InputStream)is));
            return docxMerge;
        }
    }

    public static DocxMerge of(ByteBuffer mainDoc) throws Exception {
        if (mainDoc == null) {
            throw new IllegalArgumentException("A mainDoc must not be null!");
        }
        return DocxMerge.of(mainDoc.array());
    }

    public static DocxMerge of(InputStream mainDocIs) throws Exception {
        if (mainDocIs == null) {
            throw new IllegalArgumentException("A mainDocIs must not be null!");
        }
        try {
            DocxMerge docxMerge = new DocxMerge(WordprocessingMLPackage.load((InputStream)mainDocIs));
            return docxMerge;
        }
        finally {
            try {
                mainDocIs.close();
            }
            catch (Exception exception) {}
        }
    }

    public static DocxMerge of(File mainDocFile) throws Exception {
        if (mainDocFile == null) {
            throw new IllegalArgumentException("A mainDocFile must not be null!");
        }
        return new DocxMerge(WordprocessingMLPackage.load((File)mainDocFile));
    }

    private DocxMerge(WordprocessingMLPackage mainDoc) {
        this.mainDoc = mainDoc;
    }

    public WordprocessingMLPackage doc() {
        return this.mainDoc;
    }

    public byte[] saveToBytes() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.mainDoc.save((OutputStream)os);
            os.close();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public ByteBuffer saveToByteBuffer() throws Exception {
        return ByteBuffer.wrap(this.saveToBytes());
    }

    public void saveTo(File file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("A file must not be null!");
        }
        this.mainDoc.save(file);
    }

    public void saveTo(OutputStream os) throws Exception {
        if (os == null) {
            throw new IllegalArgumentException("An os must not be null!");
        }
        try {
            this.mainDoc.save(os);
        }
        finally {
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
    }

    public DocxMerge mergeBody(byte[] data) throws Exception {
        if (data == null) {
            throw new IllegalArgumentException("A data must not be null!");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            DocxMerge docxMerge = this.mergeBody(WordprocessingMLPackage.load((InputStream)is));
            return docxMerge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocxMerge mergeBody(InputStream is) throws Exception {
        if (is == null) {
            throw new IllegalArgumentException("An is must not be null!");
        }
        try {
            DocxMerge docxMerge = this.mergeBody(WordprocessingMLPackage.load((InputStream)is));
            return docxMerge;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public DocxMerge mergeBody(File f) throws Exception {
        if (f == null) {
            throw new IllegalArgumentException("A file f must not be null!");
        }
        return this.mergeBody(WordprocessingMLPackage.load((File)f));
    }

    public DocxMerge mergeBody(WordprocessingMLPackage d) throws Exception {
        if (d == null) {
            throw new IllegalArgumentException("A WordprocessingMLPackage d must not be null!");
        }
        List body = d.getMainDocumentPart().getJAXBNodesViaXPath("//w:body", false);
        for (Object b : body) {
            List filhos = ((Body)b).getContent();
            for (Object k : filhos) {
                this.mainDoc.getMainDocumentPart().addObject(k);
            }
        }
        return this;
    }

    public DocxMerge mergeBodyWithBlip(byte[] data) throws Exception {
        if (data == null) {
            throw new IllegalArgumentException("A data must not be null!");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            DocxMerge docxMerge = this.mergeBodyWithBlip(WordprocessingMLPackage.load((InputStream)is));
            return docxMerge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocxMerge mergeBodyWithBlip(InputStream is) throws Exception {
        if (is == null) {
            throw new IllegalArgumentException("An is must not be null!");
        }
        try {
            DocxMerge docxMerge = this.mergeBodyWithBlip(WordprocessingMLPackage.load((InputStream)is));
            return docxMerge;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public DocxMerge mergeBodyWithBlip(File f) throws Exception {
        if (f == null) {
            throw new IllegalArgumentException("A file f must not be null!");
        }
        return this.mergeBodyWithBlip(WordprocessingMLPackage.load((File)f));
    }

    public DocxMerge mergeBodyWithBlip(WordprocessingMLPackage e) throws Exception {
        if (e == null) {
            throw new IllegalArgumentException("A WordprocessingMLPackage e must not be null!");
        }
        List body2 = e.getMainDocumentPart().getJAXBNodesViaXPath("//w:body", false);
        for (Object b : body2) {
            List filhos = ((Body)b).getContent();
            for (Object k : filhos) {
                this.mainDoc.getMainDocumentPart().addObject(k);
            }
        }
        List blips = e.getMainDocumentPart().getJAXBNodesViaXPath("//a:blip", false);
        for (Object el : blips) {
            CTBlip blip = (CTBlip)el;
            RelationshipsPart parts = e.getMainDocumentPart().getRelationshipsPart();
            Relationship rel = parts.getRelationshipByID(blip.getEmbed());
            Part part = parts.getPart(rel);
            Relationship newrel = this.mainDoc.getMainDocumentPart().addTargetPart(part, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
            blip.setEmbed(newrel.getId());
            this.mainDoc.getMainDocumentPart().addTargetPart((Part)e.getParts().getParts().get(new PartName("/word/" + rel.getTarget())));
        }
        return this;
    }
}

