/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.debug.breakpoint;

import com.github.jlangch.venice.impl.debug.breakpoint.BreakpointFnRef;
import com.github.jlangch.venice.impl.debug.breakpoint.Selector;
import com.github.jlangch.venice.impl.types.util.QualifiedName;
import com.github.jlangch.venice.impl.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class BreakpointFn
implements Comparable<BreakpointFn> {
    private static Comparator<BreakpointFn> comp = Comparator.comparing(BreakpointFn::getQualifiedFnName);
    private final BreakpointFnRef ref;
    private final QualifiedName qn;
    private final List<Selector> selectors;

    public BreakpointFn(QualifiedName qualifiedName) {
        this(qualifiedName, new ArrayList<Selector>());
    }

    public BreakpointFn(QualifiedName qualifiedName, Selector selector) {
        this(qualifiedName, CollectionUtil.toList(selector));
    }

    public BreakpointFn(QualifiedName qualifiedName, List<Selector> selectors) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("A qualifiedName must not be null");
        }
        this.ref = new BreakpointFnRef(qualifiedName.getQualifiedName());
        this.qn = qualifiedName;
        this.selectors = new ArrayList<Selector>();
        if (selectors == null || selectors.isEmpty()) {
            this.selectors.add(new Selector());
        } else {
            this.selectors.addAll(selectors);
        }
    }

    public BreakpointFn merge(List<Selector> newSelectors) {
        if (newSelectors == null || newSelectors.isEmpty()) {
            return this;
        }
        List<Selector> mergedSelectors = new ArrayList<Selector>(this.selectors);
        for (Selector other : newSelectors) {
            Selector match = this.findSelectorByMatchingAncestor(other, mergedSelectors);
            if (match != null) {
                mergedSelectors = mergedSelectors.stream().filter(s -> !s.hasSameAncestorSelector(match)).collect(Collectors.toList());
            }
            mergedSelectors.add(other);
        }
        return new BreakpointFn(this.qn, mergedSelectors);
    }

    public String getQualifiedFnName() {
        return this.qn.getQualifiedName();
    }

    public String getNamespace() {
        return this.qn.getNamespace();
    }

    public String getSimpleFnName() {
        return this.qn.getSimpleName();
    }

    public List<Selector> getSelectors() {
        return Collections.unmodifiableList(this.selectors);
    }

    public BreakpointFnRef getBreakpointRef() {
        return this.ref;
    }

    public List<String> format(boolean useDescriptiveScopeNames) {
        return this.selectors.stream().map(s -> s.formatForBaseFn(this.qn.getQualifiedName(), useDescriptiveScopeNames)).collect(Collectors.toList());
    }

    public String toString() {
        return this.format(false).stream().collect(Collectors.joining("\n"));
    }

    public int hashCode() {
        return this.qn.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BreakpointFn other = (BreakpointFn)obj;
        return this.qn.equals(other.qn);
    }

    @Override
    public int compareTo(BreakpointFn o) {
        return comp.compare(this, o);
    }

    private Selector findSelectorByMatchingAncestor(Selector candidate, List<Selector> selectors) {
        return selectors.stream().filter(s -> s.hasSameAncestorSelector(candidate)).findFirst().orElse(null);
    }
}

