/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet.section;

import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItem;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItemBuilder;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.ISectionBuilder;

public class PrimitivesSection
implements ISectionBuilder {
    private final DocItemBuilder diBuilder;

    public PrimitivesSection(DocItemBuilder diBuilder) {
        this.diBuilder = diBuilder;
    }

    @Override
    public DocSection section() {
        DocSection section = new DocSection("Primitives", "primitives");
        DocSection lit = new DocSection("Literals", "primitives.literals");
        section.addSection(lit);
        lit.addLiteralItem("Nil", "nil", this.id());
        lit.addLiteralItem("Boolean", "true, false", this.id());
        lit.addLiteralItem("Integer", "150I, 1_000_000I, 0x1FFI", this.id());
        lit.addLiteralItem("Long", "1500, 1_000_000, 0x00A055FF", this.id());
        lit.addLiteralItem("Double", "3.569, 2.0E+10", this.id());
        lit.addLiteralItem("BigDecimal", "6.897M, 2.345E+10M", this.id());
        lit.addLiteralItem("BigInteger", "1000N, 1_000_000N", this.id());
        lit.addLiteralItem("Char", "#\\A, #\\\u03c0, #\\u03C0", this.id());
        lit.addLiteralItem("", "#\\space, #\\newline, #\\return, #\\tab, #\\formfeed, #\\backspace, #\\lparen, #\\rparen, #\\quote", this.id());
        lit.addLiteralItem("String", "\"abcd\", \"ab\\\"cd\", \"PI: \\u03C0\"", this.id());
        lit.addLiteralItem("", "\"\"\"{ \"age\": 42 }\"\"\"", this.id());
        lit.addLiteralItem("String interpolation", "\"~{x}\", \"\"\"~{x}\"\"\"", this.id());
        lit.addLiteralItem("", "\"~(inc x)\", \"\"\"~(inc x)\"\"\"", this.id());
        DocSection numbers = new DocSection("Numbers", "primitives.numbers");
        section.addSection(numbers);
        DocSection arithmetic = new DocSection("Arithmetic", "primitives.arithmetic");
        numbers.addSection(arithmetic);
        arithmetic.addItem(this.diBuilder.getDocItem("+"));
        arithmetic.addItem(this.diBuilder.getDocItem("-"));
        arithmetic.addItem(this.diBuilder.getDocItem("*"));
        arithmetic.addItem(this.diBuilder.getDocItem("/"));
        DocSection convert = new DocSection("Convert", "primitives.convert");
        numbers.addSection(convert);
        convert.addItem(this.diBuilder.getDocItem("int"));
        convert.addItem(this.diBuilder.getDocItem("long"));
        convert.addItem(this.diBuilder.getDocItem("double"));
        convert.addItem(this.diBuilder.getDocItem("decimal"));
        convert.addItem(this.diBuilder.getDocItem("bigint"));
        DocSection compare = new DocSection("Compare", "primitives.compare");
        numbers.addSection(compare);
        compare.addItem(this.diBuilder.getDocItem("=="));
        compare.addItem(this.diBuilder.getDocItem("="));
        compare.addItem(this.diBuilder.getDocItem("not="));
        compare.addItem(this.diBuilder.getDocItem("<"));
        compare.addItem(this.diBuilder.getDocItem(">"));
        compare.addItem(this.diBuilder.getDocItem("<="));
        compare.addItem(this.diBuilder.getDocItem(">="));
        compare.addItem(this.diBuilder.getDocItem("compare"));
        DocSection test = new DocSection("Test", "primitives.test");
        numbers.addSection(test);
        test.addItem(this.diBuilder.getDocItem("zero?"));
        test.addItem(this.diBuilder.getDocItem("pos?"));
        test.addItem(this.diBuilder.getDocItem("neg?"));
        test.addItem(this.diBuilder.getDocItem("even?"));
        test.addItem(this.diBuilder.getDocItem("odd?"));
        test.addItem(this.diBuilder.getDocItem("number?"));
        test.addItem(this.diBuilder.getDocItem("int?"));
        test.addItem(this.diBuilder.getDocItem("long?"));
        test.addItem(this.diBuilder.getDocItem("double?"));
        test.addItem(this.diBuilder.getDocItem("decimal?"));
        DocSection nan = new DocSection("NaN/Infinite", "primitives.nan");
        numbers.addSection(nan);
        nan.addItem(this.diBuilder.getDocItem("nan?"));
        nan.addItem(this.diBuilder.getDocItem("infinite?"));
        DocSection bigdecimal = new DocSection("BigDecimal", "primitives.bigdecimal");
        numbers.addSection(bigdecimal);
        bigdecimal.addItem(this.diBuilder.getDocItem("dec/add"));
        bigdecimal.addItem(this.diBuilder.getDocItem("dec/sub"));
        bigdecimal.addItem(this.diBuilder.getDocItem("dec/mul"));
        bigdecimal.addItem(this.diBuilder.getDocItem("dec/div"));
        bigdecimal.addItem(this.diBuilder.getDocItem("dec/scale"));
        DocSection strings = new DocSection("Strings", "primitives.strings");
        section.addSection(strings);
        DocSection create = new DocSection("Create", "primitives.strings.create");
        strings.addSection(create);
        create.addItem(this.diBuilder.getDocItem("str"));
        DocSection use = new DocSection("Use", "primitives.strings.use");
        strings.addSection(use);
        use.addItem(this.diBuilder.getDocItem("count"));
        use.addItem(this.diBuilder.getDocItem("compare"));
        use.addItem(this.diBuilder.getDocItem("empty-to-nil"));
        use.addItem(this.diBuilder.getDocItem("first"));
        use.addItem(this.diBuilder.getDocItem("last"));
        use.addItem(this.diBuilder.getDocItem("nth"));
        use.addItem(this.diBuilder.getDocItem("nfirst"));
        use.addItem(this.diBuilder.getDocItem("nlast"));
        use.addItem(this.diBuilder.getDocItem("seq"));
        use.addItem(this.diBuilder.getDocItem("rest"));
        use.addItem(this.diBuilder.getDocItem("butlast"));
        use.addItem(this.diBuilder.getDocItem("reverse"));
        use.addItem(this.diBuilder.getDocItem("shuffle"));
        use.addItem(this.diBuilder.getDocItem("str/subs"));
        use.addItem(this.diBuilder.getDocItem("str/nfirst"));
        use.addItem(this.diBuilder.getDocItem("str/nlast"));
        use.addItem(this.diBuilder.getDocItem("str/rest"));
        use.addItem(this.diBuilder.getDocItem("str/nrest"));
        use.addItem(this.diBuilder.getDocItem("str/butlast"));
        use.addItem(this.diBuilder.getDocItem("str/butnlast"));
        use.addItem(this.diBuilder.getDocItem("str/chars"));
        use.addItem(this.diBuilder.getDocItem("str/pos"));
        use.addItem(this.diBuilder.getDocItem("str/repeat"));
        use.addItem(this.diBuilder.getDocItem("str/reverse"));
        use.addItem(this.diBuilder.getDocItem("str/lorem-ipsum"));
        DocSection index = new DocSection("Index", "primitives.strings.index");
        strings.addSection(index);
        index.addItem(this.diBuilder.getDocItem("str/index-of"));
        index.addItem(this.diBuilder.getDocItem("str/index-of-char"));
        index.addItem(this.diBuilder.getDocItem("str/index-of-not-char"));
        index.addItem(this.diBuilder.getDocItem("str/last-index-of"));
        DocSection split = new DocSection("Split/Join", "primitives.strings.splitjoin");
        strings.addSection(split);
        split.addItem(this.diBuilder.getDocItem("str/split"));
        split.addItem(this.diBuilder.getDocItem("str/split-at"));
        split.addItem(this.diBuilder.getDocItem("str/split-lines"));
        split.addItem(this.diBuilder.getDocItem("str/split-columns"));
        split.addItem(this.diBuilder.getDocItem("str/join"));
        DocSection replace = new DocSection("Replace", "primitives.strings.replace");
        strings.addSection(replace);
        replace.addItem(this.diBuilder.getDocItem("str/replace-first"));
        replace.addItem(this.diBuilder.getDocItem("str/replace-last"));
        replace.addItem(this.diBuilder.getDocItem("str/replace-all"));
        DocSection strip = new DocSection("Strip", "primitives.strings.strip");
        strings.addSection(strip);
        strip.addItem(this.diBuilder.getDocItem("str/strip-start"));
        strip.addItem(this.diBuilder.getDocItem("str/strip-end"));
        strip.addItem(this.diBuilder.getDocItem("str/strip-indent"));
        strip.addItem(this.diBuilder.getDocItem("str/strip-margin"));
        DocSection conv = new DocSection("Conversion", "primitives.strings.conversion");
        strings.addSection(conv);
        conv.addItem(this.diBuilder.getDocItem("str/lower-case"));
        conv.addItem(this.diBuilder.getDocItem("str/upper-case"));
        conv.addItem(this.diBuilder.getDocItem("str/cr-lf", false));
        DocSection regex = new DocSection("Regex", "primitives.strings.regex");
        strings.addSection(regex);
        regex.addItem(this.diBuilder.getDocItem("match?"));
        regex.addItem(this.diBuilder.getDocItem("not-match?"));
        DocSection trim = new DocSection("Trim", "primitives.strings.trim");
        strings.addSection(trim);
        trim.addItem(this.diBuilder.getDocItem("str/trim"));
        trim.addItem(this.diBuilder.getDocItem("str/trim-to-empty"));
        trim.addItem(this.diBuilder.getDocItem("str/trim-to-nil"));
        trim.addItem(this.diBuilder.getDocItem("str/trim-left"));
        trim.addItem(this.diBuilder.getDocItem("str/trim-right"));
        DocSection format = new DocSection("Format", "primitives.strings.format");
        strings.addSection(format);
        format.addItem(this.diBuilder.getDocItem("str/format"));
        format.addItem(this.diBuilder.getDocItem("str/quote"));
        format.addItem(this.diBuilder.getDocItem("str/double-quote"));
        format.addItem(this.diBuilder.getDocItem("str/double-unquote"));
        format.addItem(this.diBuilder.getDocItem("str/align"));
        format.addItem(this.diBuilder.getDocItem("str/wrap"));
        format.addItem(this.diBuilder.getDocItem("str/expand"));
        format.addItem(this.diBuilder.getDocItem("str/truncate"));
        DocSection hex = new DocSection("Hex", "primitives.strings.hex");
        strings.addSection(hex);
        hex.addItem(this.diBuilder.getDocItem("str/hex-to-bytebuf"));
        hex.addItem(this.diBuilder.getDocItem("str/bytebuf-to-hex"));
        hex.addItem(this.diBuilder.getDocItem("str/format-bytebuf"));
        DocSection bytebuf = new DocSection("Bytebuf", "primitives.strings.bytebuf");
        strings.addSection(bytebuf);
        bytebuf.addItem(this.diBuilder.getDocItem("bytebuf-from-string"));
        bytebuf.addItem(this.diBuilder.getDocItem("bytebuf-to-string"));
        DocSection encode = new DocSection("Encode/Decode", "primitives.strings.encode");
        strings.addSection(encode);
        encode.addItem(this.diBuilder.getDocItem("str/encode-base64"));
        encode.addItem(this.diBuilder.getDocItem("str/decode-base64"));
        encode.addItem(this.diBuilder.getDocItem("str/encode-url"));
        encode.addItem(this.diBuilder.getDocItem("str/decode-url"));
        encode.addItem(this.diBuilder.getDocItem("str/escape-html"));
        encode.addItem(this.diBuilder.getDocItem("str/escape-xml"));
        DocSection str_test = new DocSection("Test", "primitives.strings.test");
        strings.addSection(str_test);
        str_test.addItem(this.diBuilder.getDocItem("string?"));
        str_test.addItem(this.diBuilder.getDocItem("empty?"));
        str_test.addItem(this.diBuilder.getDocItem("not-empty?"));
        str_test.addItem(this.diBuilder.getDocItem("str/blank?"));
        str_test.addItem(this.diBuilder.getDocItem("str/not-blank?"));
        str_test.addItem(this.diBuilder.getDocItem("str/starts-with?"));
        str_test.addItem(this.diBuilder.getDocItem("str/ends-with?"));
        str_test.addItem(this.diBuilder.getDocItem("str/contains?"));
        str_test.addItem(this.diBuilder.getDocItem("str/equals-ignore-case?"));
        str_test.addItem(this.diBuilder.getDocItem("str/quoted?"));
        str_test.addItem(this.diBuilder.getDocItem("str/double-quoted?"));
        DocSection str_test_char = new DocSection("Test char", "primitives.strings.testchar");
        strings.addSection(str_test_char);
        str_test_char.addItem(this.diBuilder.getDocItem("str/char?"));
        str_test_char.addItem(this.diBuilder.getDocItem("str/digit?"));
        str_test_char.addItem(this.diBuilder.getDocItem("str/hexdigit?"));
        str_test_char.addItem(this.diBuilder.getDocItem("str/letter?"));
        str_test_char.addItem(this.diBuilder.getDocItem("str/whitespace?"));
        str_test_char.addItem(this.diBuilder.getDocItem("str/linefeed?"));
        str_test_char.addItem(this.diBuilder.getDocItem("str/lower-case?"));
        str_test_char.addItem(this.diBuilder.getDocItem("str/upper-case?"));
        DocSection utf = new DocSection("UTF", "primitives.strings.utf");
        strings.addSection(utf);
        utf.addItem(this.diBuilder.getDocItem("str/normalize-utf"));
        DocSection validation = new DocSection("Validation", "primitives.strings.validation");
        strings.addSection(validation);
        validation.addItem(this.diBuilder.getDocItem("str/valid-email-addr?"));
        DocSection str_leven_char = new DocSection("Other", "primitives.strings.other");
        strings.addSection(str_leven_char);
        str_leven_char.addItem(this.diBuilder.getDocItem("str/levenshtein"));
        DocSection chars = new DocSection("Chars", "primitives.chars");
        section.addSection(chars);
        DocSection charuse = new DocSection("Use", this.id());
        chars.addSection(charuse);
        charuse.addItem(this.diBuilder.getDocItem("char"));
        charuse.addItem(this.diBuilder.getDocItem("char?"));
        charuse.addItem(this.diBuilder.getDocItem("char-escaped"));
        charuse.addItem(this.diBuilder.getDocItem("char-literals", false));
        DocSection charconv = new DocSection("Conversion", "primitives.chars.conversion");
        chars.addSection(charconv);
        charconv.addItem(this.diBuilder.getDocItem("str"));
        charconv.addItem(this.diBuilder.getDocItem("str/lower-case"));
        charconv.addItem(this.diBuilder.getDocItem("str/upper-case"));
        DocSection chartest = new DocSection("Test char", "primitives.chars.test");
        chars.addSection(chartest);
        chartest.addItem(this.diBuilder.getDocItem("str/char?"));
        chartest.addItem(this.diBuilder.getDocItem("str/digit?"));
        chartest.addItem(this.diBuilder.getDocItem("str/letter?"));
        chartest.addItem(this.diBuilder.getDocItem("str/whitespace?"));
        chartest.addItem(this.diBuilder.getDocItem("str/linefeed?"));
        chartest.addItem(this.diBuilder.getDocItem("str/lower-case?"));
        chartest.addItem(this.diBuilder.getDocItem("str/upper-case?"));
        DocSection bool_ = new DocSection("Booleans", "primitives.booleans");
        section.addSection(bool_);
        DocSection bool = new DocSection("Boolean", this.id());
        bool_.addSection(bool);
        bool.addItem(new DocItem("true false", null));
        bool.addItem(this.diBuilder.getDocItem("boolean"));
        bool.addItem(this.diBuilder.getDocItem("not"));
        bool.addItem(this.diBuilder.getDocItem("boolean?"));
        bool.addItem(this.diBuilder.getDocItem("true?"));
        bool.addItem(this.diBuilder.getDocItem("false?"));
        DocSection keywords_ = new DocSection("Keywords", "primitives.keywords");
        section.addSection(keywords_);
        DocSection keywords = new DocSection("Keyword", this.id());
        keywords_.addSection(keywords);
        keywords.addItem(new DocItem(":a :blue", null));
        keywords.addItem(this.diBuilder.getDocItem("keyword?"));
        keywords.addItem(this.diBuilder.getDocItem("keyword"));
        DocSection symbols_ = new DocSection("Symbols", "primitives.symbols");
        section.addSection(symbols_);
        DocSection symbols = new DocSection("Symbol", this.id());
        symbols_.addSection(symbols);
        symbols.addItem(new DocItem("'a 'blue", null));
        symbols.addItem(this.diBuilder.getDocItem("symbol?"));
        symbols.addItem(this.diBuilder.getDocItem("qualified-symbol?"));
        symbols.addItem(this.diBuilder.getDocItem("symbol"));
        DocSection nil_ = new DocSection("Nil", "primitives.nil");
        section.addSection(nil_);
        DocSection nil = new DocSection("Nil", this.id());
        nil_.addSection(nil);
        nil.addItem(new DocItem("nil", null));
        nil.addItem(this.diBuilder.getDocItem("nil?"));
        nil.addItem(this.diBuilder.getDocItem("some?"));
        DocSection just_ = new DocSection("Just", "primitives.just");
        section.addSection(just_);
        DocSection just = new DocSection("Just", this.id());
        just_.addSection(just);
        just.addItem(this.diBuilder.getDocItem("just"));
        just.addItem(this.diBuilder.getDocItem("just?"));
        return section;
    }

    private String id() {
        return this.diBuilder.id();
    }
}

