/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.reader;

import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.impl.reader.HighlightClass;
import com.github.jlangch.venice.impl.reader.HighlightItem;
import com.github.jlangch.venice.impl.reader.Reader;
import com.github.jlangch.venice.impl.reader.Token;
import com.github.jlangch.venice.impl.reader.TokenType;
import com.github.jlangch.venice.impl.reader.Tokenizer;
import com.github.jlangch.venice.impl.specialforms.SpecialForms;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HighlightParser {
    private static Set<String> SYSTEM_VARS = new HashSet<String>(Arrays.asList("*version*", "*newline*", "*loaded-modules*", "*loaded-files*", "*ns*", "*run-mode*", "*ansi-term*"));
    private static Set<String> CORE_MACROS = new HashSet<String>(Arrays.asList("assert", "and", "or", "cond", "condp", "case", "when", "when-not", "coalesce", "if-let", "when-let", "dotimes", "while", "doto", "->", "->>", "-<>", "as->", "cond->", "cond->>", "some->", "some->>", "list-comp", "doseq", "time", "perf", "load-string", "load-file", "load-classpath-file", "load-module", "with-sh-dir", "with-sh-throw", "with-out-str", "with-err-str", "delay"));
    private final String form;
    private final List<HighlightItem> items = new ArrayList<HighlightItem>();
    private final List<Token> tokens;
    private int position;
    private HighlightClass pinnedClass = null;

    private HighlightParser(String form, List<Token> formTokens) {
        this.form = form;
        this.tokens = formTokens;
        this.position = 0;
    }

    public static List<HighlightItem> parse(String str) {
        List<Token> tokens = Tokenizer.tokenize(str, "highlighter", false, false, false);
        HighlightParser hl = new HighlightParser(str, tokens);
        try {
            hl.process_form();
            hl.finish();
            return hl.items();
        }
        catch (EofException ex) {
            return hl.items();
        }
    }

    private List<HighlightItem> items() {
        return this.items;
    }

    private void addItem(String token, HighlightClass clazz) {
        this.items.add(new HighlightItem(token, this.pinnedClass == null ? clazz : this.pinnedClass));
    }

    private void addItem(char token, HighlightClass clazz) {
        this.addItem(String.valueOf(token), clazz);
    }

    private Token peek() {
        Token token;
        while (true) {
            if (this.position >= this.tokens.size()) {
                throw new EofException("Unexpected EOF");
            }
            token = this.tokens.get(this.position);
            if (token.isWhitespaces()) {
                this.addItem(token.getToken(), HighlightClass.WHITESPACES);
                ++this.position;
                continue;
            }
            if (!token.isComment()) break;
            this.addItem(token.getToken(), HighlightClass.COMMENT);
            ++this.position;
        }
        return token;
    }

    private Token next() {
        Token t = this.peek();
        ++this.position;
        return t;
    }

    private void process_atom() {
        Token token = this.next();
        String sToken = token.getToken();
        switch (Reader.getAtomType(token)) {
            case NIL: 
            case TRUE: 
            case FALSE: {
                this.addItem(sToken, HighlightClass.CONSTANT);
                break;
            }
            case INTEGER: 
            case LONG: 
            case DOUBLE: 
            case DECIMAL: 
            case BIGINT: {
                this.addItem(sToken, HighlightClass.NUMBER);
                break;
            }
            case STRING: {
                this.addItem(sToken, HighlightClass.STRING);
                break;
            }
            case STRING_BLOCK: {
                this.addItem(sToken, HighlightClass.STRING);
                break;
            }
            case KEYWORD: {
                this.addItem(sToken, HighlightClass.KEYWORD);
                break;
            }
            case SYMBOL: {
                HighlightItem secondLast;
                HighlightItem last = this.items.size() < 1 ? null : this.items.get(this.items.size() - 1);
                HighlightItem highlightItem = secondLast = this.items.size() < 2 ? null : this.items.get(this.items.size() - 2);
                if (last != null && last.getClazz() == HighlightClass.PARENTHESIS_BEGIN) {
                    if (secondLast != null && secondLast.getClazz() == HighlightClass.QUOTE) {
                        this.addItem(sToken, HighlightClass.SYMBOL);
                        break;
                    }
                    if (SpecialForms.isSpecialForm(sToken)) {
                        this.addItem(sToken, HighlightClass.SYMBOL_SPECIAL_FORM);
                        break;
                    }
                    if (SYSTEM_VARS.contains(sToken)) {
                        this.addItem(sToken, HighlightClass.SYMBOL_SPECIAL_FORM);
                        break;
                    }
                    if (CORE_MACROS.contains(sToken)) {
                        this.addItem(sToken, HighlightClass.SYMBOL_MACRO_NAME);
                        break;
                    }
                    if (sToken.startsWith("*") && sToken.endsWith("*")) {
                        this.addItem(sToken, HighlightClass.SYMBOL_EAR_MUFFS);
                        break;
                    }
                    this.addItem(sToken, HighlightClass.SYMBOL_FUNCTION_NAME);
                    break;
                }
                this.addItem(sToken, HighlightClass.SYMBOL);
                break;
            }
            default: {
                this.addItem(sToken, HighlightClass.UNKNOWN);
            }
        }
    }

    private void process_list(char start, char end) {
        Token startTok = this.next();
        this.addItem(startTok.getToken(), this.parenToClass(start));
        Token token = this.peek();
        while (token.charAt(0) != end) {
            this.process_form();
            token = this.peek();
        }
        Token endTok = this.next();
        this.addItem(endTok.getToken(), this.parenToClass(end));
    }

    private void process_form() {
        Token token = this.peek();
        switch (token.charAt(0)) {
            case '\'': {
                this.next();
                this.addItem('\'', HighlightClass.QUOTE);
                this.process_form();
                break;
            }
            case '`': {
                this.next();
                this.addItem('`', HighlightClass.QUASI_QUOTE);
                this.process_form();
                break;
            }
            case '~': {
                if (token.equals("~")) {
                    this.next();
                    this.addItem('~', HighlightClass.UNQUOTE);
                    this.process_form();
                    break;
                }
                this.next();
                this.addItem("~@", HighlightClass.UNQUOTE_SPLICING);
                this.process_form();
                break;
            }
            case '^': {
                this.next();
                this.addItem('^', HighlightClass.META);
                this.pinnedClass = HighlightClass.META;
                this.process_form();
                this.pinnedClass = null;
                break;
            }
            case '@': {
                this.next();
                this.addItem("@", HighlightClass.AT);
                this.process_form();
                break;
            }
            case '#': {
                String sToken = token.getToken();
                this.next();
                if (sToken.length() == 1) {
                    this.addItem("#", HighlightClass.HASH);
                    Token t = this.peek();
                    if (t.charAt(0) == '{') {
                        this.process_list('{', '}');
                        break;
                    }
                    if (t.charAt(0) == '(') {
                        this.process_list('(', ')');
                        break;
                    }
                    if (t.getType() != TokenType.STRING) break;
                    this.next();
                    String s = t.getToken();
                    if (!s.startsWith("\"")) break;
                    this.addItem(s, HighlightClass.STRING);
                    break;
                }
                this.addItem(sToken, HighlightClass.UNKNOWN);
                break;
            }
            case '(': {
                this.process_list('(', ')');
                break;
            }
            case ')': {
                this.next();
                this.addItem(')', HighlightClass.PARENTHESIS_END);
                break;
            }
            case '[': {
                this.process_list('[', ']');
                break;
            }
            case ']': {
                this.next();
                this.addItem(']', HighlightClass.BRACKET_END);
                break;
            }
            case '{': {
                this.process_list('{', '}');
                break;
            }
            case '}': {
                this.next();
                this.addItem('}', HighlightClass.BRACE_END);
                break;
            }
            default: {
                this.process_atom();
            }
        }
    }

    private HighlightClass parenToClass(char ch) {
        switch (ch) {
            case '(': {
                return HighlightClass.PARENTHESIS_BEGIN;
            }
            case ')': {
                return HighlightClass.PARENTHESIS_END;
            }
            case '[': {
                return HighlightClass.BRACKET_BEGIN;
            }
            case ']': {
                return HighlightClass.BRACKET_END;
            }
            case '{': {
                return HighlightClass.BRACE_BEGIN;
            }
            case '}': {
                return HighlightClass.BRACE_END;
            }
        }
        throw new RuntimeException("Invalid parenthesis '" + ch + "'");
    }

    private void finish() {
        while (this.hasUnprocessedTokens()) {
            Token tok = this.next();
            if (tok.getType() == TokenType.COMMENT) {
                this.addItem(tok.getToken(), HighlightClass.COMMENT);
                continue;
            }
            if (tok.getType() == TokenType.WHITESPACES) {
                this.addItem(tok.getToken(), HighlightClass.WHITESPACES);
                continue;
            }
            this.addItem(this.form.substring(tok.getFileStartPos()), HighlightClass.UNPROCESSED);
            break;
        }
    }

    private boolean hasUnprocessedTokens() {
        return this.position < this.tokens.size();
    }
}

