/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.impl.util.StringUtil;
import java.io.File;

public class ReplDirs {
    private final File homeDir;
    private final File libsDir;
    private final File fontsDir;
    private final File scriptsDir;

    private ReplDirs() {
        this.homeDir = null;
        this.libsDir = null;
        this.fontsDir = null;
        this.scriptsDir = null;
    }

    private ReplDirs(File homeDir, File libsDir, File fontsDir, File scriptsDir) {
        this.homeDir = homeDir;
        this.libsDir = libsDir;
        this.fontsDir = fontsDir;
        this.scriptsDir = scriptsDir;
    }

    public static ReplDirs create() {
        File homeDir = ReplDirs.getReplHomeDir();
        if (homeDir != null) {
            File libsDir = new File(homeDir, "libs");
            File fontsDir = new File(homeDir, "fonts");
            File scriptsDir = new File(homeDir, "scripts");
            return new ReplDirs(homeDir.isDirectory() ? homeDir : null, libsDir.isDirectory() ? libsDir : null, fontsDir.isDirectory() ? fontsDir : null, scriptsDir.isDirectory() ? scriptsDir : null);
        }
        return new ReplDirs();
    }

    public static ReplDirs notavail() {
        return new ReplDirs();
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public File getLibsDir() {
        return this.libsDir;
    }

    public File getFontsDir() {
        return this.fontsDir;
    }

    public File getScriptsDir() {
        return this.scriptsDir;
    }

    public boolean valid() {
        return this.homeDir != null;
    }

    private static File getReplHomeDir() {
        String home = StringUtil.trimToNull(System.getProperty("venice.repl.home"));
        return home == null ? null : new File(home);
    }
}

