/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.ValueException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.repl.ReplConfig;
import com.github.jlangch.venice.impl.types.VncVal;
import java.util.function.Consumer;
import org.repackage.org.jline.terminal.Terminal;

public class TerminalPrinter {
    private final Object lock = new Object();
    private final Terminal terminal;
    private final boolean ansiTerminal;
    private final ReplConfig config;
    private boolean printJavaEx;

    public TerminalPrinter(ReplConfig config, Terminal terminal, boolean ansiTerminal, boolean printJavaEx) {
        this.config = config;
        this.terminal = terminal;
        this.ansiTerminal = ansiTerminal;
        this.printJavaEx = printJavaEx;
    }

    public void setPrintJavaEx(boolean printJavaEx) {
        this.printJavaEx = printJavaEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String colorID, Consumer<Terminal> fn) {
        Object object = this.lock;
        synchronized (object) {
            String color = this.getColor(colorID);
            if (color == null) {
                fn.accept(this.terminal);
                this.terminal.flush();
            } else {
                try {
                    this.terminal.writer().print(color);
                    fn.accept(this.terminal);
                }
                finally {
                    this.terminal.writer().print("\u001b[0m");
                    this.terminal.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            this.terminal.writer().println();
            this.terminal.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String colorID, String text) {
        Object object = this.lock;
        synchronized (object) {
            this.print(colorID, t -> t.writer().print(text));
            this.terminal.writer().println();
            this.terminal.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printex(String colorID, Throwable ex) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (ex instanceof ValueException) {
                    this.print(colorID, t -> ((ValueException)ex).printVeniceStackTrace(t.writer()));
                    this.println(colorID, "\nThrown value: " + Printer.pr_str((VncVal)((ValueException)ex).getValue(), false));
                } else if (ex instanceof VncException) {
                    if (this.printJavaEx) {
                        this.print(colorID, t -> ex.printStackTrace(t.writer()));
                    } else {
                        this.print(colorID, t -> ((VncException)ex).printVeniceStackTrace(t.writer()));
                    }
                } else {
                    this.print(colorID, t -> ex.printStackTrace(t.writer()));
                }
            }
            catch (Throwable e) {
                System.out.println("Internal REPL error while printing exception.");
                e.printStackTrace();
            }
        }
    }

    private String getColor(String colorID) {
        return this.ansiTerminal ? this.config.getColor(colorID) : null;
    }
}

