/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.block;

import com.github.jlangch.venice.impl.reader.LineReader;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.markdown.block.ListBlock;
import com.github.jlangch.venice.impl.util.markdown.block.TextBlock;
import com.github.jlangch.venice.impl.util.markdown.chunk.LineBreakChunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.RawChunk;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ListBlockParser {
    private final LineReader reader;

    public ListBlockParser(LineReader reader) {
        this.reader = reader;
    }

    public ListBlock parse() {
        if (this.reader.eof()) {
            return new ListBlock();
        }
        if (!ListBlockParser.isBlockStart(this.reader.peek())) {
            return new ListBlock();
        }
        ArrayList<String> lines = new ArrayList<String>();
        while (!this.reader.eof() && !StringUtil.isBlank(this.reader.peek())) {
            String line = this.reader.peek();
            this.reader.consume();
            lines.add(line);
        }
        ArrayList items = new ArrayList();
        ArrayList<String> itemLines = new ArrayList<String>();
        for (String line : lines) {
            if (ListBlockParser.isEmptyItem(line)) continue;
            if (ListBlockParser.isItemStart(line) && !itemLines.isEmpty()) {
                items.add(itemLines);
                itemLines = new ArrayList();
            }
            itemLines.add(line);
        }
        if (!itemLines.isEmpty()) {
            items.add(itemLines);
        }
        ListBlock block = new ListBlock();
        block.setOrdered(ListBlockParser.isOrderedItemStart((String)((List)items.get(0)).get(0)));
        for (List list : items) {
            String first = (String)list.get(0);
            if (ListBlockParser.isUnorderedItemStart(first)) {
                first = StringUtil.trimLeft(first);
                first = first.substring(1);
                String text = first = StringUtil.trimLeft(first);
                if (list.size() > 1) {
                    List rest = list.subList(1, list.size()).stream().map(l -> StringUtil.trimLeft(l)).collect(Collectors.toList());
                    text = text + " " + String.join((CharSequence)" ", rest);
                }
                TextBlock item = new TextBlock();
                this.addLine(item, StringUtil.trimRight(text));
                block.addItem(item);
                continue;
            }
            if (!ListBlockParser.isOrderedItemStart(first)) continue;
            int pos = first.indexOf(46);
            first = first.substring(pos + 1);
            String text = first = StringUtil.trimLeft(first);
            if (list.size() > 1) {
                List rest = list.subList(1, list.size()).stream().map(l -> StringUtil.trimLeft(l)).collect(Collectors.toList());
                text = text + " " + String.join((CharSequence)" ", rest);
            }
            TextBlock item = new TextBlock();
            this.addLine(item, StringUtil.trimRight(text));
            if (item.isEmpty()) continue;
            block.addItem(item);
        }
        block.parseChunks();
        return block;
    }

    public static boolean isBlockStart(String line) {
        return ListBlockParser.isItemStart(line);
    }

    public static boolean isItemStart(String line) {
        return ListBlockParser.isUnorderedItemStart(line) || ListBlockParser.isOrderedItemStart(line);
    }

    public static boolean isEmptyItem(String line) {
        return line.matches(" *[*] *") || line.matches(" *[0-9]+[.] *");
    }

    private static boolean isUnorderedItemStart(String line) {
        return line.matches(" *[*] +[^ ].*");
    }

    private static boolean isOrderedItemStart(String line) {
        return line.matches(" *[0-9]+[.] +[^ ].*");
    }

    private void addLine(TextBlock block, String line) {
        if (line.contains("\u00b6")) {
            String[] chunks = line.split("\u00b6");
            for (int ii = 0; ii < chunks.length; ++ii) {
                if (ii > 0) {
                    block.add(new LineBreakChunk());
                }
                block.add(new RawChunk(chunks[ii].trim()));
            }
            if (line.endsWith("\u00b6")) {
                block.add(new LineBreakChunk());
            }
        } else {
            block.add(new RawChunk(line));
        }
    }
}

