/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.excel;

import com.github.jlangch.venice.impl.util.excel.ExcelSheet;
import com.github.jlangch.venice.util.excel.DataRecord;
import com.github.jlangch.venice.util.excel.ExcelReader;
import com.github.jlangch.venice.util.excel.ExcelSheetWriter;
import java.time.LocalDateTime;

public class ExcelSheetReader {
    private final ExcelReader parentBuilder;
    private final ExcelSheet sheet;

    public ExcelSheetReader(ExcelReader reader, ExcelSheet sheet) {
        this.parentBuilder = reader;
        this.sheet = sheet;
    }

    public String getName() {
        return this.sheet.getName();
    }

    public int getIndex() {
        return this.sheet.getIndex() + 1;
    }

    public int getFirstRowNum() {
        int n = this.sheet.getFirstRowNum();
        return n < 0 ? n : n + 1;
    }

    public int getLastRowNum() {
        int n = this.sheet.getLastRowNum();
        return n < 0 ? n : n + 1;
    }

    public int getFirstCellNum(int row1) {
        int n = this.sheet.getFirstCellNum(row1 - 1);
        return n < 0 ? n : n + 1;
    }

    public int getLastCellNum(int row1) {
        int n = this.sheet.getLastCellNum(row1 - 1);
        return n;
    }

    public boolean isCellEmpty(int row1, int col1) {
        return this.sheet.isCellEmpty(row1 - 1, col1 - 1);
    }

    public String getCellType(int row1, int col1) {
        return this.sheet.getCellType(row1 - 1, col1 - 1);
    }

    public String getCellFormulaResultType(int row1, int col1) {
        return this.sheet.getCellFormulaResultType(row1 - 1, col1 - 1);
    }

    public String getCellAddress_A1_style(int row1, int col1) {
        return this.sheet.getCellAddress_A1_style(row1 - 1, col1 - 1);
    }

    public Object getValue(int row1, int col1) {
        return this.sheet.getValue(row1 - 1, col1 - 1);
    }

    public String getString(int row1, int col1) {
        return this.sheet.getString(row1 - 1, col1 - 1);
    }

    public Boolean getBoolean(int row1, int col1) {
        return this.sheet.getBoolean(row1 - 1, col1 - 1);
    }

    public Long getInteger(int row1, int col1) {
        return this.sheet.getInteger(row1 - 1, col1 - 1);
    }

    public Double getFloat(int row1, int col1) {
        return this.sheet.getFloat(row1 - 1, col1 - 1);
    }

    public LocalDateTime getDate(int row1, int col1) {
        return this.sheet.getDate(row1 - 1, col1 - 1);
    }

    public String getFormula(int row1, int col1) {
        return this.sheet.getFormula(row1 - 1, col1 - 1);
    }

    public String getErrorCode(int row1, int col1) {
        return this.sheet.getErrorCode(row1 - 1, col1 - 1);
    }

    public void evaluateAllFormulas() {
        this.sheet.evaluateAllFormulas();
    }

    public ExcelSheetWriter<DataRecord> writer() {
        return new ExcelSheetWriter<DataRecord>(this.parentBuilder.writer(), this.sheet);
    }
}

