/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.debug.agent.DebugAgent;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.List;

public class RecursionPoint {
    private final List<VncVal> loopBindingNames;
    private final int loopBindingNamesCount;
    private final VncList loopExpressions;
    private final Env loopEnv;
    private final VncVal meta;
    private final DebugAgent debugAgent;

    public RecursionPoint(List<VncVal> loopBindingNames, VncList loopExpressions, Env loopEnv, VncVal meta, DebugAgent debugAgent) {
        this.loopBindingNames = loopBindingNames;
        this.loopBindingNamesCount = loopBindingNames.size();
        this.loopExpressions = loopExpressions;
        this.loopEnv = loopEnv;
        this.meta = meta;
        this.debugAgent = debugAgent;
    }

    public int getLoopBindingNamesCount() {
        return this.loopBindingNamesCount;
    }

    public VncVal getLoopBindingName(int idx) {
        return this.loopBindingNames.get(idx);
    }

    public List<VncVal> getLoopBindingNames() {
        return this.loopBindingNames;
    }

    public VncList getLoopExpressions() {
        return this.loopExpressions;
    }

    public Env getLoopEnv() {
        return this.loopEnv;
    }

    public VncVal getMeta() {
        return this.meta;
    }

    public DebugAgent getDebugAgent() {
        return this.debugAgent;
    }

    public boolean isDebuggingActive() {
        return this.debugAgent != null;
    }

    public static void addToLocalEnv(VncVal symVal, VncVal bindVal, Env env) {
        if (Types.isVncSymbol(symVal)) {
            env.setLocal(new Var((VncSymbol)symVal, bindVal, Var.Scope.Local));
        } else {
            env.addLocalVars(Destructuring.destructure(symVal, bindVal));
        }
    }
}

