/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.concurrent;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class VncLock
extends VncVal
implements AutoCloseable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE = ":core/lock";
    private final Semaphore semaphore = new Semaphore(1);

    public VncLock lock() {
        this.semaphore.acquireUninterruptibly();
        return this;
    }

    public boolean tryAcquire() {
        return this.semaphore.tryAcquire();
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) {
        try {
            return this.semaphore.tryAcquire(timeout, unit);
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("Interrupted while acquiring lock");
        }
    }

    public boolean isLocked() {
        return this.semaphore.availablePermits() < 1;
    }

    @Override
    public void close() {
        this.unlock();
    }

    public void unlock() {
        this.semaphore.release();
    }

    @Override
    public VncVal withMeta(VncVal meta) {
        return this;
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE);
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.LOCK;
    }

    @Override
    public Object convertToJavaObject() {
        return this.semaphore;
    }
}

