/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.renderer.html;

import com.github.jlangch.venice.impl.util.StringEscapeUtil;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.markdown.Markdown;
import com.github.jlangch.venice.impl.util.markdown.block.Block;
import com.github.jlangch.venice.impl.util.markdown.block.CodeBlock;
import com.github.jlangch.venice.impl.util.markdown.block.ListBlock;
import com.github.jlangch.venice.impl.util.markdown.block.TableBlock;
import com.github.jlangch.venice.impl.util.markdown.block.TableColFmt;
import com.github.jlangch.venice.impl.util.markdown.block.TextBlock;
import com.github.jlangch.venice.impl.util.markdown.block.TitleBlock;
import com.github.jlangch.venice.impl.util.markdown.chunk.Chunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.Chunks;
import com.github.jlangch.venice.impl.util.markdown.chunk.InlineCodeChunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.LineBreakChunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.TextChunk;
import com.github.jlangch.venice.impl.util.markdown.chunk.UrlChunk;
import com.github.jlangch.venice.impl.util.markdown.renderer.text.TextTableUtil;
import java.io.PrintWriter;

public class HtmlRenderer {
    /*
     * Exception decompiling
     */
    public String render(Markdown md) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void render(Block b, PrintWriter wr) {
        if (b instanceof TitleBlock) {
            this.render((TitleBlock)b, wr);
        } else if (b instanceof TextBlock) {
            this.render((TextBlock)b, wr);
        } else if (b instanceof CodeBlock) {
            this.render((CodeBlock)b, wr);
        } else if (b instanceof ListBlock) {
            this.render((ListBlock)b, wr);
        } else if (b instanceof TableBlock) {
            this.render((TableBlock)b, wr);
        }
    }

    private void render(TextBlock block, PrintWriter wr) {
        wr.print("<div class=\"md-text-block\">");
        this.render(block.getChunks(), wr);
        wr.println("</div>");
    }

    private void render(TitleBlock block, PrintWriter wr) {
        switch (block.getLevel()) {
            case 1: {
                wr.println("<div class=\"md-h1\">" + StringEscapeUtil.escapeHtml(block.getText()) + "</div>");
                break;
            }
            case 2: {
                wr.println("<div class=\"md-h2\">" + StringEscapeUtil.escapeHtml(block.getText()) + "</div>");
                break;
            }
            case 3: {
                wr.println("<div class=\"md-h3\">" + StringEscapeUtil.escapeHtml(block.getText()) + "</div>");
                break;
            }
            case 4: {
                wr.println("<div class=\"md-h4\">" + StringEscapeUtil.escapeHtml(block.getText()) + "</div>");
                break;
            }
            default: {
                wr.println("<div class=\"md-h4\">" + StringEscapeUtil.escapeHtml(block.getText()) + "</div>");
            }
        }
    }

    private void render(CodeBlock block, PrintWriter wr) {
        String code = StringEscapeUtil.escapeHtml(String.join((CharSequence)"\n", block.getLines()));
        wr.println("<div class=\"md-code-block\">");
        wr.print("<code class=\"md-code\">" + code + "</code>");
        wr.println("</div>");
    }

    private void render(ListBlock block, PrintWriter wr) {
        wr.println("<div class=\"md-list-block\">");
        wr.println(block.isOrdered() ? "<ol class=\"md-list\">" : "<ul class=\"md-list\">");
        block.getItems().forEach(b -> {
            wr.print("<li>");
            this.render((Block)b, wr);
            wr.println("</li>");
        });
        wr.println(block.isOrdered() ? "</ol>" : "</ul>");
        wr.println("</div>");
    }

    private void render(TableBlock block, PrintWriter wr) {
        wr.println("<div class=\"md-table-block\">");
        wr.println("<table class=\"md-table\">");
        if (block.hasHeader()) {
            wr.println("<thead>");
            wr.println("<tr>");
            for (int col = 0; col < block.cols(); ++col) {
                TextChunk chunk = (TextChunk)block.headerCell(col).get(0);
                String header = StringEscapeUtil.escapeHtml(chunk.getText());
                String alignClass = this.buildCssAlignmentClass(block.format(col));
                String styles = this.buildCssStyles(block.format(col));
                if (styles.isEmpty()) {
                    wr.println("<th class=\"" + alignClass + "\">" + header + "</th>");
                    continue;
                }
                wr.println("<th style=\"" + styles + "\">" + header + "</th>");
            }
            wr.println("</tr>");
            wr.println("</thead>");
        }
        int[] colWitdhs = TextTableUtil.maxColWidths(block);
        boolean noWrapFirstCol = block.cols() == 2 && colWitdhs[0] < 25;
        wr.println("<tbody>");
        for (int row = 0; row < block.bodyRows(); ++row) {
            wr.println("<tr>");
            for (int col = 0; col < block.cols(); ++col) {
                Chunks chunks = block.bodyCell(row, col);
                String alignClass = this.buildCssAlignmentClass(block.format(col));
                String styles = this.buildCssStyles(block.format(col));
                if (styles.isEmpty()) {
                    wr.print("<td class=\"" + alignClass + "\">");
                } else {
                    wr.print("<td style=\"" + styles + "\">");
                }
                if (col == 0 && noWrapFirstCol) {
                    wr.print("<div style=\"display: inline-block; white-space: pre;\">");
                }
                this.render(chunks, wr);
                if (col == 0 && noWrapFirstCol) {
                    wr.print("</div>");
                }
                wr.println("</td>");
            }
            wr.println("</tr>");
        }
        wr.println("</tbody>");
        wr.println("</table>");
        wr.println("</div>");
    }

    private void render(Chunks chunks, PrintWriter wr) {
        chunks.getChunks().stream().filter(c -> !c.isEmpty()).forEach(c -> this.render((Chunk)c, wr));
    }

    private void render(Chunk c, PrintWriter wr) {
        if (c instanceof TextChunk) {
            this.render((TextChunk)c, wr);
        } else if (c instanceof LineBreakChunk) {
            this.render((LineBreakChunk)c, wr);
        } else if (c instanceof InlineCodeChunk) {
            this.render((InlineCodeChunk)c, wr);
        } else if (c instanceof UrlChunk) {
            this.render((UrlChunk)c, wr);
        }
    }

    private void render(TextChunk chunk, PrintWriter wr) {
        String text = StringEscapeUtil.escapeHtml(this.mapWhiteSpaces(chunk.getText()));
        String formatClass = this.buildCssEmphasizeClass(chunk.getFormat());
        wr.print("<div class=\"" + formatClass + "\">" + text + "</div>");
    }

    private void render(LineBreakChunk chunk, PrintWriter wr) {
        wr.print("<br/>");
    }

    private void render(InlineCodeChunk chunk, PrintWriter wr) {
        String text = StringEscapeUtil.escapeHtml(chunk.getText());
        wr.print("<div class=\"md-inline-code\">" + text + "</div>");
    }

    private void render(UrlChunk chunk, PrintWriter wr) {
        String url = chunk.getUrl();
        if (StringUtil.indexOneCharOf(url, "<>'\" ", 0) >= 0) {
            this.render(new TextChunk(url), wr);
        } else if (chunk.getCaption().isEmpty()) {
            String caption = StringEscapeUtil.escapeHtml(chunk.getUrl());
            wr.print("<a class=\"md-url\" href=\"" + url + "\">" + caption + "</a>");
        } else {
            String caption = StringEscapeUtil.escapeHtml(chunk.getCaption());
            wr.print("<a class=\"md-url\" href=\"" + url + "\">" + caption + "</a>");
        }
    }

    private String buildCssEmphasizeClass(TextChunk.Format format) {
        return "md-text-" + format.name().replace('_', '-').toLowerCase();
    }

    private String buildCssAlignmentClass(TableColFmt format) {
        TableColFmt.HorzAlignment alignment = format.horzAlignment();
        return "md-align-" + alignment.name().toLowerCase();
    }

    private String buildCssStyles(TableColFmt format) {
        String align = this.buildCssAlignmentStyle(format);
        String width = this.buildCssWidthStyle(format);
        if (align.isEmpty()) {
            return width;
        }
        if (width.isEmpty()) {
            return align;
        }
        return align + "; " + width;
    }

    private String buildCssAlignmentStyle(TableColFmt format) {
        TableColFmt.HorzAlignment alignment = format.horzAlignment();
        switch (alignment) {
            case LEFT: {
                return "text-align: left";
            }
            case CENTER: {
                return "text-align: center";
            }
            case RIGHT: {
                return "text-align: right";
            }
        }
        return "";
    }

    private String buildCssWidthStyle(TableColFmt format) {
        TableColFmt.Width w = format.width();
        switch (w.getUnit()) {
            case AUTO: {
                return "";
            }
            case PERCENT: {
                return "width: " + w.getValue() + "%";
            }
            case PX: {
                return "width: " + w.getValue() + "px";
            }
            case EM: {
                return "width: " + w.getValue() + "em";
            }
        }
        return "";
    }

    private String mapWhiteSpaces(String text) {
        String s = text;
        s = StringUtil.replace(s, "\t", "\u00a0\u00a0\u00a0\u00a0", -1, false);
        s = StringUtil.replace(s, "&nbsp;", "\u00a0", -1, false);
        s = StringUtil.replace(s, "&ensp;", "\u00a0\u00a0", -1, false);
        s = StringUtil.replace(s, "&emsp;", "\u00a0\u00a0\u00a0\u00a0", -1, false);
        return s;
    }

    private /* synthetic */ void lambda$render$1(PrintWriter wr, Block b) {
        this.render(b, wr);
    }

    private static /* synthetic */ boolean lambda$render$0(Block b) {
        return !b.isEmpty();
    }
}

