/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.IRepl;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.javainterop.DynamicInvocationHandler;
import com.github.jlangch.venice.impl.repl.ReplConfig;
import com.github.jlangch.venice.impl.repl.ReplDirs;
import com.github.jlangch.venice.impl.repl.ReplRestart;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.Tuple2;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import com.github.jlangch.venice.util.OS;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.repackage.org.jline.terminal.Terminal;
import org.repackage.org.jline.utils.InfoCmp;
import org.repackage.org.jline.utils.NonBlockingReader;

public class ReplFunctions {
    public static Env register(Env env, IRepl repl, Terminal terminal, ReplConfig config, boolean macroExpandOnLoad, ReplDirs replDirs) {
        Env e = env;
        for (VncFunction fn : ReplFunctions.createFunctions(env, repl, terminal, config, macroExpandOnLoad, replDirs)) {
            e = ReplFunctions.registerFn(e, fn);
        }
        return e;
    }

    private static Env registerFn(Env env, VncFunction fn) {
        return env.setGlobal(new Var(new VncSymbol(fn.getQualifiedName()), fn, false, Var.Scope.Global));
    }

    private static List<VncFunction> createFunctions(Env env, IRepl repl, Terminal terminal, ReplConfig config, boolean macroExpandOnLoad, ReplDirs replDirs) {
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        fns.add(ReplFunctions.createReplInfoFn(terminal, config));
        fns.add(ReplFunctions.createReplRestartFn(config, macroExpandOnLoad));
        fns.add(ReplFunctions.createTermRowsFn(terminal));
        fns.add(ReplFunctions.createTermColsFn(terminal));
        fns.add(ReplFunctions.createReplHomeDirFn(replDirs));
        fns.add(ReplFunctions.createReplLibsDirFn(replDirs));
        fns.add(ReplFunctions.createPromptFn(repl));
        fns.add(ReplFunctions.setHandlerFn(repl));
        fns.add(ReplFunctions.getColorTheme(config));
        fns.add(ReplFunctions.setColorTheme(env, config));
        fns.add(ReplFunctions.catReplEnv(replDirs));
        fns.add(ReplFunctions.getReplEnv(replDirs));
        fns.add(ReplFunctions.addReplEnv(replDirs));
        fns.add(ReplFunctions.removeReplEnv(replDirs));
        fns.add(ReplFunctions.waitAnyKeyPressed(terminal));
        fns.add(ReplFunctions.exit(repl));
        return fns;
    }

    private static VncFunction createReplInfoFn(final Terminal terminal, final ReplConfig config) {
        return new VncFunction("repl/info", VncFunction.meta().arglists("(repl/info)").doc("Returns information on the REPL.\n\nNote: This function is only available when called from within a REPL!\n\nE.g.: \n\n```\n{ :term-name \"JLine terminal\" \n  :term-type \"xterm-256color\" \n  :term-cols 80 \n  :term-rows 24 \n  :term-colors 256 \n  :term-class :org.repackage.org.jline.terminal.impl.PosixSysTerminal \n  :color-mode :light }").seeAlso("repl?", "repl/term-rows", "repl/term-cols").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                if (terminal != null) {
                    try {
                        return VncOrderedMap.of(new VncKeyword("term-name"), new VncString(terminal.getName()), new VncKeyword("term-type"), new VncString(terminal.getType()), new VncKeyword("term-cols"), new VncLong(terminal.getSize().getColumns()), new VncKeyword("term-rows"), new VncLong(terminal.getSize().getRows()), new VncKeyword("term-colors"), new VncLong(terminal.getNumericCapability(InfoCmp.Capability.max_colors).intValue()), new VncKeyword("term-class"), new VncKeyword(terminal.getClass().getName()), new VncKeyword("color-mode"), new VncKeyword(config.getColorMode().toString().toLowerCase()));
                    }
                    catch (Exception ex) {
                        throw new VncException("Failed to get the REPL terminal info", ex);
                    }
                }
                return VncOrderedMap.of(new VncKeyword("term-name"), new VncString("unknown"), new VncKeyword("term-type"), new VncString("unknown"), new VncKeyword("term-cols"), new VncLong(0L), new VncKeyword("term-rows"), new VncLong(0L), new VncKeyword("term-colors"), new VncLong(0L), new VncKeyword("term-class"), new VncKeyword("unknown"), new VncKeyword("color-mode"), new VncKeyword("unknown"));
            }
        };
    }

    private static VncFunction createReplRestartFn(final ReplConfig config, final boolean macroExpandOnLoad) {
        return new VncFunction("repl/restart", VncFunction.meta().arglists("(repl/restart)").doc("Restarts the REPL.\n\nNote: This function is only available when called from within a REPL!").seeAlso("repl?").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                ReplRestart.restart(macroExpandOnLoad, config.getColorMode());
                return Constants.Nil;
            }
        };
    }

    private static VncFunction createTermRowsFn(final Terminal terminal) {
        return new VncFunction("repl/term-rows", VncFunction.meta().arglists("(repl/term-rows)").doc("Returns number of rows in the REPL terminal.\n\nNote: This function is only available when called from within a REPL!").seeAlso("repl?", "repl/term-cols", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                return new VncLong(terminal == null ? 0L : (long)terminal.getSize().getRows());
            }
        };
    }

    private static VncFunction createTermColsFn(final Terminal terminal) {
        return new VncFunction("repl/term-cols", VncFunction.meta().arglists("(repl/term-cols)").doc("Returns number of columns in the REPL terminal.\n\nNote: This function is only available when called from within a REPL!").seeAlso("repl?", "repl/term-rows", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                return new VncLong(terminal == null ? 0L : (long)terminal.getSize().getColumns());
            }
        };
    }

    private static VncFunction createReplHomeDirFn(final ReplDirs replDirs) {
        return new VncFunction("repl/home-dir", VncFunction.meta().arglists("(repl/home-dir)").doc("Returns the REPL home directory.\n\nNote: This function is only available when called from within a REPL!").seeAlso("repl?", "repl/libs-dir").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                return replDirs.getHomeDir() == null ? Constants.Nil : new VncJavaObject(replDirs.getHomeDir());
            }
        };
    }

    private static VncFunction createReplLibsDirFn(final ReplDirs replDirs) {
        return new VncFunction("repl/libs-dir", VncFunction.meta().arglists("(repl/libs-dir)").doc("Returns the REPL libs directory\n\nNote: This function is only available when called from within a REPL!").seeAlso("repl?", "repl/home-dir").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                return replDirs.getLibsDir() == null ? Constants.Nil : new VncJavaObject(replDirs.getLibsDir());
            }
        };
    }

    private static VncFunction getColorTheme(final ReplConfig config) {
        return new VncFunction("repl/color-theme", VncFunction.meta().arglists("(repl/color-theme)").doc("Returns REPL's color theme (:light, :dark, :none) ").examples("(repl/color-theme)").seeAlso("repl?", "repl/color-theme!", "repl/prompt!", "repl/handler!", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                ReplConfig.ColorMode theme = config.getColorMode();
                return new VncKeyword(theme.name().toLowerCase());
            }
        };
    }

    private static VncFunction setColorTheme(Env env, final ReplConfig config) {
        return new VncFunction("repl/color-theme!", VncFunction.meta().arglists("(repl/color-theme! theme)").doc("Set the REPL's color theme (:light, :dark) ").examples("(repl/color-theme!)").seeAlso("repl?", "repl/color-theme", "repl/prompt!", "repl/handler!", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ReplConfig.ColorMode mode;
                ArityExceptions.assertArity(this, args, 1);
                VncKeyword theme = Coerce.toVncKeyword(args.first());
                switch (theme.getSimpleName()) {
                    case "light": {
                        mode = ReplConfig.ColorMode.Light;
                        break;
                    }
                    case "dark": {
                        mode = ReplConfig.ColorMode.Dark;
                        break;
                    }
                    case "none": {
                        mode = ReplConfig.ColorMode.None;
                        break;
                    }
                    default: {
                        mode = ReplConfig.ColorMode.Light;
                    }
                }
                config.switchColorMode(mode);
                return new VncKeyword(mode.name().toLowerCase());
            }
        };
    }

    private static VncFunction createPromptFn(final IRepl repl) {
        return new VncFunction("repl/prompt!", VncFunction.meta().arglists("(repl/prompt! s)").doc("Sets the REPL prompt string").examples("(repl/prompt! \"venice> \")").seeAlso("repl?", "repl/handler!", "repl/color-theme", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 1);
                String prompt = Coerce.toVncString(args.first()).getValue();
                if (repl != null) {
                    repl.setPrompt(prompt);
                }
                return Constants.Nil;
            }
        };
    }

    private static VncFunction catReplEnv(final ReplDirs replDirs) {
        return new VncFunction("repl/cat-env", VncFunction.meta().arglists("(repl/cat-env)").doc("Returns the content of the REPL's local env file.\n\nThe REPL env file ('repl.env' on Unix or 'repl.env.bat' on Windows ) is 'sourced' at REPL start time to make the contained vars available as system env vars!\n\nNote: This function is only available when called from within a REPL!").examples("(printl (repl/cat-env))").seeAlso("system-env", "repl?", "repl/home-dir", "repl/get-env", "repl/add-env", "repl/remove-env").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                List lines = ReplFunctions.loadReplEnv(replDirs);
                return new VncString(String.join((CharSequence)"\n", lines));
            }
        };
    }

    private static VncFunction getReplEnv(final ReplDirs replDirs) {
        return new VncFunction("repl/get-env", VncFunction.meta().arglists("(repl/get-env name)").doc("Returns the value of a REPL local env var.\n\nThe REPL env file ('repl.env' on Unix or 'repl.env.bat' on Windows ) is 'sourced' at REPL start time to make the contained vars available as system env vars!\n\nNote: This function is only available when called from within a REPL!").examples("(repl/get-env \"DEMO\")").seeAlso("system-env", "repl?", "repl/home-dir", "repl/cat-env", "repl/add-env", "repl/remove-env").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 1);
                String name = Coerce.toVncString(args.first()).getValue();
                String value = ReplFunctions.parseReplEnvVars(replDirs).stream().filter(v -> name.equals(v.getFirst())).map(v -> (String)v.getSecond()).findFirst().orElse(null);
                return value == null ? Constants.Nil : new VncString(value);
            }
        };
    }

    private static VncFunction addReplEnv(final ReplDirs replDirs) {
        return new VncFunction("repl/add-env", VncFunction.meta().arglists("(repl/add-env name value)").doc("Add (or replace) an env var to the REPL's local env file.\n\nThe REPL env file ('repl.env' on Unix or 'repl.env.bat' on Windows ) is 'sourced' at REPL start time to make the contained vars available as system env vars!\n\nDO NO FORGET to restart the REPL after adding an env var!\n\nNote: This function is only available when called from within a REPL!\n\n\n**Example**                      \n\n*1. Add env var:*                \n\n```                              \n(repl/add-env \"DEMO\" \"100\")  \n```                              \n*2. Restart the REPL:*           \n\n```                              \nvenice> !restart                 \n```                              \n*3. Test:*                       \n\n```                              \n(system-env \"DEMO\")            \n```                              ").examples("(repl/add-env \"DEMO\" \"100\")").seeAlso("system-env", "repl?", "repl/home-dir", "repl/get-env", "repl/cat-env", "repl/remove-env").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 2);
                String name = Coerce.toVncString(args.first()).getValue().trim();
                String value = Coerce.toVncString(args.second()).getValue().trim();
                ArrayList<String> out = new ArrayList<String>();
                boolean replaced = false;
                for (String line : ReplFunctions.loadReplEnv(replDirs)) {
                    String[] nv;
                    if (ReplFunctions.isEnvVarLine(line) && (nv = ReplFunctions.splitEnvVarLine(line)).length == 2 && name.equals(nv[0].trim())) {
                        out.add(ReplFunctions.renderEnvVarLine(name, value));
                        replaced = true;
                        continue;
                    }
                    out.add(line);
                }
                if (!replaced) {
                    out.add(ReplFunctions.renderEnvVarLine(name, value));
                }
                try {
                    Files.write(ReplFunctions.replEnvFile(replDirs).toPath(), out, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (Exception ex) {
                    throw new VncException("Failed to updated the REPL's env file!");
                }
                return Constants.Nil;
            }
        };
    }

    private static VncFunction removeReplEnv(final ReplDirs replDirs) {
        return new VncFunction("repl/remove-env", VncFunction.meta().arglists("(repl/remove-env name)").doc("Remove an env var to the REPL's local env file.\n\nThe REPL env file ('repl.env' on Unix or 'repl.env.bat' on Windows ) is 'sourced' at REPL start time to make the contained vars available as system env vars!\n\nTo take a removed env var into effect a whole new REPL has to be started! A simple restart does not work!\n\nNote: This function is only available when called from within a REPL!").examples("(repl/remove-env \"DEMO\")").seeAlso("system-env", "repl?", "repl/home-dir", "repl/get-env", "repl/cat-env", "repl/add-env").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 1);
                String name = Coerce.toVncString(args.first()).getValue().trim();
                ArrayList<String> out = new ArrayList<String>();
                boolean removed = false;
                for (String line : ReplFunctions.loadReplEnv(replDirs)) {
                    String[] nv;
                    if (ReplFunctions.isEnvVarLine(line) && (nv = ReplFunctions.splitEnvVarLine(line)).length == 2 && name.equals(nv[0].trim())) {
                        removed = true;
                        continue;
                    }
                    out.add(line);
                }
                try {
                    Files.write(ReplFunctions.replEnvFile(replDirs).toPath(), out, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (Exception ex) {
                    throw new VncException("Failed to updated the REPL's env file!");
                }
                return VncBoolean.of(removed);
            }
        };
    }

    private static VncFunction setHandlerFn(final IRepl repl) {
        return new VncFunction("repl/handler!", VncFunction.meta().arglists("(repl/handler! f)").doc("Sets the REPL command handler").examples("(do                                \n  (defn handle-command [cmd]       \n     ;; run the command 'cmd'      \n     (println \"Demo:\" cmd))      \n                                   \n  (repl/handler! handle-command))   ").seeAlso("repl?", "repl/prompt!", "repl/color-theme", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 1);
                VncFunction handlerFn = Coerce.toVncFunction(args.first());
                if (repl != null) {
                    Object handler = DynamicInvocationHandler.proxify(new CallFrame("proxify(:" + Consumer.class.getName() + ")", args.getMeta()), Consumer.class, VncHashMap.of(new VncString("accept"), handlerFn));
                    repl.setHandler((Consumer)handler);
                }
                return Constants.Nil;
            }
        };
    }

    private static VncFunction waitAnyKeyPressed(final Terminal terminal) {
        return new VncFunction("repl/wait-any-key-pressed", VncFunction.meta().arglists("(repl/wait-any-key-pressed)").doc("Returns REPL's color theme (:light, :dark, :none) ").examples("(repl/color-theme)").seeAlso("repl?", "repl/color-theme!", "repl/prompt!", "repl/handler!", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                terminal.enterRawMode();
                NonBlockingReader reader = terminal.reader();
                try {
                    int c = reader.read();
                    return new VncChar((char)c);
                }
                catch (IOException ex) {
                    return Constants.Nil;
                }
            }
        };
    }

    private static VncFunction exit(IRepl repl) {
        return new VncFunction("repl/exit!", (VncVal)VncFunction.meta().arglists("(repl/exit!)").doc("Exit from the REPL").examples("(repl/exit!)").seeAlso("repl?", "repl/prompt!", "repl/color-theme", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                throw new EofException("exit");
            }
        };
    }

    private static File replEnvFile(ReplDirs replDirs) {
        return new File(replDirs.getHomeDir(), OS.isWindows() ? "repl.env.bat" : "repl.env");
    }

    private static List<Tuple2<String, String>> parseReplEnvVars(ReplDirs replDirs) {
        return ReplFunctions.loadReplEnv(replDirs).stream().filter(l -> ReplFunctions.isEnvVarLine(l)).map(l -> ReplFunctions.splitEnvVarLine(l)).filter(nv -> ((String[])nv).length == 2).map(nv -> new Tuple2<String, String>(nv[0].trim(), nv[1].trim())).collect(Collectors.toList());
    }

    private static List<String> loadReplEnv(ReplDirs replDirs) {
        File envFile = ReplFunctions.replEnvFile(replDirs);
        if (envFile.canRead()) {
            try {
                return Files.readAllLines(envFile.toPath());
            }
            catch (Exception ex) {
                throw new VncException("Failed to load the REPL's env file!", ex);
            }
        }
        throw new VncException("The REPL's env file does not exist");
    }

    private static boolean isEnvVarLine(String line) {
        return line.matches("^(export|set) *[^=] *.*$");
    }

    private static String removeEnvVarPrefix(String line) {
        String l = line;
        l = StringUtil.removeStart(l, "export ");
        l = StringUtil.removeStart(l, "set ");
        return l;
    }

    private static final String[] splitEnvVarLine(String line) {
        return ReplFunctions.removeEnvVarPrefix(line).split("=");
    }

    private static final String renderEnvVarLine(String name, String value) {
        return String.format("%s %s=%s", OS.isWindows() ? "set" : "export", name.trim(), value.trim());
    }
}

