/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.io;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.nio.charset.Charset;

public class CharsetUtil {
    public static Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public static Charset charset(VncVal charsetName) {
        if (charsetName == null || charsetName == Constants.Nil) {
            return DEFAULT_CHARSET;
        }
        return Types.isVncKeyword(charsetName) ? CharsetUtil.charset(Coerce.toVncKeyword(charsetName).getValue()) : CharsetUtil.charset(Coerce.toVncString(charsetName).getValue());
    }

    public static Charset charset(String charsetName) {
        return StringUtil.isEmpty(charsetName) ? DEFAULT_CHARSET : Charset.forName(charsetName);
    }

    public static Charset charset(Charset charset) {
        return charset == null ? DEFAULT_CHARSET : charset;
    }
}

