/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.ShellException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.SystemFunctions;
import com.github.jlangch.venice.impl.threadpool.ThreadPoolUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.io.CharsetUtil;
import com.github.jlangch.venice.impl.util.io.IOStreamUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class ShellFunctions {
    public static VncFunction sh = new VncFunction("sh", (VncVal)VncFunction.meta().arglists("(sh & args)").doc("Launches a new sub-process.\n\nOptions:\n\n| :in       | may be given followed by input source as InputStream,               Reader, File, ByteBuf, or String, to be fed to the               sub-process's stdin. |\n| :in-enc   | option may be given followed by a String, used as a               character encoding name (for example \"UTF-8\" or               \"ISO-8859-1\") to convert the input string specified               by the :in option to the sub-process's stdin. Defaults               to \"UTF-8\". If the :in option provides a byte array,               then the bytes are passed unencoded, and this option               is ignored. |\n| :out-enc  | option may be given followed by :bytes or a String. If               a String is given, it will be used as a character               encoding name (for example \"UTF-8\" or \"ISO-8859-1\")               to convert the sub-process's stdout to a String which is               returned. If :bytes is given, the sub-process's stdout               will be stored in a Bytebuf and returned. Defaults to               UTF-8. |\n| :out-fn   | a function with a single string argument that receives               line by line from the process' stdout. If passed the               :out value in the return map will be empty. |\n| :err-fn   | a function with a single string argument that receives               line by line from the process' stderr. If passed the               :err value in the return map will be empty. |\n| :env      | override the process env with a map. |\n| :dir      | override the process dir with a String or java.io.File. |\n| :throw-ex | If true throw an exception if the exit code is not equal               to zero, if false returns the exit code. Defaults to               false.\u00b6              It's recommended to use\u00b6              &emsp; `(with-sh-throw (sh \"ls\" \"-l\"))` \u00b6              instead. |\n| :timeout  | A timeout in milliseconds |\n\nYou can bind :env, :dir for multiple operations using `with-sh-env` or `with-sh-dir`. `with-sh-throw` is binds *:throw-ex* as *true*.\n\nsh returns a map of\n\n```\n:exit => sub-process's exit code\n:out  => sub-process's stdout (as Bytebuf or String)\n:err  => sub-process's stderr (String via platform default encoding)\n```\n\nE.g.:\n\n```\n(sh \"uname\" \"-r\") \n=> {:err \"\" :out \"20.5.0\\n\" :exit 0}\n```").examples("(println (sh \"ls\" \"-l\"))", "(println (sh \"ls\" \"-l\" \"/tmp\"))", "(println (sh \"sed\" \"s/[aeiou]/oo/g\" :in \"hello there\\n\"))", "(println (sh \"cat\" :in \"x\\u25bax\\n\"))", "(println (sh \"echo\" \"x\\u25bax\"))", "(println (sh \"/bin/sh\" \"-c\" \"ls -l\"))", "(sh \"ls\" \"-l\" :out-fn println)", "(sh \"ls\" \"-l\" :out-fn println :err-fn println)", ";; background process\n(println (sh \"/bin/sh\" \"-c\" \"sleep 30 >/dev/null 2>&1 &\"))", "(println (sh \"/bin/sh\" \"-c\" \"nohup sleep 30 >/dev/null 2>&1 &\"))", ";; asynchronously slurping stdout and stderr\n(sh \"/bin/sh\" \n    \"-c\" \"for i in {1..5}; do sleep 1; echo \\\"Hello $i\\\"; done\" \n    :out-fn println \n    :err-fn println)", ";; asynchronously slurping stdout and stderr with a timeout\n(sh \"/bin/sh\" \n    \"-c\" \"for i in {1..5}; do sleep 1; echo \\\"Hello $i\\\"; done\" \n    :out-fn println \n    :err-fn println \n    :timeout 2500)", ";; reads 4 single-byte chars\n(println (sh \"echo\" \"x\\u25bax\" :out-enc \"ISO-8859-1\"))", ";; reads binary file into bytes[]\n(println (sh \"cat\" \"birds.jpg\" :out-enc :bytes))", ";; working directory\n(println (with-sh-dir \"/tmp\" (sh \"ls\" \"-l\") (sh \"pwd\")))", "(println (sh \"pwd\" :dir \"/tmp\"))", ";; throw an exception if the shell's subprocess exit code is not equal to 0\n(println (with-sh-throw (sh \"ls\" \"-l\")))", "(println (sh \"ls\" \"-l\" :throw-ex true))", ";; windows\n(println (sh \"cmd\" \"/c dir 1>&2\"))").seeAlso("with-sh-throw", "with-sh-dir", "with-sh-env").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            VncVector v = ShellFunctions.parseArgs(args);
            VncList cmd = Coerce.toVncList(v.first()).withMeta(args.getMeta());
            VncMap opts = Coerce.toVncMap(v.second()).withMeta(args.getMeta());
            ExecutorService executor = Executors.newFixedThreadPool(3, ThreadPoolUtil.createCountedThreadFactory("venice-shell-pool", true));
            try {
                VncVal vncVal = ShellFunctions.exec(cmd, opts, executor);
                return vncVal;
            }
            finally {
                executor.shutdownNow();
            }
        }
    };
    public static VncFunction open = new VncFunction("sh/open", (VncVal)VncFunction.meta().arglists("(sh/open f)").doc("Opens a *file* or an *URL* with the associated platform specific application. \n\nUses the OS commands:\n\n* *MacOS*: `/usr/bin/open f`\n* *Windows*: `cmd /C start f`\n* *Linux*: `/usr/bin/xdg-open f`\n\nNote: `sh/open` can only be run from a REPL!").examples("(sh/open \"sample.pdf\")", "(sh/open \"https://github.com/jlangch/venice\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            switch (SystemFunctions.osType()) {
                case "mac-osx": {
                    sh.apply(VncList.of(new VncString("/usr/bin/open"), args.first()));
                    break;
                }
                case "linux": {
                    sh.apply(VncList.of(new VncString("/usr/bin/xdg-open"), args.first()));
                    break;
                }
                case "windows": {
                    sh.apply(VncList.of(new VncString("cmd"), new VncString("/C"), new VncString("start"), args.first()));
                    break;
                }
                default: {
                    throw new VncException("Unsupported OS");
                }
            }
            return Constants.Nil;
        }
    };
    public static VncFunction pwd = new VncFunction("sh/pwd", (VncVal)VncFunction.meta().arglists("(sh/pwd)").doc("Returns the current working directory.\n\nNote: \u00b6You can't change the current working directory of the Java VM but if you were to launch another process using (sh & args) you can specify the working directory for the new spawned process.").examples("(sh/pwd)").seeAlso("sh").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            return new VncJavaObject(new File(System.getProperty("user.dir")));
        }
    };
    private static final VncHashSet optionKeywords = VncHashSet.of(new VncKeyword(":in"), new VncKeyword(":in-enc"), new VncKeyword(":out-enc"), new VncKeyword(":out-fn"), new VncKeyword(":err-fn"), new VncKeyword(":env"), new VncKeyword(":dir"), new VncKeyword(":throw-ex"), new VncKeyword(":timeout"));
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(sh).add(open).add(pwd).toMap();

    /*
     * Exception decompiling
     */
    private static VncVal exec(VncList cmd, VncMap opts, ExecutorService executor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File toFile(VncVal dir) {
        if (dir == Constants.Nil) {
            return null;
        }
        if (Types.isVncString(dir)) {
            return new File(((VncString)dir).getValue());
        }
        if (Types.isVncJavaObject(dir, File.class)) {
            return (File)((VncJavaObject)dir).getDelegate();
        }
        if (Types.isVncJavaObject(dir, Path.class)) {
            return ((Path)((VncJavaObject)dir).getDelegate()).toFile();
        }
        return null;
    }

    private static String[] toStringArray(VncList list) {
        return list.stream().map(it -> CoreFunctions.name.apply(VncList.of(it))).map(it -> ((VncString)it).getValue()).collect(Collectors.toList()).toArray(new String[0]);
    }

    private static String[] toEnvStrings(VncVal envMap) {
        if (envMap == Constants.Nil || ((VncMap)envMap).isEmpty()) {
            return null;
        }
        return ((VncMap)envMap).entries().stream().map(e -> String.format("%s=%s", CoreFunctions.name.apply(VncList.of(e.getKey())), e.getValue().toString())).collect(Collectors.toList()).toArray(new String[0]);
    }

    private static VncVector parseArgs(VncList args) {
        VncThreadLocal th = new VncThreadLocal();
        VncHashMap options = new VncHashMap();
        VncList cmd = VncList.empty();
        VncList args_ = args;
        while (!args_.isEmpty()) {
            VncVal v = args_.first();
            args_ = args_.rest();
            if (Types.isVncKeyword(v) && optionKeywords.contains(v)) {
                VncVal optVal = args_.first();
                args_ = args_.rest();
                options = options.assoc(v, optVal);
                continue;
            }
            cmd = cmd.addAtEnd(new VncString(v.toString()));
        }
        VncHashMap defaultOptions = VncHashMap.of(new VncKeyword(":out-enc"), new VncString("UTF-8"), new VncKeyword(":in-enc"), new VncString("UTF-8"), new VncKeyword(":dir"), th.get(":*sh-dir*"), new VncKeyword(":throw-ex"), th.get(":*sh-throw-ex*"));
        VncMap defaultEnv = (VncMap)th.get(":*sh-env*", (VncVal)new VncHashMap());
        VncMap opts = (VncMap)CoreFunctions.merge.apply(VncList.of(defaultOptions, options));
        opts = opts.assoc(new VncKeyword(":env"), CoreFunctions.merge.apply(VncList.of(defaultEnv, options.get(new VncKeyword(":env")))));
        return VncVector.of(cmd, opts);
    }

    private static void validateProcessDir(File dir) {
        if (dir != null && !dir.isDirectory()) {
            throw new ShellException(String.format("Shell execution failed: The process directory '%s' does not exist!", dir.getPath()));
        }
    }

    private static String getEncoding(VncVal enc) {
        return enc == Constants.Nil ? Charset.defaultCharset().name() : ((VncString)CoreFunctions.name.apply(VncList.of(enc))).getValue();
    }

    private static Object copyAndClose(VncString data, Charset charset, OutputStream os) throws IOException {
        IOStreamUtil.copyStringToOS(data.getValue(), os, charset);
        os.flush();
        os.close();
        return null;
    }

    private static Object copyAndClose(VncByteBuffer data, OutputStream os) throws IOException {
        IOStreamUtil.copyByteArrayToOS(data.getBytes(), os);
        os.flush();
        os.close();
        return null;
    }

    private static Object copyAndClose(File data, OutputStream os) throws IOException {
        IOStreamUtil.copyFileToOS(data, os);
        os.flush();
        os.close();
        return null;
    }

    private static void slurp(InputStream is, String enc, VncFunction fn) {
        try {
            String line;
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, enc));
            while ((line = rd.readLine()) != null) {
                fn.apply(VncList.of(new VncString(line)));
            }
        }
        catch (Exception ex) {
            fn.apply(VncList.of(Constants.Nil));
        }
    }

    private static VncString slurpToString(InputStream is, Charset charset) throws Exception {
        return new VncString(IOStreamUtil.copyIStoString(is, charset));
    }

    private static VncByteBuffer slurpToBytes(InputStream is) throws Exception {
        return new VncByteBuffer(IOStreamUtil.copyIStoByteArray(is));
    }

    private static /* synthetic */ String lambda$exec$9(VncVal v) {
        return v.toString();
    }

    private static /* synthetic */ String lambda$exec$8(VncVal v) {
        return v.toString();
    }

    private static /* synthetic */ VncVal lambda$exec$7(InputStream stderr, Charset charset) throws Exception {
        return ShellFunctions.slurpToString(stderr, charset);
    }

    private static /* synthetic */ VncVal lambda$exec$6(InputStream stderr, String enc, VncFunction fn) throws Exception {
        ShellFunctions.slurp(stderr, enc, fn);
        return VncString.empty();
    }

    private static /* synthetic */ VncVal lambda$exec$5(InputStream stdout, Charset charset) throws Exception {
        return ShellFunctions.slurpToString(stdout, charset);
    }

    private static /* synthetic */ VncVal lambda$exec$4(InputStream stdout, String enc, VncFunction fn) throws Exception {
        ShellFunctions.slurp(stdout, enc, fn);
        return VncString.empty();
    }

    private static /* synthetic */ VncVal lambda$exec$3(InputStream stdout) throws Exception {
        return ShellFunctions.slurpToBytes(stdout);
    }

    private static /* synthetic */ Object lambda$exec$2(VncVal in, OutputStream stdin) throws Exception {
        return ShellFunctions.copyAndClose((File)((VncJavaObject)in).getDelegate(), stdin);
    }

    private static /* synthetic */ Object lambda$exec$1(VncVal in, OutputStream stdin) throws Exception {
        return ShellFunctions.copyAndClose((VncByteBuffer)in, stdin);
    }

    private static /* synthetic */ Object lambda$exec$0(VncVal in, VncVal inEnc, OutputStream stdin) throws Exception {
        return ShellFunctions.copyAndClose((VncString)in, CharsetUtil.charset(inEnc), stdin);
    }
}

