/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncNumber;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class VncBigInteger
extends VncNumber {
    public static final String TYPE = ":core/bigint";
    private static final long serialVersionUID = -1848883965231344442L;
    private final BigInteger value;

    public VncBigInteger(BigInteger v) {
        this(v, null, Constants.Nil);
    }

    public VncBigInteger(double v) {
        this(BigInteger.valueOf((long)v), null, Constants.Nil);
    }

    public VncBigInteger(long v) {
        this(BigInteger.valueOf(v), null, Constants.Nil);
    }

    public VncBigInteger(BigInteger v, VncVal meta) {
        this(v, null, meta);
    }

    public VncBigInteger(BigInteger v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v;
    }

    public static VncBigInteger of(VncVal v) {
        if (Types.isVncNumber(v)) {
            return new VncBigInteger(((VncNumber)v).toJavaBigInteger());
        }
        throw new VncException(String.format("Cannot convert value of type %s to big integer", Types.getType(v)));
    }

    @Override
    public VncBigInteger withMeta(VncVal meta) {
        return new VncBigInteger(this.value, this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncBigInteger wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncBigInteger(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? new VncKeyword(this.getWrappingTypeDef().getType().getQualifiedName(), MetaUtil.typeMeta(new VncKeyword(TYPE), new VncKeyword(":core/number"), new VncKeyword(":core/val"))) : new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/number"), new VncKeyword(":core/val")));
    }

    @Override
    public VncBigInteger inc() {
        return new VncBigInteger(this.value.add(BigInteger.ONE));
    }

    @Override
    public VncBigInteger dec() {
        return new VncBigInteger(this.value.subtract(BigInteger.ONE));
    }

    @Override
    public VncBigInteger negate() {
        return new VncBigInteger(this.value.negate());
    }

    @Override
    public VncNumber add(VncVal op) {
        if (op instanceof VncBigInteger) {
            return new VncBigInteger(this.value.add(((VncBigInteger)op).toJavaBigInteger()));
        }
        if (op instanceof VncLong) {
            return new VncBigInteger(this.value.add(((VncLong)op).toJavaBigInteger()));
        }
        if (op instanceof VncInteger) {
            return new VncBigInteger(this.value.add(((VncInteger)op).toJavaBigInteger()));
        }
        if (op instanceof VncDouble) {
            return new VncBigDecimal(this.toJavaBigDecimal().add(((VncDouble)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().add(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        throw new VncException(String.format("Function + operand of type %s is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber sub(VncVal op) {
        if (op instanceof VncBigInteger) {
            return new VncBigInteger(this.value.subtract(((VncBigInteger)op).toJavaBigInteger()));
        }
        if (op instanceof VncLong) {
            return new VncBigInteger(this.value.subtract(((VncLong)op).toJavaBigInteger()));
        }
        if (op instanceof VncInteger) {
            return new VncBigInteger(this.value.subtract(((VncInteger)op).toJavaBigInteger()));
        }
        if (op instanceof VncDouble) {
            return new VncBigDecimal(this.toJavaBigDecimal().subtract(((VncDouble)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().subtract(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        throw new VncException(String.format("Function - operand of type %s is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber mul(VncVal op) {
        if (op instanceof VncBigInteger) {
            return new VncBigInteger(this.value.multiply(((VncBigInteger)op).toJavaBigInteger()));
        }
        if (op instanceof VncLong) {
            return new VncBigInteger(this.value.multiply(((VncLong)op).toJavaBigInteger()));
        }
        if (op instanceof VncInteger) {
            return new VncBigInteger(this.value.multiply(((VncInteger)op).toJavaBigInteger()));
        }
        if (op instanceof VncDouble) {
            return new VncBigDecimal(this.toJavaBigDecimal().multiply(((VncDouble)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().multiply(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        throw new VncException(String.format("Function * operand of type %s is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber div(VncVal op) {
        try {
            if (op instanceof VncBigInteger) {
                return new VncBigInteger(this.value.divide(((VncBigInteger)op).toJavaBigInteger()));
            }
            if (op instanceof VncLong) {
                return new VncBigInteger(this.value.divide(((VncLong)op).toJavaBigInteger()));
            }
            if (op instanceof VncInteger) {
                return new VncBigInteger(this.value.divide(((VncInteger)op).toJavaBigInteger()));
            }
            if (op instanceof VncDouble) {
                return new VncBigDecimal(this.toJavaBigDecimal().divide(((VncDouble)op).toJavaBigDecimal(), 16, RoundingMode.HALF_UP));
            }
            if (op instanceof VncBigDecimal) {
                return new VncBigDecimal(this.toJavaBigDecimal().divide(((VncBigDecimal)op).toJavaBigDecimal(), 16, RoundingMode.HALF_UP));
            }
            throw new VncException(String.format("Function / operand of type %s is not a numeric type", Types.getType(op)));
        }
        catch (ArithmeticException ex) {
            throw new VncException(ex.getMessage());
        }
    }

    @Override
    public VncBoolean equ(VncVal other) {
        if (other instanceof VncBigInteger) {
            return VncBoolean.of(this.value.compareTo(((VncBigInteger)other).toJavaBigInteger()) == 0);
        }
        if (other instanceof VncLong) {
            return VncBoolean.of(this.value.compareTo(((VncLong)other).toJavaBigInteger()) == 0);
        }
        if (other instanceof VncInteger) {
            return VncBoolean.of(this.value.compareTo(((VncInteger)other).toJavaBigInteger()) == 0);
        }
        if (other instanceof VncDouble) {
            return VncBoolean.of(this.toJavaBigDecimal().compareTo(((VncDouble)other).toJavaBigDecimal()) == 0);
        }
        if (other instanceof VncBigDecimal) {
            return VncBoolean.of(this.toJavaBigDecimal().compareTo(((VncBigDecimal)other).toJavaBigDecimal()) == 0);
        }
        throw new VncException(String.format("Function == operand of type %s is not a numeric type", Types.getType(other)));
    }

    @Override
    public VncBoolean zeroQ() {
        return VncBoolean.of(this.value.compareTo(BigInteger.ZERO) == 0);
    }

    @Override
    public VncBoolean posQ() {
        return VncBoolean.of(this.value.compareTo(BigInteger.ZERO) > 0);
    }

    @Override
    public VncBoolean negQ() {
        return VncBoolean.of(this.value.compareTo(BigInteger.ZERO) < 0);
    }

    @Override
    public VncNumber square() {
        return new VncBigInteger(this.value.multiply(this.value));
    }

    @Override
    public VncNumber sqrt() {
        return new VncBigDecimal(new BigDecimal(Math.sqrt(this.toJavaDouble())));
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.BIGDECIMAL;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int toJavaInteger() {
        return this.value.intValue();
    }

    @Override
    public long toJavaLong() {
        return this.value.longValue();
    }

    @Override
    public double toJavaDouble() {
        return this.value.doubleValue();
    }

    @Override
    public BigInteger toJavaBigInteger() {
        return this.value;
    }

    @Override
    public BigDecimal toJavaBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public BigDecimal toJavaBigDecimal(int scale) {
        return new BigDecimal(this.value).setScale(scale);
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncBigInteger(o)) {
            return this.value.compareTo(((VncBigInteger)o).getValue());
        }
        if (Types.isVncBigDecimal(o)) {
            return this.value.compareTo(((VncBigDecimal)o).toJavaBigInteger());
        }
        if (Types.isVncInteger(o)) {
            return this.value.compareTo(((VncInteger)o).toJavaBigInteger());
        }
        if (Types.isVncDouble(o)) {
            return this.value.compareTo(((VncDouble)o).toJavaBigInteger());
        }
        if (Types.isVncLong(o)) {
            return this.value.compareTo(((VncLong)o).toJavaBigInteger());
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((VncBigInteger)obj).value);
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public String toString(boolean print_machine_readably) {
        return print_machine_readably ? this.value.toString() + "N" : this.value.toString();
    }
}

