/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.impl.util.CollectionUtil;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import java.util.List;

public abstract class LicenseMgr {
    private static final String LICENSE_VENICE_TEXT = "license.txt";
    private static final String LICENSE_VENICE = "LICENSE-Venice.txt";
    private static final String LICENSE_AUDIOWIDE = "LICENSE-Audiowide.txt";
    private static final String LICENSE_JLINE3 = "LICENSE-JLine3.txt";
    private static final String LICENSE_NANOJSON = "LICENSE-nanojson.txt";
    private static final String LICENSE_VAVR = "LICENSE-Vavr.txt";
    private static final String LICENSE_ZIP4J = "LICENSE-Zip4J.txt";
    private static final String LICENSE_OFL = "LICENSE-OFL.txt";
    private static final String LICENSE_OPENSANS = "LICENSE-OpenSans.txt";

    public static String loadVeniceLicenseText() {
        return new ClassPathResource("META-INF/license.txt").getResourceAsString("UTF-8");
    }

    public static String loadVeniceLicense() {
        return new ClassPathResource("META-INF/LICENSE-Venice.txt").getResourceAsString("UTF-8");
    }

    public static String loadAudiowideLicense() {
        return new ClassPathResource("META-INF/LICENSE-Audiowide.txt").getResourceAsString("UTF-8");
    }

    public static String loadJLine3License() {
        return new ClassPathResource("META-INF/LICENSE-JLine3.txt").getResourceAsString("UTF-8");
    }

    public static String loadNanojsonLicense() {
        return new ClassPathResource("META-INF/LICENSE-nanojson.txt").getResourceAsString("UTF-8");
    }

    public static String loadVavrLicense() {
        return new ClassPathResource("META-INF/LICENSE-Vavr.txt").getResourceAsString("UTF-8");
    }

    public static String loadZip4Jicense() {
        return new ClassPathResource("META-INF/LICENSE-Zip4J.txt").getResourceAsString("UTF-8");
    }

    public static String loadOflLicense() {
        return new ClassPathResource("META-INF/LICENSE-OFL.txt").getResourceAsString("UTF-8");
    }

    public static String loadOpenSansLicense() {
        return new ClassPathResource("META-INF/LICENSE-OpenSans.txt").getResourceAsString("UTF-8");
    }

    public static String loadAll() {
        List<String> licenses = CollectionUtil.toList(LicenseMgr.header("Venice License"), LicenseMgr.loadVeniceLicenseText(), LicenseMgr.header("Venice License"), LicenseMgr.loadJLine3License(), LicenseMgr.header("JLine3 License"), LicenseMgr.loadNanojsonLicense(), LicenseMgr.header("NanJson License"), LicenseMgr.loadVavrLicense(), LicenseMgr.header("Vavr License"), LicenseMgr.loadZip4Jicense(), LicenseMgr.header("SIL Open Font License"), LicenseMgr.loadOflLicense(), LicenseMgr.header("Audowide Font License"), LicenseMgr.loadAudiowideLicense(), LicenseMgr.header("OpenSans Font License"), LicenseMgr.loadOpenSansLicense());
        return String.join((CharSequence)"\n\n\n\n", licenses);
    }

    private static String header(String header) {
        return StringUtil.repeat('*', 80) + "\n* " + header + StringUtil.repeat(' ', 77 - header.length()) + "*\n" + StringUtil.repeat('*', 80) + "\n\n\n";
    }
}

