/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.debug.breakpoint;

import com.github.jlangch.venice.ParseError;
import com.github.jlangch.venice.impl.debug.breakpoint.AncestorSelector;
import com.github.jlangch.venice.impl.debug.breakpoint.AncestorType;
import com.github.jlangch.venice.impl.debug.breakpoint.BreakpointFn;
import com.github.jlangch.venice.impl.debug.breakpoint.FunctionScope;
import com.github.jlangch.venice.impl.debug.breakpoint.Selector;
import com.github.jlangch.venice.impl.specialforms.SpecialForms;
import com.github.jlangch.venice.impl.types.util.QualifiedName;
import com.github.jlangch.venice.impl.util.CollectionUtil;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class BreakpointParser {
    public static Set<String> SUPPORTED_SPECIAL_FORMS = new HashSet<String>(Arrays.asList("if", "let", "bindings", "loop", "try", "try-with", "catch", "finally"));
    private static final String BREAKPOINT_SCOPE_REGEX = "^[>(!)]+$";

    public static List<BreakpointFn> parseBreakpoints(String definition) {
        return BreakpointParser.parseBreakpoints(Arrays.asList(definition.trim().split(" +")));
    }

    public static List<BreakpointFn> parseBreakpoints(List<String> tokens) {
        String selector;
        if (tokens.isEmpty()) {
            return new ArrayList<BreakpointFn>();
        }
        String scopes = StringUtil.trimToEmpty(tokens.get(0));
        boolean hasScopes = BreakpointParser.isBreakpointScopes(scopes);
        Set<FunctionScope> scopeSet = BreakpointParser.parseBreakpointScopes(hasScopes ? scopes : null);
        List<String> bpTokens = hasScopes ? CollectionUtil.drop(tokens, 1) : tokens;
        switch (selector = bpTokens.size() == 3 ? bpTokens.get(1) : "") {
            case ">": {
                return CollectionUtil.toList(BreakpointParser.validate(new BreakpointFn(QualifiedName.parse(bpTokens.get(2)), new Selector(scopeSet, new AncestorSelector(QualifiedName.parse(bpTokens.get(0)), AncestorType.Nearest)))));
            }
            case "+": {
                return CollectionUtil.toList(BreakpointParser.validate(new BreakpointFn(QualifiedName.parse(bpTokens.get(2)), new Selector(scopeSet, new AncestorSelector(QualifiedName.parse(bpTokens.get(0)), AncestorType.Any)))));
            }
        }
        return bpTokens.stream().map(s -> StringUtil.trimToNull(s.replace(',', ' '))).filter(s -> BreakpointParser.isBreakpointRefCandidate(s)).map(s -> BreakpointParser.parseBreakpoint(s, scopeSet)).filter(b -> b != null).map(s -> BreakpointParser.validate(s)).collect(Collectors.toList());
    }

    private static BreakpointFn parseBreakpoint(String ref, Set<FunctionScope> scopes) {
        if (StringUtil.isBlank(ref)) {
            return null;
        }
        try {
            String ref_ = ref.trim();
            if (BreakpointParser.isBreakpointFn(ref_)) {
                return new BreakpointFn(QualifiedName.parse(ref_), new Selector(scopes));
            }
            return null;
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public static Set<FunctionScope> parseBreakpointScopes(String scopes) {
        return BreakpointParser.parseBreakpointScopes(scopes, new HashSet<FunctionScope>());
    }

    public static Set<FunctionScope> parseBreakpointScopes(String scopes, Set<FunctionScope> defaultScopes) {
        if (StringUtil.trimToNull(scopes) == null) {
            return defaultScopes;
        }
        Set tset = Arrays.asList(FunctionScope.values()).stream().filter(t -> scopes.contains(t.symbol())).collect(Collectors.toSet());
        return tset.isEmpty() ? defaultScopes : tset;
    }

    public static boolean isBreakpointScopes(String scopes) {
        return scopes.matches(BREAKPOINT_SCOPE_REGEX);
    }

    private static boolean isBreakpointFn(String ref) {
        return ref.equals("/") || ref.matches("([^0-9/][^/]*|[^0-9/][^/]*/[^/]+)");
    }

    private static boolean isBreakpointRefCandidate(String s) {
        return s != null && !BreakpointParser.isBreakpointScopes(s);
    }

    private static BreakpointFn validate(BreakpointFn bp) {
        String fnName = bp.getQualifiedFnName();
        if (SpecialForms.isSpecialForm(fnName)) {
            if (!BreakpointParser.isSpecialFormSupportedForDebugging(fnName)) {
                throw new ParseError(String.format("The special form '%s' is not supported for debugging! Only the forms %s are supported yet.", fnName, SUPPORTED_SPECIAL_FORMS.stream().sorted().map(s -> "'" + s + "'").collect(Collectors.joining(", "))));
            }
            bp.getSelectors().forEach(s -> {
                if (s.hasScope(FunctionScope.FunctionCall) || s.hasScope(FunctionScope.FunctionExit) || s.hasScope(FunctionScope.FunctionException)) {
                    throw new ParseError(String.format("Breakpoints on special forms like '%s' do not support level %s, %s, or %s!", fnName, FunctionScope.FunctionCall.description(), FunctionScope.FunctionExit.description(), FunctionScope.FunctionException.description()));
                }
            });
        }
        return bp;
    }

    private static boolean isSpecialFormSupportedForDebugging(String name) {
        return SUPPORTED_SPECIAL_FORMS.contains(name);
    }
}

