/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet;

import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.docgen.cheatsheet.CheatsheetRenderer;
import com.github.jlangch.venice.impl.docgen.cheatsheet.CodeSnippet;
import com.github.jlangch.venice.impl.docgen.cheatsheet.CodeSnippetReader;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItem;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItemBuilder;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleAnsiSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleAppSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleAsciiTableSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleBenchmarkSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleCargoArangoDBSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleCargoPostgresqlDBSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleCargoQdrantDBSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleCargoSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleChinookPostgreSQLSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleComponentSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleConfigSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleCryptographySection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleDockerSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleExcelSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleFontsSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleGeoipSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleGradleSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleGradleWrapperSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleGrepSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleHexdumpSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleHttpClientJ8Section;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleImagesSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleInstallerSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleJTokkitSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleJavaSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleJdbcCoreSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleJdbcPostgreSQLSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleJsonlSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleKiraSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleMatrixSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleMavenSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleMimetypesSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleMultipartSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleOpenAiSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleParsifalSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleQrRefSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleRingSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleSemverSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleShellSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleSseSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleTestSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleTimingSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleTomcatSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleTracingSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleXmlSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleZipVaultSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.ArraySection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.ByteBufSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.CidrSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.CollectionsSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.ConcurrencySection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.CsvSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.ExceptionsSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.FunctionsSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.InetSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.IoFileSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.IoSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.IoZipSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.JavaInteropSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.JsonSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.LazySequencesSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.LicenseSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.LoadPathSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.MacrosSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.MathSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.NamespaceSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.PdfSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.PrimitivesSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.ProtocolsSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.RegexSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.ReplSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.SandboxSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.SpecialFormsSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.SystemSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.SystemVarSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.TapSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.TimeSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.TransducersSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.TypesSection;
import com.github.jlangch.venice.impl.docgen.util.CodeHighlighter;
import com.github.jlangch.venice.impl.docgen.util.ColorTheme;
import com.github.jlangch.venice.impl.docgen.util.MarkdownDoc;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.repl.ReplDirs;
import com.github.jlangch.venice.impl.repl.ReplFunctions;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.impl.util.io.IOStreamUtil;
import com.github.jlangch.venice.impl.util.markdown.Markdown;
import com.github.jlangch.venice.impl.util.markdown.renderer.html.HtmlRenderer;
import com.github.jlangch.venice.impl.util.markdown.renderer.text.TextRenderer;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.lowagie.text.pdf.PdfReader;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DocGenerator {
    private final DocItemBuilder diBuilder;

    public DocGenerator(boolean runExamples) {
        ArrayList<String> preloadedModules = new ArrayList<String>();
        preloadedModules.addAll(Arrays.asList("app", "xml", "crypt", "gradle", "trace", "ansi", "maven", "kira", "java", "semver", "excel", "hexdump", "shell", "geoip", "benchmark", "component", "config", "parsifal", "grep", "test", "fonts", "qrref", "jsonl", "timing", "zipvault", "gradlew", "matrix", "ascii-table", "docker", "cargo", "cargo-arangodb", "cargo-qdrant", "cargo-postgresql", "installer", "mimetypes", "multipart", "images", "tomcat", "jetty", "http-client", "http-client-j8", "openai", "jtokkit", "jdbc-core", "jdbc-postgresql", "chinook-postgresql", "ring", "ring-multipart", "ring-session", "ring-mw", "ring-util", "server-side-events", "pretty-print"));
        VeniceInterpreter venice = new VeniceInterpreter(new AcceptAllInterceptor());
        Env docEnv = venice.createEnv(preloadedModules, false, false, RunMode.DOCGEN, IOStreamUtil.nullPrintStream(), IOStreamUtil.nullPrintStream(), null);
        Env env = ReplFunctions.register(docEnv, null, null, null, false, ReplDirs.notavail());
        this.diBuilder = new DocItemBuilder(env, new CodeHighlighter(ColorTheme.getLightTheme()), preloadedModules, runExamples);
    }

    public static List<DocSection> docInfo() {
        return new DocGenerator(false).buildDocInfo();
    }

    public void run(String version) {
        try {
            System.out.println("Creating cheatsheet V" + version);
            System.out.println("Collecting data...");
            List<DocSection> left = this.getLeftSections();
            List<DocSection> right = this.getRightSections();
            List<DocSection> leftModules = this.getModulesLeftSections();
            List<DocSection> rightModules = this.getModulesRightSections();
            List<MarkdownDoc> topics = this.getMarkdownTopics();
            this.validateUniqueSectionsId(left, right);
            List<DocSection> toc = this.getTOC();
            List<DocItem> details = this.getDocItems(this.concat(left, right, leftModules, rightModules));
            List<CodeSnippet> codeSnippets = new CodeSnippetReader().readSnippets();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("meta-author", "Venice");
            data.put("version", version);
            data.put("toc", toc);
            data.put("left", left);
            data.put("right", right);
            data.put("left-modules", leftModules);
            data.put("right-modules", rightModules);
            data.put("details", details);
            data.put("snippets", codeSnippets);
            data.put("topics", topics);
            System.out.println("Creating cheatsheet (ascii)...");
            String ascii = CheatsheetRenderer.renderASCII(data);
            this.save(new File(this.getUserDir(), "cheatsheet.ascii"), ascii);
            System.out.println("Creating cheatsheet (html)...");
            data.put("pdfmode", false);
            String html = CheatsheetRenderer.renderXHTML(data);
            this.save(new File(this.getUserDir(), "cheatsheet.html"), html);
            System.out.println("Creating cheatsheet (pdf)...");
            data.put("pdfmode", true);
            String xhtml = CheatsheetRenderer.renderXHTML(data);
            ByteBuffer pdf = CheatsheetRenderer.renderPDF(xhtml);
            byte[] pdfArr = pdf.array();
            this.save(new File(this.getUserDir(), "cheatsheet.pdf"), pdfArr);
            PdfReader reader = new PdfReader(pdfArr);
            int pages = reader.getNumberOfPages();
            reader.close();
            System.out.println(String.format("Generated cheatsheet: %s", this.getUserDir()));
            System.out.println(String.format("Generated cheatsheet: ASCII: %dKB, XHTML: %dKB, PDF: %dKB / %d pages", ascii.length() / 1024, xhtml.length() / 1024, pdfArr.length / 1024, pages));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private List<DocSection> buildDocInfo() {
        ArrayList<DocSection> sections = new ArrayList<DocSection>();
        sections.addAll(this.getLeftSections());
        sections.addAll(this.getRightSections());
        return sections;
    }

    private List<DocSection> getTOC() {
        ArrayList<DocSection> content = new ArrayList<DocSection>();
        DocSection primitives = new DocSection("Primitives", "primitives");
        primitives.addSection(new DocSection("Literals", "primitives.literals"));
        primitives.addSection(new DocSection("Number", "primitives.numbers"));
        primitives.addSection(new DocSection("String", "primitives.strings"));
        primitives.addSection(new DocSection("Char", "primitives.chars"));
        primitives.addSection(new DocSection("Boolean", "primitives.booleans"));
        primitives.addSection(new DocSection("Keyword", "primitives.keywords"));
        primitives.addSection(new DocSection("Symbol", "primitives.symbols"));
        primitives.addSection(new DocSection("Nil", "primitives.mil"));
        primitives.addSection(new DocSection("Just", "primitives.just"));
        content.add(primitives);
        DocSection collections = new DocSection("Collections", "collections");
        collections.addSection(new DocSection("List", "collections.lists"));
        collections.addSection(new DocSection("Vector", "collections.vectors"));
        collections.addSection(new DocSection("Set", "collections.sets"));
        collections.addSection(new DocSection("Map", "collections.maps"));
        collections.addSection(new DocSection("LazySeq", "lazyseq"));
        collections.addSection(new DocSection("Stack", "collections.stack"));
        collections.addSection(new DocSection("Queue", "collections.queue"));
        collections.addSection(new DocSection("DelayQueue", "collections.delayqueue"));
        collections.addSection(new DocSection("DAG", "collections.dag"));
        collections.addSection(new DocSection("Array", "arrays"));
        collections.addSection(new DocSection("ByteBuf", "bytebuf"));
        content.add(collections);
        DocSection datatypes = new DocSection("Custom\u00a0Types", "datatypes");
        datatypes.addSection(new DocSection("Types", "types"));
        datatypes.addSection(new DocSection("Protocols", "protocols"));
        content.add(datatypes);
        DocSection concepts = new DocSection("Concepts", "concepts");
        concepts.addSection(new DocSection("Recursion", "concepts.recursion"));
        concepts.addSection(new DocSection("Destructuring", "concepts.destructuring"));
        content.add(concepts);
        DocSection functions = new DocSection("Core\u00a0Functions", "functions");
        functions.addSection(new DocSection("Functions", "functions"));
        functions.addSection(new DocSection("Macros", "macros"));
        functions.addSection(new DocSection("Special\u00a0Forms", "specialforms"));
        functions.addSection(new DocSection("Transducers", "transducers"));
        functions.addSection(new DocSection("Namespaces", "namespace"));
        functions.addSection(new DocSection("Exceptions", "exceptions"));
        content.add(functions);
        DocSection concurrency = new DocSection("Concurrency", "concurrency");
        concurrency.addSection(new DocSection("Atoms", "concurrency.atoms"));
        concurrency.addSection(new DocSection("Locks", "concurrency.locks"));
        concurrency.addSection(new DocSection("Locking", "concurrency.locking"));
        concurrency.addSection(new DocSection("Futures", "concurrency.futures"));
        concurrency.addSection(new DocSection("Promises", "concurrency.promises"));
        concurrency.addSection(new DocSection("Delay", "concurrency.delay"));
        concurrency.addSection(new DocSection("Agents", "concurrency.agents"));
        concurrency.addSection(new DocSection("Scheduler", "concurrency.scheduler"));
        concurrency.addSection(new DocSection("Volatiles", "concurrency.volatiles"));
        concurrency.addSection(new DocSection("Parallel", "concurrency.parallel"));
        content.add(concurrency);
        DocSection threads = new DocSection("Threads", "concurrency.threads");
        threads.addSection(new DocSection("ThreadLocal", "concurrency.threadlocal"));
        threads.addSection(new DocSection("Threads", "concurrency.threads"));
        content.add(threads);
        DocSection system = new DocSection("System", "system");
        system.addSection(new DocSection("System", "system"));
        system.addSection(new DocSection("System\u00a0Vars", "sysvars"));
        system.addSection(new DocSection("REPL", "repl"));
        system.addSection(new DocSection("Sandbox", "sandbox"));
        system.addSection(new DocSection("Load\u00a0Paths", "loadpaths"));
        content.add(system);
        DocSection java = new DocSection("Java", "java");
        java.addSection(new DocSection("Java\u00a0Interop", "javainterop"));
        java.addSection(new DocSection("Java", "modules.java"));
        content.add(java);
        DocSection util = new DocSection("Util", "util");
        util.addSection(new DocSection("Math", "math"));
        util.addSection(new DocSection("Time", "time"));
        util.addSection(new DocSection("Regex", "regex"));
        util.addSection(new DocSection("INET", "inet"));
        util.addSection(new DocSection("CIDR", "cidr"));
        content.add(util);
        DocSection io = new DocSection("I/O", "io");
        io.addSection(new DocSection("I/O", "io.util"));
        io.addSection(new DocSection("File", "io.file"));
        io.addSection(new DocSection("Zip/GZip", "io.zip"));
        content.add(io);
        DocSection documents = new DocSection("Documents", "miscellaneous");
        documents.addSection(new DocSection("JSON", "json"));
        documents.addSection(new DocSection("JSON Lines", "modules.jsonl"));
        documents.addSection(new DocSection("PDF", "pdf"));
        documents.addSection(new DocSection("PDF Tools", "pdf.pdftools"));
        documents.addSection(new DocSection("CSV", "csv"));
        documents.addSection(new DocSection("XML", "modules.xml"));
        documents.addSection(new DocSection("Excel", "modules.excel"));
        documents.addSection(new DocSection("Images", "modules.images"));
        content.add(documents);
        DocSection extmod = new DocSection("Modules", "modules");
        extmod.addSection(new DocSection("Kira\u00a0Templates", "modules.kira"));
        extmod.addSection(new DocSection("Parsifal", "modules.parsifal"));
        extmod.addSection(new DocSection("Grep", "modules.grep"));
        extmod.addSection(new DocSection("Configuration", "modules.config"));
        extmod.addSection(new DocSection("Component", "modules.component"));
        extmod.addSection(new DocSection("ZipVault", "modules.zipvault"));
        extmod.addSection(new DocSection("Fonts", "modules.fonts"));
        extmod.addSection(new DocSection("Cryptography", "modules.cryptography"));
        extmod.addSection(new DocSection("AsciiTable", "modules.asciitable"));
        extmod.addSection(new DocSection("Matrix", "modules.matrix"));
        extmod.addSection(new DocSection("Shell", "modules.shell"));
        extmod.addSection(new DocSection("Geo IP", "modules.geoip"));
        extmod.addSection(new DocSection("Mimetypes", "modules.mimetypes"));
        extmod.addSection(new DocSection("Ansi", "modules.ansi"));
        extmod.addSection(new DocSection("App", "modules.app"));
        extmod.addSection(new DocSection("QR\u00a0Ref", "modules.qrref"));
        extmod.addSection(new DocSection("Semver", "modules.semver"));
        content.add(extmod);
        DocSection build = new DocSection("Build\u00a0Tools", "build");
        build.addSection(new DocSection("Gradle\u00a0Wrapper", "modules.gradlew"));
        build.addSection(new DocSection("Gradle", "modules.gradle"));
        build.addSection(new DocSection("Maven", "modules.maven"));
        build.addSection(new DocSection("Installer", "modules.installer"));
        content.add(build);
        DocSection debug = new DocSection("Test\u00a0&\u00a0Debug", "test");
        debug.addSection(new DocSection("Test", "modules.test"));
        debug.addSection(new DocSection("Tracing", "modules.tracing"));
        debug.addSection(new DocSection("Tap", "tap"));
        debug.addSection(new DocSection("Hexdump", "modules.hexdump"));
        debug.addSection(new DocSection("Timing", "modules.timing"));
        debug.addSection(new DocSection("Benchmark", "modules.benchmark"));
        content.add(debug);
        DocSection db = new DocSection("Database", "database");
        db.addSection(new DocSection("JDBC\u00a0Core", "modules.jdbc-core"));
        db.addSection(new DocSection("JDBC\u00a0PostgreSQL", "modules.jdbc-postgresql"));
        db.addSection(new DocSection("Chinook\u00a0Dataset", "modules.chinook-postgresql"));
        content.add(db);
        DocSection web = new DocSection("Web", "web");
        web.addSection(new DocSection("Http\u00a0Client\u00a0J8", "modules.http-client-j8"));
        web.addSection(new DocSection("Tomcat\u00a0WebApp\u00a0Server", "modules.tomcat"));
        web.addSection(new DocSection("Ring", "modules.ring"));
        web.addSection(new DocSection("Multipart", "modules.multipart"));
        web.addSection(new DocSection("SSE", "modules.sse"));
        content.add(web);
        DocSection llm = new DocSection("LLM", "llm");
        llm.addSection(new DocSection("OpenAI", "modules.openai"));
        llm.addSection(new DocSection("JTokkit", "modules.jtokkit"));
        content.add(llm);
        DocSection docker = new DocSection("Docker", "docker");
        docker.addSection(new DocSection("Docker", "modules.docker"));
        docker.addSection(new DocSection("Cargo", "modules.cargo"));
        docker.addSection(new DocSection("Cargo/ArangoDB", "modules.cargo-arangodb"));
        docker.addSection(new DocSection("Cargo/Qdrant", "modules.cargo-qdrant"));
        docker.addSection(new DocSection("Cargo/PostgreSQL", "modules.cargo-postgresql"));
        content.add(docker);
        DocSection license = new DocSection("License", "license");
        license.addSection(new DocSection("License", "license"));
        content.add(license);
        DocSection others = new DocSection("Others", "others");
        others.addSection(new DocSection("Embedding in Java", "embedding"));
        others.addSection(new DocSection("Venice Doc", "venicedoc"));
        others.addSection(new DocSection("Markdown", "markdown"));
        content.add(others);
        return content;
    }

    private List<MarkdownDoc> getMarkdownTopics() {
        ArrayList<MarkdownDoc> topics = new ArrayList<MarkdownDoc>();
        topics.add(new MarkdownDoc("Recursion", new TextRenderer().softWrap(120).render(this.loadVeniceDocMarkdown("recursion-doc.md")), new HtmlRenderer().render(this.loadVeniceDocMarkdown("recursion-doc.md")), "concepts.recursion"));
        topics.add(new MarkdownDoc("Destructuring", new TextRenderer().softWrap(120).render(this.loadVeniceDocMarkdown("destructuring-doc.md")), new HtmlRenderer().render(this.loadVeniceDocMarkdown("destructuring-doc.md")), "concepts.destructuring"));
        topics.add(new MarkdownDoc("VeniceDoc", new TextRenderer().softWrap(120).render(this.loadVeniceDocMarkdown("venice-doc.md")), new HtmlRenderer().render(this.loadVeniceDocMarkdown("venice-doc.md")), "venicedoc"));
        topics.add(new MarkdownDoc("Markdown", new TextRenderer().softWrap(120).render(this.loadVeniceDocMarkdown("markdown-doc.md")), new HtmlRenderer().render(this.loadVeniceDocMarkdown("markdown-doc.md")), "markdown"));
        return topics;
    }

    private List<DocSection> getLeftSections() {
        return Arrays.asList(new PrimitivesSection(this.diBuilder).section(), new ByteBufSection(this.diBuilder).section(), new RegexSection(this.diBuilder).section(), new MathSection(this.diBuilder).section(), new TransducersSection(this.diBuilder).section(), new FunctionsSection(this.diBuilder).section(), new MacrosSection(this.diBuilder).section(), new SpecialFormsSection(this.diBuilder).section(), new ExceptionsSection(this.diBuilder).section(), new TypesSection(this.diBuilder).section(), new ProtocolsSection(this.diBuilder).section(), new NamespaceSection(this.diBuilder).section(), new JavaInteropSection(this.diBuilder).section(), new ReplSection(this.diBuilder).section(), new SandboxSection(this.diBuilder).section(), new LoadPathSection(this.diBuilder).section(), new PdfSection(this.diBuilder).section(), new IoZipSection(this.diBuilder).section(), new LicenseSection(this.diBuilder).section());
    }

    private List<DocSection> getRightSections() {
        return Arrays.asList(new CollectionsSection(this.diBuilder).section(), new LazySequencesSection(this.diBuilder).section(), new ArraySection(this.diBuilder).section(), new ConcurrencySection(this.diBuilder).section(), new SystemSection(this.diBuilder).section(), new SystemVarSection(this.diBuilder).section(), new TapSection(this.diBuilder).section(), new TimeSection(this.diBuilder).section(), new IoSection(this.diBuilder).section(), new IoFileSection(this.diBuilder).section(), new JsonSection(this.diBuilder).section(), new InetSection(this.diBuilder).section(), new CidrSection(this.diBuilder).section(), new CsvSection(this.diBuilder).section());
    }

    private List<DocSection> getModulesLeftSections() {
        return Arrays.asList(new ModuleKiraSection(this.diBuilder).section(), new ModuleCryptographySection(this.diBuilder).section(), new ModuleJsonlSection(this.diBuilder).section(), new ModuleZipVaultSection(this.diBuilder).section(), new ModuleXmlSection(this.diBuilder).section(), new ModuleJavaSection(this.diBuilder).section(), new ModuleParsifalSection(this.diBuilder).section(), new ModuleGradleWrapperSection(this.diBuilder).section(), new ModuleGradleSection(this.diBuilder).section(), new ModuleMavenSection(this.diBuilder).section(), new ModuleDockerSection(this.diBuilder).section(), new ModuleCargoSection(this.diBuilder).section(), new ModuleCargoArangoDBSection(this.diBuilder).section(), new ModuleCargoQdrantDBSection(this.diBuilder).section(), new ModuleCargoPostgresqlDBSection(this.diBuilder).section(), new ModuleTomcatSection(this.diBuilder).section(), new ModuleRingSection(this.diBuilder).section(), new ModuleTracingSection(this.diBuilder).section(), new ModuleShellSection(this.diBuilder).section(), new ModuleJdbcCoreSection(this.diBuilder).section(), new ModuleInstallerSection(this.diBuilder).section(), new ModuleJdbcPostgreSQLSection(this.diBuilder).section(), new ModuleChinookPostgreSQLSection(this.diBuilder).section());
    }

    private List<DocSection> getModulesRightSections() {
        return Arrays.asList(new ModuleHexdumpSection(this.diBuilder).section(), new ModuleSemverSection(this.diBuilder).section(), new ModuleGeoipSection(this.diBuilder).section(), new ModuleExcelSection(this.diBuilder).section(), new ModuleFontsSection(this.diBuilder).section(), new ModuleTestSection(this.diBuilder).section(), new ModuleConfigSection(this.diBuilder).section(), new ModuleComponentSection(this.diBuilder).section(), new ModuleAppSection(this.diBuilder).section(), new ModuleBenchmarkSection(this.diBuilder).section(), new ModuleTimingSection(this.diBuilder).section(), new ModuleGrepSection(this.diBuilder).section(), new ModuleQrRefSection(this.diBuilder).section(), new ModuleAsciiTableSection(this.diBuilder).section(), new ModuleMatrixSection(this.diBuilder).section(), new ModuleAnsiSection(this.diBuilder).section(), new ModuleMimetypesSection(this.diBuilder).section(), new ModuleMultipartSection(this.diBuilder).section(), new ModuleSseSection(this.diBuilder).section(), new ModuleHttpClientJ8Section(this.diBuilder).section(), new ModuleOpenAiSection(this.diBuilder).section(), new ModuleJTokkitSection(this.diBuilder).section(), new ModuleImagesSection(this.diBuilder).section());
    }

    private List<DocItem> getDocItems(List<DocSection> sections) {
        return sections.stream().map(s -> s.getSections()).flatMap(Collection::stream).map(s -> s.getSections()).flatMap(Collection::stream).map(s -> s.getItems()).flatMap(Collection::stream).filter(i -> !StringUtil.isBlank(i.getName())).distinct().sorted(Comparator.comparing(DocItem::getName)).collect(Collectors.toList());
    }

    private List<DocSection> concat(List<DocSection> s1, List<DocSection> s2, List<DocSection> s3, List<DocSection> s4) {
        ArrayList<DocSection> list = new ArrayList<DocSection>();
        list.addAll(s1);
        list.addAll(s2);
        list.addAll(s3);
        list.addAll(s4);
        return list;
    }

    private void save(File file, String text) throws Exception {
        this.save(file, text.getBytes("UTF-8"));
    }

    private void save(File file, byte[] data) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data, 0, data.length);
            fos.flush();
        }
    }

    private File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    private Markdown loadVeniceDocMarkdown(String ressource) {
        try {
            return Markdown.parse(new ClassPathResource(Venice.class.getPackage(), "docgen/" + ressource).getResourceAsString("UTF-8"));
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to read '" + ressource + "'!", ex);
        }
    }

    private final void validateUniqueSectionsId(List<DocSection> left, List<DocSection> right) {
        HashSet ids = new HashSet();
        left.forEach(s -> this.validateUniqueSectionId((DocSection)s, ids));
        right.forEach(s -> this.validateUniqueSectionId((DocSection)s, ids));
    }

    private final void validateUniqueSectionId(DocSection section, Set<String> ids) {
        String id = section.getId();
        if (id != null) {
            if (ids.contains(section.getId())) {
                throw new RuntimeException(String.format("Non unique section id %s on section %s", id, section.getTitle()));
            }
            ids.add(id);
        }
        section.getSections().forEach(s -> this.validateUniqueSectionId((DocSection)s, ids));
    }
}

