/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.env;

import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.util.Tuple2;
import java.util.List;
import java.util.stream.Collectors;
import org.repackage.org.jline.utils.Levenshtein;

public class EnvSymbolLookupUtil {
    public static List<VncSymbol> getGlobalSymbolCandidates(String name, Env env, int limit) {
        List<VncSymbol> globalSymbols = env.getAllGlobalFunctionSymbols();
        List<VncSymbol> candidates = EnvSymbolLookupUtil.getGlobalSymbolCandidates(name, globalSymbols, 5, 0);
        if (candidates.isEmpty()) {
            candidates = EnvSymbolLookupUtil.getGlobalSymbolCandidates(name, globalSymbols, 5, 1);
        }
        return candidates;
    }

    public static List<VncSymbol> getGlobalSymbolCandidates(String name, List<VncSymbol> globalFunctionSymbols, int limit, int levenshteinDistance) {
        if (levenshteinDistance == 0) {
            return globalFunctionSymbols.stream().filter(s -> s.getSimpleName().equals(name)).sorted().limit(limit).collect(Collectors.toList());
        }
        return globalFunctionSymbols.stream().map(s -> new Tuple2<Integer, VncSymbol>(Levenshtein.distance(name, s.getSimpleName()), (VncSymbol)s)).filter(t -> (Integer)t.getFirst() <= levenshteinDistance).sorted().map(t -> (VncSymbol)t.getSecond()).limit(limit).collect(Collectors.toList());
    }

    public static String getSymbolNotFoundMsg(VncSymbol sym, List<VncSymbol> candidates) {
        List indented = candidates.stream().map(s -> "   " + s.getQualifiedName()).collect(Collectors.toList());
        return String.format("Symbol '%s' not found!\n\nDid you mean?\n%s\n", sym.getQualifiedName(), String.join((CharSequence)"\n", indented));
    }
}

