/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.loadpath;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.loadpath.Access;
import com.github.jlangch.venice.impl.util.loadpath.LoadPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class FileLoadPath
extends LoadPath {
    private final File lpFile;

    public FileLoadPath(File file) {
        this.lpFile = this.canonical(file);
    }

    @Override
    public File path() {
        return this.lpFile;
    }

    @Override
    public boolean isOnPath(File file, Access mode) {
        if (file.isAbsolute()) {
            return this.lpFile.equals(this.canonical(file));
        }
        return file.getParent() == null && this.lpFile.getName().equals(file.getName());
    }

    @Override
    public boolean isRegularFileOnLoadPath(File file, Access mode) {
        return file.isFile() && this.isOnPath(file, mode);
    }

    @Override
    public boolean isDirectoryOnLoadPath(File file, Access mode) {
        return false;
    }

    @Override
    public File normalize(File file) {
        try {
            return this.isOnPath(file, Access.ReadWrite) ? this.lpFile : null;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to normalize the file '%s'!", file.getPath()), ex);
        }
    }

    @Override
    public ByteBuffer load(File file) throws IOException {
        if (file.isAbsolute()) {
            File f = this.canonical(file);
            if (this.lpFile.equals(f) && f.isFile()) {
                return ByteBuffer.wrap(Files.readAllBytes(f.toPath()));
            }
        } else if (file.getParent() == null && this.lpFile.getName().equals(file.getName())) {
            return ByteBuffer.wrap(Files.readAllBytes(this.lpFile.toPath()));
        }
        return null;
    }

    @Override
    public InputStream getInputStream(File file) throws IOException {
        if (file.isAbsolute()) {
            File f = this.canonical(file);
            if (this.lpFile.equals(f) && f.isFile()) {
                return Files.newInputStream(f.toPath(), new OpenOption[0]);
            }
        } else if (file.getParent() == null && this.lpFile.getName().equals(file.getName())) {
            return Files.newInputStream(this.lpFile.toPath(), new OpenOption[0]);
        }
        return null;
    }

    @Override
    public BufferedReader getBufferedReader(File file, Charset charset) throws IOException {
        if (file.isAbsolute()) {
            File f = this.canonical(file);
            if (this.lpFile.equals(f) && f.isFile()) {
                return Files.newBufferedReader(f.toPath(), charset);
            }
        } else if (file.getParent() == null && this.lpFile.getName().equals(file.getName())) {
            return Files.newBufferedReader(this.lpFile.toPath(), charset);
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream(File file, OpenOption ... options) throws IOException {
        return null;
    }

    public String toString() {
        return this.lpFile.getPath();
    }
}

