/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.renderer.text;

import com.github.jlangch.venice.impl.util.Tuple2;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TextTableLayouter {
    public int[] layoutColWidths(int maxTableWidth, int colSpacing, int[] maxColWidths) {
        int cols = maxColWidths.length;
        int usableWidth = maxTableWidth - (cols - 1) * colSpacing;
        if (Arrays.stream(maxColWidths).sum() <= usableWidth) {
            return maxColWidths;
        }
        if (cols == 1) {
            return new int[]{Math.min(maxColWidths[0], maxTableWidth)};
        }
        if (cols == 2) {
            if (maxColWidths[0] < usableWidth / 3) {
                return new int[]{maxColWidths[0], usableWidth - maxColWidths[0]};
            }
            if (maxColWidths[1] < usableWidth / 3) {
                return new int[]{usableWidth - maxColWidths[1], maxColWidths[1]};
            }
            return new int[]{usableWidth / 2, usableWidth - usableWidth / 2};
        }
        double[] weight = new double[cols];
        for (int ii = 0; ii < maxColWidths.length; ++ii) {
            maxColWidths[ii] = Math.min(usableWidth, maxColWidths[ii]);
        }
        for (int col = 0; col < cols; ++col) {
            double weightedWidth = (double)maxColWidths[col] / (double)usableWidth * 10.0;
            weight[col] = this.clip(weightedWidth, 1.0, 10.0);
        }
        double totalWeight = Arrays.stream(weight).sum();
        int[] widths = new int[cols];
        Arrays.fill(widths, -1);
        List colsOrdered = IntStream.range(0, maxColWidths.length).mapToObj(idx -> new Tuple2<Integer, Integer>(idx, maxColWidths[idx])).sorted(Comparator.comparing(t -> (Integer)t._2).thenComparing(t -> (Integer)t._1)).collect(Collectors.toList());
        int restWidth = usableWidth;
        while (!colsOrdered.isEmpty()) {
            int col = (Integer)((Tuple2)colsOrdered.get((int)0))._1;
            if (colsOrdered.size() == 1) {
                widths[col] = restWidth;
            } else {
                int width = (int)((double)restWidth * weight[col] / totalWeight);
                widths[col] = width = this.clip(width, 1, maxColWidths[col]);
                restWidth -= width;
            }
            colsOrdered = colsOrdered.subList(1, colsOrdered.size());
        }
        return widths;
    }

    private int clip(int value, int min, int max) {
        return Math.min(max, Math.max(min, value));
    }

    private double clip(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }
}

