/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.env;

import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.Tuple2;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class EnvUtils {
    public static String envGlobalsToString(Env env, String regexFilter) {
        return String.join((CharSequence)"\n", EnvUtils.globalVarsFormatted(env, regexFilter));
    }

    public static List<String> globalVarsFormatted(Env env, String regexFilter) {
        return EnvUtils.globalVarsFormatted(env.getAllGlobalSymbols(), regexFilter == null ? null : Pattern.compile(regexFilter));
    }

    public static List<Tuple2<VncSymbol, VncKeyword>> globalVars(Env env, String regexFilter) {
        return EnvUtils.globalVars(env.getAllGlobalSymbols(), regexFilter == null ? null : Pattern.compile(regexFilter));
    }

    public static List<Tuple2<VncSymbol, VncKeyword>> globalVars(Env env, Pattern regexPattern) {
        return EnvUtils.globalVars(env.getAllGlobalSymbols(), regexPattern);
    }

    private static List<Tuple2<VncSymbol, VncKeyword>> globalVars(Map<VncSymbol, Var> vars, Pattern regexPattern) {
        Predicate<String> p = regexPattern == null ? null : regexPattern.asPredicate();
        return vars.values().stream().sorted((a, b) -> a.getName().getName().compareTo(b.getName().getName())).filter(v -> regexPattern == null ? true : p.test(v.getName().getName())).map(v -> new Tuple2<VncSymbol, VncKeyword>(v.getName(), EnvUtils.formatGlobalVarType(v))).collect(Collectors.toList());
    }

    private static List<String> globalVarsFormatted(Map<VncSymbol, Var> vars, Pattern regexPattern) {
        return EnvUtils.globalVars(vars, regexPattern).stream().map(v -> String.format("%s (%s)", v._1, v._2)).collect(Collectors.toList());
    }

    private static VncKeyword formatGlobalVarType(Var var_) {
        VncVal val = var_.getVal();
        if (Types.isVncJavaObject(val)) {
            VncJavaObject vJava = (VncJavaObject)val;
            if (vJava.getDelegateFormalType() != null) {
                return new VncKeyword(vJava.getDelegateFormalType().getName());
            }
            return new VncKeyword(vJava.getDelegate().getClass().getName());
        }
        return Types.getType(val);
    }
}

