/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.reader;

import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.ParseError;
import com.github.jlangch.venice.impl.reader.CharacterReader;
import com.github.jlangch.venice.impl.reader.ReaderPos;
import com.github.jlangch.venice.impl.reader.Token;
import com.github.jlangch.venice.impl.reader.TokenType;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.util.ArrayList;
import java.util.List;

public class Tokenizer {
    private static final int LF = 10;
    private static final int CR = 13;
    private static final int EOF = -1;
    private final CharacterReader reader;
    private final String fileName;
    private final boolean skipWhitespaces;
    private final boolean errorOnUnbalancedStringQuotes;
    private final boolean errorOnIncompleteEscapeChars;
    private final List<Token> tokens = new ArrayList<Token>();

    private Tokenizer(String text, String fileName) {
        this(text, fileName, true, true, true);
    }

    private Tokenizer(String text, String fileName, boolean skipWhitespaces, boolean errorOnUnbalancedStringQuotes, boolean errorOnIncompleteEscapeChars) {
        this.reader = new CharacterReader(text);
        this.fileName = fileName;
        this.skipWhitespaces = skipWhitespaces;
        this.errorOnUnbalancedStringQuotes = errorOnUnbalancedStringQuotes;
        this.errorOnIncompleteEscapeChars = errorOnIncompleteEscapeChars;
    }

    public static List<Token> tokenize(String text, String fileName) {
        return new Tokenizer(text, fileName, true, true, true).tokenize();
    }

    public static List<Token> tokenize(String text, String fileName, boolean skipWhitespaces, boolean errorOnUnbalancedStringQuotes, boolean errorOnIncompleteEscapeChars) {
        return new Tokenizer(text, fileName, skipWhitespaces, errorOnUnbalancedStringQuotes, errorOnIncompleteEscapeChars).tokenize();
    }

    private List<Token> tokenize() {
        this.tokens.clear();
        try {
            while (true) {
                ReaderPos pos = this.reader.getPos();
                int ch = this.reader.peek();
                if (ch != -1) {
                    int chNext;
                    if (ch == 10) {
                        this.addToken(TokenType.WHITESPACES, "\n", pos);
                        this.reader.consume();
                        continue;
                    }
                    if (ch == 35) {
                        this.reader.consume();
                        chNext = this.reader.peek();
                        if (chNext == 92) {
                            this.reader.consume();
                            this.processCharReaderMacro(pos);
                            continue;
                        }
                        this.addToken(TokenType.ANY, String.valueOf('#'), pos);
                        continue;
                    }
                    if (this.isWhitespace((char)ch)) {
                        StringBuilder sb = new StringBuilder();
                        sb.append((char)ch);
                        this.reader.consume();
                        while (this.isWhitespace((char)this.reader.peek())) {
                            sb.append((char)this.reader.peek());
                            this.reader.consume();
                        }
                        this.addToken(TokenType.WHITESPACES, sb.toString(), pos);
                        continue;
                    }
                    if (ch == 126) {
                        this.reader.consume();
                        chNext = this.reader.peek();
                        if (chNext == 64) {
                            this.addToken(TokenType.UNQUOTE_SPLICE, "~@", pos);
                            this.reader.consume();
                            continue;
                        }
                        this.addToken(TokenType.SPECIAL_CHAR, "~", pos);
                        continue;
                    }
                    if (this.isSpecialChar((char)ch)) {
                        this.reader.consume();
                        this.addToken(TokenType.SPECIAL_CHAR, String.valueOf((char)ch), pos);
                        continue;
                    }
                    if (ch == 34) {
                        this.readString(pos);
                        continue;
                    }
                    if (ch == 59) {
                        this.readComment(pos);
                        continue;
                    }
                    if (ch == 44) {
                        this.reader.consume();
                        this.addToken(TokenType.WHITESPACES, ",", pos);
                        continue;
                    }
                    this.readAny(ch, pos);
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException ex) {
            throw new ParseError("Parse error (tokenizer phase) while reading from input", ex);
        }
        return this.tokens;
    }

    private void readAny(int firstChar, ReaderPos pos) {
        this.reader.consume();
        StringBuilder sb = new StringBuilder();
        sb.append((char)firstChar);
        int ch = this.reader.peek();
        while (ch != -1 && !this.isWhitespace((char)ch) && ch != 44 && ch != 59 && ch != 34 && !this.isSpecialChar((char)ch)) {
            sb.append((char)ch);
            this.reader.consume();
            ch = this.reader.peek();
        }
        this.addToken(TokenType.ANY, sb.toString(), pos);
    }

    private void readComment(ReaderPos pos) {
        this.reader.consume();
        StringBuilder sb = new StringBuilder();
        sb.append(';');
        while (10 != this.reader.peek() && -1 != this.reader.peek()) {
            sb.append((char)this.reader.peek());
            this.reader.consume();
        }
        this.addToken(TokenType.COMMENT, sb.toString(), pos);
    }

    private void processCharReaderMacro(ReaderPos startPos) {
        StringBuilder sb = new StringBuilder("#\\");
        int ch = this.reader.peek();
        if (ch == 117) {
            this.reader.consume();
            sb.append('u');
            while (this.isHexChar((char)this.reader.peek())) {
                sb.append((char)this.reader.peek());
                this.reader.consume();
            }
        } else if (ch > 32) {
            this.reader.consume();
            sb.append((char)ch);
            while (this.isAsciiLetterOrDash((char)this.reader.peek())) {
                sb.append((char)this.reader.peek());
                this.reader.consume();
            }
        }
        this.addToken(TokenType.ANY, sb.toString(), startPos);
    }

    private void readString(ReaderPos pos) {
        this.reader.consume();
        int chNext = this.reader.peek();
        if (chNext != 34) {
            String s = this.readSingleQuotedString(pos);
            this.addToken(TokenType.STRING, s, pos);
        } else {
            this.reader.consume();
            int chNextNext = this.reader.peek();
            if (chNextNext != 34) {
                this.addToken(TokenType.STRING, "\"\"", pos);
            } else {
                this.reader.consume();
                this.addToken(TokenType.STRING_BLOCK, this.readTripleQuotedString(pos), pos);
            }
        }
    }

    private String readSingleQuotedString(ReaderPos posStart) {
        StringBuilder sb = new StringBuilder("\"");
        while (true) {
            int ch;
            if ((ch = this.reader.peek()) == -1) {
                if (!this.errorOnUnbalancedStringQuotes) break;
                throw new ParseError(this.formatParseError(new Token(TokenType.STRING, sb.toString(), this.fileName, posStart), "Expected closing \" for single quoted string but got EOF", new Object[0]));
            }
            if (ch == 34) {
                this.reader.consume();
                sb.append((char)ch);
                break;
            }
            if (ch == 92) {
                ReaderPos pos = this.reader.getPos();
                this.reader.consume();
                sb.append((char)ch);
                this.readStringEscapeChar(TokenType.STRING, pos, sb);
                continue;
            }
            this.reader.consume();
            sb.append((char)ch);
        }
        return sb.toString();
    }

    private String readTripleQuotedString(ReaderPos posStart) {
        StringBuilder sb = new StringBuilder("\"\"\"");
        block0: while (true) {
            int ch;
            if ((ch = this.reader.peek()) == -1) {
                if (!this.errorOnUnbalancedStringQuotes) break;
                throw new ParseError(this.formatParseError(new Token(TokenType.STRING_BLOCK, sb.toString(), this.fileName, posStart), "Expected closing \" for triple quoted string but got EOF", new Object[0]));
            }
            if (ch == 34) {
                this.reader.consume();
                sb.append('\"');
                int chNext = this.reader.peek();
                if (chNext != 34) continue;
                this.reader.consume();
                sb.append('\"');
                int chNextNext = this.reader.peek();
                if (chNextNext != 34) continue;
                this.reader.consume();
                sb.append('\"');
                break;
            }
            if (ch == 92) {
                ReaderPos pos = this.reader.getPos();
                this.reader.consume();
                int chNext = this.reader.peek();
                if (chNext == 10 || chNext == 13) {
                    while (this.isCRorLF((char)this.reader.peek())) {
                        this.reader.consume();
                    }
                    while (true) {
                        if (' ' != (char)this.reader.peek()) continue block0;
                        this.reader.consume();
                    }
                }
                sb.append((char)ch);
                this.readStringEscapeChar(TokenType.STRING, pos, sb);
                continue;
            }
            this.reader.consume();
            sb.append((char)ch);
        }
        return sb.toString();
    }

    private boolean isSpecialChar(char ch) {
        switch (ch) {
            case '\'': 
            case '(': 
            case ')': 
            case '@': 
            case '[': 
            case ']': 
            case '^': 
            case '`': 
            case '{': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private boolean isWhitespace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private void addToken(TokenType type, String token, ReaderPos pos) {
        if (!this.skipWhitespaces || type != TokenType.WHITESPACES && type != TokenType.COMMENT) {
            this.tokens.add(new Token(type, token, this.fileName, pos));
        }
    }

    private void readStringEscapeChar(TokenType type, ReaderPos pos, StringBuilder sb) {
        int ch = this.reader.peek();
        this.reader.consume();
        if (ch == 10 || ch == 13) {
            if (this.errorOnIncompleteEscapeChars) {
                throw new ParseError(this.formatParseError(new Token(type, "\\", this.fileName, pos), "Expected escaped char in a string but got EOL", new Object[0]));
            }
        } else if (ch == -1) {
            if (this.errorOnIncompleteEscapeChars) {
                throw new EofException(this.formatParseError(new Token(type, "\\", this.fileName, pos), "Expected escaped char in a string but got EOF", new Object[0]));
            }
        } else {
            sb.append((char)ch);
        }
    }

    private boolean isHexChar(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    private boolean isAsciiLetterOrDash(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '-';
    }

    private boolean isCRorLF(char ch) {
        return ch == '\r' || ch == '\n';
    }

    private String formatParseError(Token token, String format, Object ... args) {
        return String.format(format, args) + ". " + ErrorMessage.buildErrLocation(token);
    }
}

