/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBigInteger;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncNumber;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class VncFloat
extends VncNumber {
    public static final String TYPE = ":core/float";
    private static final long serialVersionUID = -1848883965231344442L;
    private final float value;

    public VncFloat(Float v) {
        super(null, Constants.Nil);
        this.value = v.floatValue();
    }

    public VncFloat(Double v) {
        super(null, Constants.Nil);
        this.value = v.floatValue();
    }

    public VncFloat(Long v) {
        super(null, Constants.Nil);
        this.value = v.floatValue();
    }

    public VncFloat(Integer v) {
        super(null, Constants.Nil);
        this.value = v.floatValue();
    }

    public VncFloat(Float v, VncVal meta) {
        super(null, meta);
        this.value = v.floatValue();
    }

    public VncFloat(Float v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v.floatValue();
    }

    public static VncFloat of(VncVal v) {
        if (Types.isVncNumber(v)) {
            return new VncFloat(Float.valueOf(((VncNumber)v).toJavaFloat()));
        }
        throw new VncException(String.format("Cannot convert value of type %s to float", Types.getType(v)));
    }

    @Override
    public VncFloat withMeta(VncVal meta) {
        return new VncFloat(Float.valueOf(this.value), this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncFloat wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncFloat(Float.valueOf(this.value), wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? new VncKeyword(this.getWrappingTypeDef().getType().getQualifiedName(), MetaUtil.typeMeta(new VncKeyword(TYPE), new VncKeyword(":core/number"), new VncKeyword(":core/val"))) : new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/number"), new VncKeyword(":core/val")));
    }

    @Override
    public VncFloat inc() {
        return new VncFloat(Float.valueOf(this.value + 1.0f));
    }

    @Override
    public VncFloat dec() {
        return new VncFloat(Float.valueOf(this.value - 1.0f));
    }

    @Override
    public VncFloat negate() {
        return new VncFloat(Float.valueOf(this.value * -1.0f));
    }

    @Override
    public VncNumber add(VncVal op) {
        if (op instanceof VncFloat) {
            return new VncFloat(Float.valueOf(this.value + ((VncFloat)op).value));
        }
        if (op instanceof VncDouble) {
            return new VncDouble((double)this.value + ((VncDouble)op).toJavaDouble());
        }
        if (op instanceof VncLong) {
            return new VncFloat(Float.valueOf(this.value + ((VncLong)op).toJavaFloat()));
        }
        if (op instanceof VncInteger) {
            return new VncFloat(Float.valueOf(this.value + ((VncInteger)op).toJavaFloat()));
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().add(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigInteger) {
            return new VncBigDecimal(this.toJavaBigDecimal().add(((VncBigInteger)op).toJavaBigDecimal()));
        }
        throw new VncException(String.format("Function + operand of type %s is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber sub(VncVal op) {
        if (op instanceof VncFloat) {
            return new VncFloat(Float.valueOf(this.value - ((VncFloat)op).value));
        }
        if (op instanceof VncDouble) {
            return new VncDouble((double)this.value - ((VncDouble)op).toJavaDouble());
        }
        if (op instanceof VncLong) {
            return new VncFloat(Float.valueOf(this.value - ((VncLong)op).toJavaFloat()));
        }
        if (op instanceof VncInteger) {
            return new VncFloat(Float.valueOf(this.value - ((VncInteger)op).toJavaFloat()));
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().subtract(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigInteger) {
            return new VncBigDecimal(this.toJavaBigDecimal().subtract(((VncBigInteger)op).toJavaBigDecimal()));
        }
        throw new VncException(String.format("Function - operand of type %s is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber mul(VncVal op) {
        if (op instanceof VncFloat) {
            return new VncFloat(Float.valueOf(this.value * ((VncFloat)op).value));
        }
        if (op instanceof VncDouble) {
            return new VncDouble((double)this.value * ((VncDouble)op).toJavaDouble());
        }
        if (op instanceof VncLong) {
            return new VncFloat(Float.valueOf(this.value * ((VncLong)op).toJavaFloat()));
        }
        if (op instanceof VncInteger) {
            return new VncFloat(Float.valueOf(this.value * ((VncInteger)op).toJavaFloat()));
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().multiply(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigInteger) {
            return new VncBigDecimal(this.toJavaBigDecimal().multiply(((VncBigInteger)op).toJavaBigDecimal()));
        }
        throw new VncException(String.format("Function * operand of type %s is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber div(VncVal op) {
        try {
            if (op instanceof VncFloat) {
                return new VncFloat(Float.valueOf(this.value / ((VncFloat)op).value));
            }
            if (op instanceof VncDouble) {
                return new VncDouble((double)this.value / ((VncDouble)op).toJavaDouble());
            }
            if (op instanceof VncLong) {
                return new VncFloat(Float.valueOf(this.value / ((VncLong)op).toJavaFloat()));
            }
            if (op instanceof VncInteger) {
                return new VncFloat(Float.valueOf(this.value / ((VncInteger)op).toJavaFloat()));
            }
            if (op instanceof VncBigDecimal) {
                return new VncBigDecimal(this.toJavaBigDecimal().divide(((VncBigDecimal)op).toJavaBigDecimal(), 16, RoundingMode.HALF_UP));
            }
            if (op instanceof VncBigInteger) {
                return new VncBigDecimal(this.toJavaBigDecimal().divide(((VncBigInteger)op).toJavaBigDecimal(), 16, RoundingMode.HALF_UP));
            }
            throw new VncException(String.format("Function / operand of type %s is not a numeric type", Types.getType(op)));
        }
        catch (ArithmeticException ex) {
            throw new VncException(ex.getMessage());
        }
    }

    @Override
    public VncBoolean equ(VncVal other) {
        if (other instanceof VncFloat) {
            return VncBoolean.of(this.value == ((VncFloat)other).value);
        }
        if (other instanceof VncDouble) {
            return VncBoolean.of((double)this.value == (double)((VncDouble)other).toJavaFloat());
        }
        if (other instanceof VncLong) {
            return VncBoolean.of(this.value == ((VncLong)other).toJavaFloat());
        }
        if (other instanceof VncInteger) {
            return VncBoolean.of(this.value == ((VncInteger)other).toJavaFloat());
        }
        if (other instanceof VncBigDecimal) {
            return VncBoolean.of(this.toJavaBigDecimal().compareTo(((VncBigDecimal)other).toJavaBigDecimal()) == 0);
        }
        if (other instanceof VncBigInteger) {
            return VncBoolean.of(this.toJavaBigInteger().compareTo(((VncBigInteger)other).toJavaBigInteger()) == 0);
        }
        throw new VncException(String.format("Function == operand of type %s is not a numeric type", Types.getType(other)));
    }

    @Override
    public VncBoolean zeroQ() {
        return VncBoolean.of(this.value == 0.0f);
    }

    @Override
    public VncBoolean posQ() {
        return VncBoolean.of(this.value > 0.0f);
    }

    @Override
    public VncBoolean negQ() {
        return VncBoolean.of(this.value < 0.0f);
    }

    @Override
    public VncNumber square() {
        return new VncFloat(Float.valueOf(this.value * this.value));
    }

    @Override
    public VncNumber sqrt() {
        return new VncFloat(Math.sqrt(this.value));
    }

    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public Float getFloatValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.FLOAT;
    }

    @Override
    public Object convertToJavaObject() {
        return Float.valueOf(this.value);
    }

    @Override
    public int toJavaInteger() {
        return (int)this.value;
    }

    @Override
    public long toJavaLong() {
        return (long)this.value;
    }

    @Override
    public float toJavaFloat() {
        return this.value;
    }

    @Override
    public double toJavaDouble() {
        return this.value;
    }

    @Override
    public BigInteger toJavaBigInteger() {
        return BigInteger.valueOf((long)this.value);
    }

    @Override
    public BigDecimal toJavaBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public BigDecimal toJavaBigDecimal(int scale) {
        return new BigDecimal(this.value).setScale(scale);
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncFloat(o)) {
            float other = ((VncFloat)o).value;
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (Types.isVncDouble(o)) {
            double other = ((VncDouble)o).toJavaDouble();
            return (double)this.value < other ? -1 : ((double)this.value == other ? 0 : 1);
        }
        if (Types.isVncInteger(o)) {
            float other = ((VncInteger)o).toJavaFloat();
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (Types.isVncLong(o)) {
            float other = ((VncLong)o).toJavaFloat();
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (Types.isVncBigDecimal(o)) {
            BigDecimal other = ((VncBigDecimal)o).toJavaBigDecimal();
            BigDecimal thisVal = this.toJavaBigDecimal();
            return thisVal.compareTo(other);
        }
        if (Types.isVncBigInteger(o)) {
            BigInteger other = ((VncBigInteger)o).toJavaBigInteger();
            BigInteger thisVal = this.toJavaBigInteger();
            return thisVal.compareTo(other);
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return Float.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value == ((VncFloat)obj).value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public String toString(boolean print_machine_readably) {
        if (print_machine_readably) {
            if (Float.isInfinite(this.value)) {
                return ":Infinite";
            }
            if (Float.isNaN(this.value)) {
                return ":NaN";
            }
            return String.valueOf(this.value) + "F";
        }
        return String.valueOf(this.value);
    }
}

