/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBigInteger;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFloat;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncNumber;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class VncInteger
extends VncNumber {
    public static final String TYPE = ":core/integer";
    private static final long serialVersionUID = -1848883965231344442L;
    private final int value;

    public VncInteger(int v) {
        super(null, Constants.Nil);
        this.value = v;
    }

    public VncInteger(int v, VncVal meta) {
        super(null, meta);
        this.value = v;
    }

    public VncInteger(int v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v;
    }

    public static VncInteger of(VncVal v) {
        if (Types.isVncNumber(v)) {
            return new VncInteger(((VncNumber)v).toJavaInteger());
        }
        throw new VncException(String.format("Cannot convert value of type %s to integer", Types.getType(v)));
    }

    @Override
    public VncInteger withMeta(VncVal meta) {
        return new VncInteger(this.value, this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncInteger wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncInteger(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? new VncKeyword(this.getWrappingTypeDef().getType().getQualifiedName(), MetaUtil.typeMeta(new VncKeyword(TYPE), new VncKeyword(":core/number"), new VncKeyword(":core/val"))) : new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/number"), new VncKeyword(":core/val")));
    }

    @Override
    public VncInteger inc() {
        return new VncInteger(this.value + 1);
    }

    @Override
    public VncInteger dec() {
        return new VncInteger(this.value - 1);
    }

    @Override
    public VncInteger negate() {
        return new VncInteger(Math.negateExact(this.value));
    }

    @Override
    public VncNumber add(VncVal op) {
        if (op instanceof VncInteger) {
            return new VncInteger(this.value + ((VncInteger)op).value);
        }
        if (op instanceof VncLong) {
            return new VncLong((long)this.value + ((VncLong)op).toJavaLong());
        }
        if (op instanceof VncFloat) {
            return new VncFloat(Float.valueOf((float)this.value + ((VncFloat)op).toJavaFloat()));
        }
        if (op instanceof VncDouble) {
            return new VncDouble((double)this.value + ((VncDouble)op).toJavaDouble());
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().add(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigInteger) {
            return new VncBigInteger(this.toJavaBigInteger().add(((VncBigInteger)op).toJavaBigInteger()));
        }
        throw new VncException(String.format("Function + operand of type %s is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber sub(VncVal op) {
        if (op instanceof VncInteger) {
            return new VncInteger(this.value - ((VncInteger)op).value);
        }
        if (op instanceof VncLong) {
            return new VncLong((long)this.value - ((VncLong)op).toJavaLong());
        }
        if (op instanceof VncFloat) {
            return new VncFloat(Float.valueOf((float)this.value - ((VncFloat)op).toJavaFloat()));
        }
        if (op instanceof VncDouble) {
            return new VncDouble((double)this.value - ((VncDouble)op).toJavaDouble());
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().subtract(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigInteger) {
            return new VncBigInteger(this.toJavaBigInteger().subtract(((VncBigInteger)op).toJavaBigInteger()));
        }
        throw new VncException(String.format("Function - operand of type %s is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber mul(VncVal op) {
        if (op instanceof VncInteger) {
            return new VncInteger(this.value * ((VncInteger)op).value);
        }
        if (op instanceof VncLong) {
            return new VncLong((long)this.value * ((VncLong)op).toJavaLong());
        }
        if (op instanceof VncFloat) {
            return new VncFloat(Float.valueOf((float)this.value * ((VncFloat)op).toJavaFloat()));
        }
        if (op instanceof VncDouble) {
            return new VncDouble((double)this.value * ((VncDouble)op).toJavaDouble());
        }
        if (op instanceof VncBigDecimal) {
            return new VncBigDecimal(this.toJavaBigDecimal().multiply(((VncBigDecimal)op).toJavaBigDecimal()));
        }
        if (op instanceof VncBigInteger) {
            return new VncBigInteger(this.toJavaBigInteger().multiply(((VncBigInteger)op).toJavaBigInteger()));
        }
        throw new VncException(String.format("Function * operand of type %s is not a numeric type", Types.getType(op)));
    }

    @Override
    public VncNumber div(VncVal op) {
        try {
            if (op instanceof VncInteger) {
                return new VncInteger(this.value / ((VncInteger)op).value);
            }
            if (op instanceof VncLong) {
                return new VncLong((long)this.value / ((VncLong)op).toJavaLong());
            }
            if (op instanceof VncFloat) {
                return new VncFloat(Float.valueOf((float)this.value / ((VncFloat)op).toJavaFloat()));
            }
            if (op instanceof VncDouble) {
                return new VncDouble((double)this.value / ((VncDouble)op).toJavaDouble());
            }
            if (op instanceof VncBigDecimal) {
                return new VncBigDecimal(this.toJavaBigDecimal().divide(((VncBigDecimal)op).toJavaBigDecimal(), 16, RoundingMode.HALF_UP));
            }
            if (op instanceof VncBigInteger) {
                return new VncBigInteger(this.toJavaBigInteger().divide(((VncBigInteger)op).toJavaBigInteger()));
            }
            throw new VncException(String.format("Function / operand of type %s is not a numeric type", Types.getType(op)));
        }
        catch (ArithmeticException ex) {
            throw new VncException(ex.getMessage());
        }
    }

    @Override
    public VncBoolean equ(VncVal other) {
        if (other instanceof VncInteger) {
            return VncBoolean.of(this.value == ((VncInteger)other).value);
        }
        if (other instanceof VncLong) {
            return VncBoolean.of((long)this.value == ((VncLong)other).toJavaLong());
        }
        if (other instanceof VncFloat) {
            return VncBoolean.of(this.toJavaFloat() == ((VncFloat)other).toJavaFloat());
        }
        if (other instanceof VncDouble) {
            return VncBoolean.of(this.toJavaDouble() == ((VncDouble)other).toJavaDouble());
        }
        if (other instanceof VncBigDecimal) {
            return VncBoolean.of(this.toJavaBigDecimal().compareTo(((VncBigDecimal)other).toJavaBigDecimal()) == 0);
        }
        if (other instanceof VncBigInteger) {
            return VncBoolean.of(this.toJavaBigInteger().compareTo(((VncBigInteger)other).toJavaBigInteger()) == 0);
        }
        throw new VncException(String.format("Function == operand of type %s is not a numeric type", Types.getType(other)));
    }

    @Override
    public VncBoolean zeroQ() {
        return VncBoolean.of(this.value == 0);
    }

    @Override
    public VncBoolean posQ() {
        return VncBoolean.of(this.value > 0);
    }

    @Override
    public VncBoolean negQ() {
        return VncBoolean.of(this.value < 0);
    }

    @Override
    public VncNumber square() {
        return new VncInteger(this.value * this.value);
    }

    @Override
    public VncNumber sqrt() {
        return new VncDouble(Math.sqrt(this.value));
    }

    public Integer getValue() {
        return this.value;
    }

    public Long getLongValue() {
        return this.value;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.INTEGER;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int toJavaInteger() {
        return this.value;
    }

    @Override
    public long toJavaLong() {
        return this.value;
    }

    @Override
    public float toJavaFloat() {
        return this.value;
    }

    @Override
    public double toJavaDouble() {
        return this.value;
    }

    @Override
    public BigInteger toJavaBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public BigDecimal toJavaBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public BigDecimal toJavaBigDecimal(int scale) {
        return new BigDecimal(this.value).setScale(scale);
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncInteger(o)) {
            int other = ((VncInteger)o).value;
            return this.value < other ? -1 : (this.value == other ? 0 : 1);
        }
        if (Types.isVncLong(o)) {
            long other = ((VncLong)o).toJavaLong();
            return (long)this.value < other ? -1 : ((long)this.value == other ? 0 : 1);
        }
        if (Types.isVncFloat(o)) {
            float other = ((VncFloat)o).toJavaFloat();
            return (float)this.value < other ? -1 : ((float)this.value == other ? 0 : 1);
        }
        if (Types.isVncDouble(o)) {
            double other = ((VncDouble)o).toJavaDouble();
            return (double)this.value < other ? -1 : ((double)this.value == other ? 0 : 1);
        }
        if (Types.isVncBigDecimal(o)) {
            BigDecimal other = ((VncBigDecimal)o).toJavaBigDecimal();
            BigDecimal thisVal = this.toJavaBigDecimal();
            return thisVal.compareTo(other);
        }
        if (Types.isVncBigInteger(o)) {
            BigInteger other = ((VncBigInteger)o).toJavaBigInteger();
            BigInteger thisVal = this.toJavaBigInteger();
            return thisVal.compareTo(other);
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value == ((VncInteger)obj).value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public String toString(boolean print_machine_readably) {
        return print_machine_readably ? String.valueOf(this.value) + "I" : String.valueOf(this.value);
    }
}

