/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.excel;

import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.function.Function;

public class ExcelColumnDef<T> {
    public final String id;
    public final String header;
    public final Function<? super T, ?> colMapper;
    public final Integer width;
    public final String headerStyle;
    public final String bodyStyle;
    public final String footerStyle;
    public final Object footerValue;
    public final FooterType footerType;

    public ExcelColumnDef(String id, String header, Function<? super T, ?> colMapper, Integer width, String headerStyle, String bodyStyle, String footerStyle, Object footerValue, FooterType footerType) {
        this.id = id;
        this.header = StringUtil.trimToEmpty(header);
        this.colMapper = colMapper;
        this.width = width;
        this.headerStyle = headerStyle;
        this.bodyStyle = bodyStyle;
        this.footerStyle = footerStyle;
        this.footerValue = footerValue;
        this.footerType = footerType == null ? FooterType.NONE : footerType;
    }

    public static enum FooterType {
        NONE,
        NUMBER,
        TEXT,
        FORMULA,
        SUM,
        MIN,
        MAX,
        AVERAGE;

    }
}

