/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ssl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

public class CustomHostnameVerifier
implements HostnameVerifier {
    final Set<String> hostnames = new HashSet<String>();
    final Predicate<String> predicate;

    public CustomHostnameVerifier(String hostname) {
        if (hostname != null) {
            this.hostnames.add(hostname);
        }
        this.predicate = null;
    }

    public CustomHostnameVerifier(List<String> hostnames) {
        if (hostnames != null) {
            hostnames.stream().filter(h -> h != null).filter(h -> !h.isEmpty()).forEach(h -> hostnames.add((String)h));
        }
        this.predicate = null;
    }

    public CustomHostnameVerifier(Predicate<String> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean verify(String hostname, SSLSession sslSession) {
        if (this.predicate != null) {
            return this.predicate.test(hostname);
        }
        return this.hostnames.contains(hostname);
    }
}

