/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.io.Serializable;

public abstract class VncVal
implements Comparable<VncVal>,
Serializable {
    public static final String TYPE = ":core/val";
    private static final long serialVersionUID = -1848883965231344442L;
    private final VncVal meta;
    private final boolean _private;
    private final VncWrappingTypeDef wrappingTypeDef;

    public VncVal() {
        this(null, Constants.Nil);
    }

    public VncVal(VncVal meta) {
        this(null, meta);
    }

    public VncVal(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        this.meta = meta == null ? Constants.Nil : meta;
        this.wrappingTypeDef = wrappingTypeDef;
        this._private = MetaUtil.isPrivate(meta);
    }

    public abstract VncVal withMeta(VncVal var1);

    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword[0]));
    }

    public VncWrappingTypeDef getWrappingTypeDef() {
        return this.wrappingTypeDef;
    }

    public boolean isWrapped() {
        return this.wrappingTypeDef != null;
    }

    public VncVal wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        throw new VncException(String.format("The type :%s can not be wrapped!", this.getType().getValue()));
    }

    public abstract TypeRank typeRank();

    public boolean isVncList() {
        return false;
    }

    public abstract Object convertToJavaObject();

    public VncVal getMeta() {
        return this.meta == null ? Constants.Nil : this.meta;
    }

    public VncVal getMetaVal(VncString key) {
        VncVal meta_ = this.getMeta();
        return meta_ instanceof VncHashMap ? ((VncHashMap)meta_).get(key) : Constants.Nil;
    }

    public VncVal getMetaVal(VncString key, VncVal defaultValue) {
        VncVal val = this.getMetaVal(key);
        return val == Constants.Nil ? defaultValue : val;
    }

    public boolean isPrivate() {
        return this._private;
    }

    @Override
    public int compareTo(VncVal o) {
        int c = Integer.valueOf(this.typeRank().getRank()).compareTo(o.typeRank().getRank());
        return c != 0 ? c : -1;
    }

    public String toString(boolean print_machine_readably) {
        return this.toString();
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.getClass() == obj.getClass();
    }
}

