/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.custom;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.specialforms.util.DefTypeForm;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.custom.VncCustomTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncCustomTypeFieldDef;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class VncCustomType
extends VncMap {
    private static final long serialVersionUID = -1848883965231344442L;
    public static final String TYPE = ":core/custom-type";
    private final VncKeyword type;
    private final VncCustomTypeDef typeDef;
    private final VncMap values;

    public VncCustomType(VncCustomTypeDef typeDef, VncMap values, VncVal meta) {
        this(typeDef, values, null, meta);
    }

    public VncCustomType(VncCustomTypeDef typeDef, VncMap values, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.type = typeDef.getType();
        this.typeDef = typeDef;
        this.values = values;
    }

    @Override
    public VncCustomType emptyWithMeta() {
        throw new VncException("not supported for custom types!");
    }

    @Override
    public VncCustomType withValues(Map<VncVal, VncVal> replaceVals) {
        throw new VncException("not supported for custom types!");
    }

    @Override
    public VncCustomType withValues(Map<VncVal, VncVal> replaceVals, VncVal meta) {
        throw new VncException("not supported for custom types!");
    }

    @Override
    public VncCustomType wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncCustomType(this.typeDef, this.values, wrappingTypeDef, meta);
    }

    @Override
    public VncCustomType withMeta(VncVal meta) {
        return new VncCustomType(this.typeDef, this.values, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.type.withMeta(MetaUtil.typeMeta(new VncKeyword(TYPE), new VncKeyword(":core/map"), new VncKeyword(":core/collection"), new VncKeyword(":core/val")));
    }

    public VncCustomTypeDef getTypeDef() {
        return this.typeDef;
    }

    @Override
    public Map<VncVal, VncVal> getJavaMap() {
        return this.values.getJavaMap();
    }

    public VncMap getValuesAsMap() {
        return this.values;
    }

    public VncVector getValuesAsVector() {
        VncVector vec = VncVector.empty();
        for (VncCustomTypeFieldDef f : this.typeDef.getFieldDefs()) {
            vec = vec.addAtEnd(this.values.get(f.getName()));
        }
        return vec;
    }

    @Override
    public VncVal containsKey(VncVal key) {
        return this.values.containsKey(key);
    }

    @Override
    public VncVal get(VncVal key) {
        return this.values.get(key);
    }

    @Override
    public VncList keys() {
        return VncList.ofList(new ArrayList<VncVal>(this.getJavaMap().keySet()));
    }

    @Override
    public List<VncMapEntry> entries() {
        return Collections.unmodifiableList(this.getJavaMap().entrySet().stream().map(e -> new VncMapEntry((VncVal)e.getKey(), (VncVal)e.getValue())).collect(Collectors.toList()));
    }

    @Override
    public VncMap putAll(VncMap map) {
        return this.values.putAll(map);
    }

    @Override
    public VncMap assoc(VncVal ... mvs) {
        if (mvs.length % 2 != 0) {
            throw new VncException(String.format(":core/custom-type: assoc requires an even number of items.", new Object[0]));
        }
        VncMap tmp = this.values;
        for (int i = 0; i < mvs.length; i += 2) {
            tmp = tmp.assoc(mvs[i], mvs[i + 1]);
        }
        return DefTypeForm.createCustomType(this.typeDef, tmp, this.getMeta());
    }

    @Override
    public VncCustomType assoc(VncSequence mvs) {
        if (mvs.size() % 2 != 0) {
            throw new VncException(String.format(":core/custom-type: assoc requires an even number of items.", new Object[0]));
        }
        VncMap map = this.values;
        VncSequence kv = mvs;
        while (!kv.isEmpty()) {
            map = map.assoc(kv.first(), kv.second());
            kv = kv.drop(2);
        }
        return DefTypeForm.createCustomType(this.typeDef, map, this.getMeta());
    }

    @Override
    public VncMap dissoc(VncVal ... keys) {
        return this.values.dissoc(keys);
    }

    @Override
    public VncMap dissoc(VncSequence keys) {
        return this.values.dissoc(keys);
    }

    @Override
    public VncList toVncList() {
        return this.values.toVncList();
    }

    @Override
    public VncVector toVncVector() {
        return this.values.toVncVector();
    }

    public VncMap toVncMap() {
        return this.values;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.CUSTOMTYPE;
    }

    @Override
    public Object convertToJavaObject() {
        return this.values.convertToJavaObject();
    }

    @Override
    public int compareTo(VncVal o) {
        if (o instanceof VncCustomType) {
            VncCustomType other = (VncCustomType)o;
            if (this.type.equals(other.type)) {
                VncFunction fn = this.typeDef.getCustomCompareToFn();
                return fn == null ? this.values.compareTo(other.values) : this.customCompareTo(fn, other);
            }
            return 1;
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncCustomType other = (VncCustomType)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public String toString() {
        VncFunction fn = this.typeDef.getCustomToStringFn();
        return fn == null ? VncOrderedMap.of(new VncKeyword(":custom-type*"), this.type).putAll(this.values).toString() : this.customToString(fn);
    }

    @Override
    public String toString(boolean print_machine_readably) {
        VncFunction fn = this.typeDef.getCustomToStringFn();
        return fn == null ? VncOrderedMap.of(new VncKeyword(":custom-type*"), this.type).putAll(this.values).toString(print_machine_readably) : this.customToString(fn);
    }

    private String customToString(VncFunction fn) {
        VncVal s = fn.apply(VncList.of(this));
        return s == Constants.Nil ? null : s.toString();
    }

    private int customCompareTo(VncFunction fn, VncCustomType other) {
        VncVal ret = fn.apply(VncList.of(this, other));
        if (ret instanceof VncInteger) {
            return ((VncInteger)ret).toJavaInteger();
        }
        if (ret instanceof VncLong) {
            return ((VncLong)ret).toJavaInteger();
        }
        throw new VncException(String.format(":core/custom-type: compareTo protocol function must return an integer", new Object[0]));
    }
}

