/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.io.zip;

import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.IOStreamUtil;
import com.github.jlangch.venice.impl.util.io.zip.ZipEntryAttr;
import com.github.jlangch.venice.impl.util.io.zip.ZipEntryAttrPrinter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Zipper {
    public static final int ZIP_HEADER = 1347093252;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] zip(byte[] binary, String entryName) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        if (StringUtil.isEmpty(entryName)) {
            throw new IllegalArgumentException("A 'entryName' must not be null or empty");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                if ("/".equals(entryName)) {
                    throw new IllegalArgumentException("A 'entryName' must not be \"/\"");
                }
                String name = Zipper.normalizeAndValidateEntryName(entryName);
                if (name.endsWith("/")) {
                    ZipEntry e = new ZipEntry(name);
                    e.setMethod(0);
                    e.setSize(0L);
                    e.setCrc(0L);
                    zos.putNextEntry(e);
                    zos.closeEntry();
                } else {
                    ZipEntry e = new ZipEntry(name);
                    e.setMethod(8);
                    zos.putNextEntry(e);
                    zos.write(binary);
                    zos.closeEntry();
                }
                zos.finish();
                zos.flush();
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] zip(Map<String, Object> entries) {
        if (entries == null) {
            throw new IllegalArgumentException("An 'entries' map must not be null");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                for (Map.Entry<String, Object> entry : entries.entrySet()) {
                    String entryName = Zipper.normalizeAndValidateEntryName(entry.getKey());
                    if (entryName.endsWith("/")) {
                        ZipEntry e = new ZipEntry(entryName);
                        e.setMethod(0);
                        e.setSize(0L);
                        e.setCrc(0L);
                        zos.putNextEntry(e);
                        zos.closeEntry();
                        continue;
                    }
                    if (entry.getValue() == null) continue;
                    byte[] entryBytes = Zipper.slurpBytes(entry.getValue());
                    ZipEntry e = new ZipEntry(entryName);
                    e.setMethod(8);
                    zos.putNextEntry(e);
                    zos.write(entryBytes);
                    zos.closeEntry();
                }
                zos.finish();
                zos.flush();
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void zipAppend(File zipFile, Map<String, Object> entries) {
        if (zipFile == null) {
            throw new IllegalArgumentException("A 'zipFile' must not be null");
        }
        if (entries == null) {
            throw new IllegalArgumentException("An 'entries' map must not be null");
        }
        try {
            Path zipPath = zipFile.toPath();
            try (FileSystem fs = FileSystems.newFileSystem(zipPath, (ClassLoader)null);){
                for (Map.Entry<String, Object> entry : entries.entrySet()) {
                    Path nf;
                    String entryName = Zipper.normalizeAndValidateEntryName(entry.getKey());
                    if (entry.getValue() == null) continue;
                    byte[] entryBytes = Zipper.slurpBytes(entry.getValue());
                    if (entryName.endsWith("/")) {
                        nf = fs.getPath(entryName, new String[0]);
                        if (!Files.notExists(nf, new LinkOption[0])) continue;
                        Files.createDirectories(nf, new FileAttribute[0]);
                        continue;
                    }
                    nf = fs.getPath(entryName, new String[0]);
                    Path dir = nf.getParent();
                    if (dir != null && Files.notExists(dir, new LinkOption[0])) {
                        Files.createDirectories(dir, new FileAttribute[0]);
                    }
                    Files.deleteIfExists(nf);
                    OutputStream os = Files.newOutputStream(nf, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        os.write(entryBytes);
                        os.flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (os == null) continue;
                        if (throwable != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        os.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void zipRemove(File zipFile, List<String> entryNames) {
        if (zipFile == null) {
            throw new IllegalArgumentException("A 'zipFile' must not be null");
        }
        if (entryNames == null || entryNames.isEmpty()) {
            return;
        }
        try {
            Path zipPath = zipFile.toPath();
            try (FileSystem fs = FileSystems.newFileSystem(zipPath, (ClassLoader)null);){
                for (String entryName : entryNames) {
                    Path nf = fs.getPath(entryName, new String[0]);
                    if (entryName.endsWith("/")) {
                        if (!Files.isDirectory(nf, new LinkOption[0])) continue;
                        try {
                            List<Path> tree = Files.walk(nf, new FileVisitOption[0]).collect(Collectors.toList());
                            Collections.reverse(tree);
                            tree.forEach(p -> Zipper.deletePath(p));
                            continue;
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex.getMessage(), ex);
                        }
                    }
                    if (!Files.isRegularFile(nf, new LinkOption[0])) continue;
                    Files.deleteIfExists(nf);
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzip(File zipFile, String entryName) {
        if (zipFile == null) {
            throw new IllegalArgumentException("A 'zipFile' must not be null");
        }
        if (StringUtil.isEmpty(entryName)) {
            throw new IllegalArgumentException("A 'entryName' must not be null or empty");
        }
        try (FileInputStream is = new FileInputStream(zipFile);){
            byte[] byArray = Zipper.unzip(is, entryName);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzip(byte[] zipFileBinary, String entryName) {
        if (zipFileBinary == null) {
            throw new IllegalArgumentException("A 'zipFileBinary' must not be null");
        }
        if (StringUtil.isEmpty(entryName)) {
            throw new IllegalArgumentException("A 'entryName' must not be null or empty");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(zipFileBinary);){
            byte[] byArray = Zipper.unzip(is, entryName);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzip(InputStream zipFileIS, String entryName) {
        if (zipFileIS == null) {
            throw new IllegalArgumentException("A 'zipFileIS' must not be null");
        }
        String name = Zipper.normalizeAndValidateEntryName(entryName);
        try (ZipInputStream zis = zipFileIS instanceof ZipInputStream ? (ZipInputStream)zipFileIS : new ZipInputStream(zipFileIS);){
            byte[] data;
            ZipEntry entry;
            do {
                if ((entry = zis.getNextEntry()) == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                Zipper.validatedEntryNameForUnzip(entry);
                data = Zipper.slurpBytes(zis);
                zis.closeEntry();
            } while (!name.equals(entry.getName()));
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzipNthEntry(File zipFile, int nth) {
        if (zipFile == null) {
            throw new IllegalArgumentException("A 'zipFile' must not be null");
        }
        try (FileInputStream is = new FileInputStream(zipFile);){
            byte[] byArray = Zipper.unzipNthEntry(is, nth);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzipNthEntry(byte[] zipFileBinary, int nth) {
        if (zipFileBinary == null) {
            throw new IllegalArgumentException("A 'zipFileBinary' must not be null");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(zipFileBinary);){
            byte[] byArray = Zipper.unzipNthEntry(is, nth);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzipNthEntry(InputStream zipFileIS, int nth) {
        if (zipFileIS == null) {
            throw new IllegalArgumentException("A 'zipFileIS' must not be null");
        }
        try (ZipInputStream zis = zipFileIS instanceof ZipInputStream ? (ZipInputStream)zipFileIS : new ZipInputStream(zipFileIS);){
            int entryIdx = 0;
            while (true) {
                ZipEntry entry;
                if ((entry = zis.getNextEntry()) == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] data = Zipper.slurpBytes(zis);
                if (entryIdx == nth) {
                    Zipper.validatedEntryNameForUnzip(entry);
                    byte[] byArray = data;
                    return byArray;
                }
                zis.closeEntry();
                ++entryIdx;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputStream unzipToStream(byte[] zipFileBinary, String entryName) {
        if (zipFileBinary == null) {
            throw new IllegalArgumentException("A 'zipFileBinary' must not be null");
        }
        if (StringUtil.isEmpty(entryName)) {
            throw new IllegalArgumentException("A 'entryName' must not be null or empty");
        }
        String name = Zipper.normalizeAndValidateEntryName(entryName);
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zipFileBinary));){
            while (true) {
                ZipEntry entry;
                if ((entry = zis.getNextEntry()) == null) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                if (name.equals(entry.getName())) {
                    Zipper.validatedEntryNameForUnzip(entry);
                    ZipInputStream zipInputStream = zis;
                    return zipInputStream;
                }
                zis.closeEntry();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static InputStream unzipFirstToStream(byte[] zipFileBinary) {
        if (zipFileBinary == null) {
            throw new IllegalArgumentException("A 'zipFileBinary' must not be null");
        }
        return Zipper.unzipFirstToStream(new ByteArrayInputStream(zipFileBinary));
    }

    public static InputStream unzipFirstToStream(InputStream zipFileIS) {
        if (zipFileIS == null) {
            throw new IllegalArgumentException("An 'zipFileIS' must not be null");
        }
        try {
            ZipEntry entry;
            ZipInputStream zis;
            ZipInputStream zipInputStream = zis = zipFileIS instanceof ZipInputStream ? (ZipInputStream)zipFileIS : new ZipInputStream(zipFileIS);
            while ((entry = zis.getNextEntry()) != null) {
                Zipper.validatedEntryNameForUnzip(entry);
                if (entry.isDirectory()) continue;
                return zis;
            }
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, byte[]> unzipAll(File zipFile, PathMatcher matcher) {
        if (zipFile == null) {
            throw new IllegalArgumentException("A 'zipFile' must not be null");
        }
        try (FileInputStream is = new FileInputStream(zipFile);){
            Map<String, byte[]> map = Zipper.unzipAll(is, matcher);
            return map;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, byte[]> unzipAll(byte[] zipFileBinary, PathMatcher matcher) {
        if (zipFileBinary == null) {
            throw new IllegalArgumentException("A 'zipFileBinary' must not be null");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(zipFileBinary);){
            Map<String, byte[]> map = Zipper.unzipAll(is, matcher);
            return map;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, byte[]> unzipAll(InputStream zipFileIS, PathMatcher matcher) {
        if (zipFileIS == null) {
            throw new IllegalArgumentException("A 'zipFileIS' must not be null");
        }
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        try (ZipInputStream zis = zipFileIS instanceof ZipInputStream ? (ZipInputStream)zipFileIS : new ZipInputStream(zipFileIS);){
            while (true) {
                ZipEntry entry;
                if ((entry = zis.getNextEntry()) == null) {
                    HashMap<String, byte[]> hashMap = files;
                    return hashMap;
                }
                Zipper.validatedEntryNameForUnzip(entry);
                byte[] data = Zipper.slurpBytes(zis);
                if (matcher == null) {
                    files.put(entry.getName(), entry.isDirectory() ? null : data);
                } else if (!entry.isDirectory() && matcher.matches(new File(entry.getName()).toPath())) {
                    files.put(entry.getName(), data);
                }
                zis.closeEntry();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void zipFileOrDir(File zip, List<File> sourceFileOrDirs, FilenameFilter filter, Function<File, InputStream> mapper, PrintStream ps) {
        if (zip == null) {
            throw new IllegalArgumentException("A 'zip' must not be null");
        }
        if (sourceFileOrDirs == null || sourceFileOrDirs.isEmpty()) {
            throw new IllegalArgumentException("A 'sourceFileOrDirs' must not be null or empty");
        }
        try (FileOutputStream fos = new FileOutputStream(zip);){
            Zipper.zipFileOrDir(fos, sourceFileOrDirs, filter, mapper, ps);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void zipFileOrDir(OutputStream os, List<File> sourceFileOrDirs, FilenameFilter filter, Function<File, InputStream> mapper, PrintStream ps) {
        if (os == null) {
            throw new IllegalArgumentException("An 'os' must not be null");
        }
        if (sourceFileOrDirs == null || sourceFileOrDirs.isEmpty()) {
            throw new IllegalArgumentException("A 'sourceFileOrDirs' must not be null or empty");
        }
        try (ZipOutputStream zipOut = new ZipOutputStream(os);){
            ps.println("Output:");
            for (File f : sourceFileOrDirs) {
                if (f.isDirectory()) {
                    Zipper.zipFile(f, f.getName(), filter, mapper, ps, zipOut);
                    continue;
                }
                if (!f.isFile()) continue;
                Zipper.zipFile(f, f.getName(), filter, mapper, ps, zipOut);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ZipEntryAttr> listZip(byte[] binary, ZipEntryAttrPrinter printer) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(binary);){
            List<ZipEntryAttr> list = Zipper.listZip(is, printer);
            return list;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ZipEntryAttr> listZip(File zip, ZipEntryAttrPrinter printer) {
        if (zip == null) {
            throw new IllegalArgumentException("A 'zip' must not be null");
        }
        try (FileInputStream fis = new FileInputStream(zip);){
            List<ZipEntryAttr> list = Zipper.listZip(fis, printer);
            return list;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static List<ZipEntryAttr> listZip(InputStream is, ZipEntryAttrPrinter printer) {
        if (is == null) {
            throw new IllegalArgumentException("An 'is' must not be null");
        }
        ArrayList<ZipEntryAttr> entryAttrs = new ArrayList<ZipEntryAttr>();
        try {
            ZipEntry entry;
            printer.start();
            ZipInputStream zis = new ZipInputStream(is);
            while ((entry = zis.getNextEntry()) != null) {
                zis.closeEntry();
                ZipEntryAttr entryAttr = new ZipEntryAttr(entry.getName(), entry.isDirectory(), entry.getMethod() == 0 ? "Stored" : "Defl:N", entry.isDirectory() ? 0L : entry.getSize(), entry.isDirectory() ? 0L : entry.getCompressedSize(), entry.getLastModifiedTime(), entry.getCrc());
                entryAttrs.add(entryAttr);
                printer.print(entryAttr);
            }
            zis.close();
            printer.end();
            return entryAttrs;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void unzipToDir(File zip, File destDir) {
        if (zip == null) {
            throw new IllegalArgumentException("A 'zip' must not be null");
        }
        if (destDir == null) {
            throw new IllegalArgumentException("A 'dir' must not be null");
        }
        try (FileInputStream fis = new FileInputStream(zip);){
            Zipper.unzipToDir(fis, destDir);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void unzipToDir(byte[] zipBinary, File destDir) {
        if (zipBinary == null) {
            throw new IllegalArgumentException("A 'zipBinary' must not be null");
        }
        if (destDir == null) {
            throw new IllegalArgumentException("A 'dir' must not be null");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(zipBinary);){
            Zipper.unzipToDir(is, destDir);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void unzipToDir(InputStream zipIS, File destDir) {
        if (zipIS == null) {
            throw new IllegalArgumentException("A 'zipIS' must not be null");
        }
        if (destDir == null) {
            throw new IllegalArgumentException("A 'dir' must not be null");
        }
        try {
            ZipInputStream zis = new ZipInputStream(zipIS);
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File f = Zipper.zipValidatedExtractDestFile(destDir, zipEntry);
                if (zipEntry.isDirectory()) {
                    f.mkdirs();
                } else {
                    f.getParentFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(f);){
                        IOStreamUtil.copy(zis, fos);
                    }
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static byte[] getZipEntryData(ZipInputStream zipInputStream) {
        if (zipInputStream == null) {
            throw new IllegalArgumentException("A 'zipInputStream' must not be null");
        }
        try {
            return Zipper.slurpBytes(zipInputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZipFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A 'file' must not be null");
        }
        try (FileInputStream is = new FileInputStream(file);){
            boolean bl = Zipper.isZipFile(is);
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static boolean isZipFile(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("An 'is' must not be null");
        }
        try {
            is.mark(4);
            byte[] bytes = IOStreamUtil.copyIStoByteArray(is, 4);
            is.reset();
            return Zipper.isZipFile(bytes);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static boolean isZipFile(byte[] bytes) {
        if (bytes == null || bytes.length < 4) {
            return false;
        }
        return ByteBuffer.wrap(bytes).getInt() == 1347093252;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> listZipEntryNames(File zip) {
        if (zip == null) {
            throw new IllegalArgumentException("A 'zip' must not be null");
        }
        try (FileInputStream is = new FileInputStream(zip);){
            List<String> list = Zipper.listZipEntryNames(is);
            return list;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> listZipEntryNames(byte[] binary) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(binary);){
            List<String> list = Zipper.listZipEntryNames(is);
            return list;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> listZipEntryNames(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("A 'is' must not be null");
        }
        ArrayList<String> entries = new ArrayList<String>();
        try (ZipInputStream zis = new ZipInputStream(is);){
            while (true) {
                ZipEntry entry;
                if ((entry = zis.getNextEntry()) == null) {
                    ArrayList<String> arrayList = entries;
                    return arrayList;
                }
                entries.add(entry.getName());
                zis.closeEntry();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static void zipFile(File fileToZip, String fileName, FilenameFilter filter, Function<File, InputStream> mapper, PrintStream ps, ZipOutputStream zipOut) throws IOException {
        Path path = fileToZip.toPath();
        if (Files.isHidden(path) || Files.isSymbolicLink(path)) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            String name = fileName.endsWith("/") ? fileName : fileName + "/";
            ps.println("  adding: " + name);
            ZipEntry e = new ZipEntry(name);
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
            zipOut.putNextEntry(e);
            zipOut.closeEntry();
            for (File childFile : children = fileToZip.listFiles()) {
                Zipper.zipFile(childFile, name + childFile.getName(), filter, mapper, ps, zipOut);
            }
        } else if (fileToZip.isFile() && (filter == null || filter.accept(fileToZip.getParentFile(), fileToZip.getName()))) {
            InputStream is = mapper == null ? null : mapper.apply(fileToZip);
            ps.println("  adding: " + fileName + (is == null ? "" : "  (mapped)"));
            try (InputStream is_ = is = is == null ? new FileInputStream(fileToZip) : is;){
                ZipEntry zipEntry = new ZipEntry(fileName);
                zipEntry.setMethod(8);
                zipOut.putNextEntry(zipEntry);
                IOStreamUtil.copy(is_, zipOut);
                zipOut.closeEntry();
            }
        }
    }

    private static File zipValidatedExtractDestFile(File destDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destDir, zipEntry.getName());
        if (!destFile.getCanonicalFile().toPath().startsWith(destDir.getCanonicalFile().toPath())) {
            throw new IOException(String.format("ZIP entry '%s' slips target dir %s while unzipping it!", zipEntry.getName(), destDir.getPath()));
        }
        return destFile;
    }

    private static void validatedEntryNameForUnzip(ZipEntry zipEntry) throws IOException {
        File destDir = new File(".");
        File destFile = new File(destDir, zipEntry.getName());
        if (!destFile.getCanonicalFile().toPath().startsWith(destDir.getCanonicalFile().toPath())) {
            throw new IOException(String.format("ZIP entry '%s' slips a potential target dir!", zipEntry.getName()));
        }
    }

    private static String normalizeAndValidateEntryName(String entryName) {
        if (StringUtil.isEmpty(entryName)) {
            throw new IllegalArgumentException("A 'entryName' must not be null or empty");
        }
        if ("/".equals(entryName)) {
            throw new IllegalArgumentException("A 'entryName' must not be \"/\"");
        }
        return entryName.startsWith("/") ? entryName.substring(1) : entryName;
    }

    private static byte[] slurpBytes(Object source) throws IOException {
        if (source == null) {
            return new byte[0];
        }
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        if (source instanceof InputStream) {
            return IOStreamUtil.copyIStoByteArray((InputStream)source);
        }
        if (source instanceof File) {
            try (FileInputStream fis = new FileInputStream((File)source);){
                byte[] byArray = IOStreamUtil.copyIStoByteArray(fis);
                return byArray;
            }
        }
        throw new IllegalArgumentException("Only entry values of type byte[], File or InputStream are supported!");
    }

    private static void deletePath(Path p) {
        try {
            Files.delete(p);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

