/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.AppRunner;
import com.github.jlangch.venice.impl.IVeniceInterpreter;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.functions.SystemFunctions;
import com.github.jlangch.venice.impl.repl.CustomREPL;
import com.github.jlangch.venice.impl.repl.REPL;
import com.github.jlangch.venice.impl.repl.ReplInstaller;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.impl.util.io.FileUtil;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import com.github.jlangch.venice.javainterop.LoadPathsFactory;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

public class Launcher {
    public static void main(String[] args) {
        CommandLineArgs cli = new CommandLineArgs(args);
        ILoadPaths loadPaths = LoadPathsFactory.parseDelimitedLoadPath(cli.switchValue("-loadpath"), true);
        boolean macroexpand = Launcher.isMacroexpand(cli);
        try {
            if (cli.switchPresent("-help")) {
                Launcher.printHelp();
            } else if (cli.switchPresent("-setup")) {
                if (!ReplInstaller.install(args)) {
                    System.exit(99);
                }
            } else if (cli.switchPresent("-file")) {
                AcceptAllInterceptor interceptor = new AcceptAllInterceptor(loadPaths);
                String file = Launcher.suffixWithVeniceFileExt(cli.switchValue("-file"));
                String script = new String(FileUtil.load(new File(file)));
                String scriptWrapped = "(do " + script + ")";
                System.out.println(Launcher.runScript(cli.removeSwitch("-file").removeSwitch("-macroexpand").removeSwitch("-loadpath"), macroexpand, interceptor, scriptWrapped, new File(file).getName()));
            } else if (cli.switchPresent("-cp-file")) {
                AcceptAllInterceptor interceptor = new AcceptAllInterceptor(loadPaths);
                String file = Launcher.suffixWithVeniceFileExt(cli.switchValue("-cp-file"));
                String script = new ClassPathResource(file).getResourceAsString();
                System.out.println(Launcher.runScript(cli.removeSwitch("-cp-file").removeSwitch("-macroexpand").removeSwitch("-loadpath"), macroexpand, interceptor, script, new File(file).getName()));
            } else if (cli.switchPresent("-script")) {
                AcceptAllInterceptor interceptor = new AcceptAllInterceptor(loadPaths);
                String script = cli.switchValue("-script");
                System.out.println(Launcher.runScript(cli.removeSwitch("-script").removeSwitch("-macroexpand").removeSwitch("-loadpath"), macroexpand, interceptor, script, "script"));
            } else if (cli.switchPresent("-app")) {
                System.out.println("Launching Venice application ...");
                File appFile = new File(Launcher.suffixWithZipFileExt(cli.switchValue("-app")));
                AppRunner.run(appFile, cli.removeSwitch("-app").removeSwitch("-macroexpand").removeSwitch("-loadpath").argsAsList(), loadPaths, new PrintStream(System.out, true), new PrintStream(System.err, true), new InputStreamReader(System.in));
            } else if (cli.switchPresent("-app-repl")) {
                AcceptAllInterceptor interceptor = new AcceptAllInterceptor(loadPaths);
                String file = cli.switchValue("-app-repl");
                new CustomREPL(interceptor, new File(file)).run(args);
            } else {
                new REPL(new AcceptAllInterceptor(loadPaths)).run(args);
            }
            System.exit(SystemFunctions.SYSTEM_EXIT_CODE.get());
        }
        catch (VncException ex) {
            ex.printVeniceStackTrace();
            System.exit(99);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(99);
        }
    }

    private static void printHelp() {
        System.out.println("The Launcher runs Venice scripts or apps and starts the REPL. \n\nThe launcher is configured as the Venice JAR's main-class. \n\nRunning scripts: \n    java -jar venice-1.12.29.jar -script \"(+ 1 1)\" \n\nRunning a REPL:  \n    java \\ \n       -server \\ \n       -Xmx6G \\ \n       -XX:-OmitStackTraceInFastThrow \\ \n       -cp \"libs/*\" \\ \n       com.github.jlangch.venice.Launcher \\ \n       -repl \\ \n       -colors \n\n\nLauncher command line options: \n  -loadpath path     defines a load path \n                     E.g.: -loadpath \"/users/foo/scripts;/users/foo/res\" \n\n  -macroexpand true  turns up-front macro expansion on, resulting in a \n                     much better performance \n\n  -file script       loads the script to run from a file \n                     E.g.:  -file ./test.venice \n\n  -cp-file res       loads the script to run from the classpath \n                     E.g.:  -cp-file com/github/jlangch/venice/test.venice \n\n  -script script     run a script \n                     E.g.:  -script \"(+ 1 10)\" \n\n  -app app           run a Venice app  \n                     E.g.:  -app test-app.zip \n\n  -repl              start a REPL \n                     E.g.:  -repl \n\n  -setup             setup a REPL \n                     E.g.:  java -jar venice-1.12.29.jar -setup -colors \n                            java -jar venice-1.12.29.jar -setup -colors-light \n                            java -jar venice-1.12.29.jar -setup -colors-dark \n                            java -jar venice-1.12.29.jar -setup -colors -dir /Users/foo/repl \n\n  -help              prints a help \n\nNote: \n  The options '-file', '-cp-file', '-script', '-app', '-repl', and '-setup' exclude \n  each other \n");
    }

    private static String runScript(CommandLineArgs cli, boolean macroexpand, IInterceptor interceptor, String script, String name) {
        VeniceInterpreter venice = new VeniceInterpreter(interceptor);
        Env env = Launcher.createEnv(venice, macroexpand, RunMode.SCRIPT, Arrays.asList(Launcher.convertCliArgsToVar(cli)));
        return venice.PRINT(venice.RE(script, name, env));
    }

    private static Env createEnv(IVeniceInterpreter venice, boolean macroexpand, RunMode runMode, List<Var> vars) {
        return venice.createEnv(macroexpand, false, runMode).addGlobalVars(vars).setStdoutPrintStream(new PrintStream(System.out, true)).setStderrPrintStream(new PrintStream(System.err, true)).setStdinReader(new InputStreamReader(System.in));
    }

    private static boolean isMacroexpand(CommandLineArgs cli) {
        if (cli.switchPresent("-macroexpand")) {
            String value = cli.switchValue("-macroexpand");
            return "true".equals(value.toLowerCase());
        }
        return true;
    }

    private static Var convertCliArgsToVar(CommandLineArgs cli) {
        return new Var(new VncSymbol("*ARGV*"), cli.argsAsList(), false, Var.Scope.Global);
    }

    private static String suffixWithVeniceFileExt(String s) {
        return s == null ? null : (s.endsWith(".venice") ? s : s + ".venice");
    }

    private static String suffixWithZipFileExt(String s) {
        return s == null ? null : (s.endsWith(".zip") ? s : s + ".zip");
    }
}

