/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncVal;

public class ValueException
extends VncException {
    private static final long serialVersionUID = -7070216020647646364L;
    private final Object value;
    private final String type;

    public ValueException(Object value) {
        super("");
        this.value = value;
        this.type = ValueException.type(value);
    }

    public ValueException(Object value, Throwable cause) {
        super("", cause);
        this.value = value;
        this.type = ValueException.type(value);
    }

    public Object getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String toString() {
        String s = this.getClass().getName();
        return this.value == null ? s + ": null" : s + ": (" + this.type + ") " + ValueException.format(this.value);
    }

    private static String format(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof VncVal) {
            return ((VncVal)value).toString(true);
        }
        return value.toString();
    }

    private static String type(Object value) {
        if (value == null) {
            return Constants.Nil.getType().toString();
        }
        if (value instanceof VncVal) {
            return ((VncVal)value).getType().toString();
        }
        return ":" + value.getClass().getName();
    }
}

