/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.debug.agent;

import com.github.jlangch.venice.impl.debug.breakpoint.BreakpointFnRef;
import com.github.jlangch.venice.impl.debug.breakpoint.FunctionScope;
import com.github.jlangch.venice.impl.debug.util.SpecialFormVirtualFunction;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.CollectionUtil;
import com.github.jlangch.venice.impl.util.SourcePos;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.callstack.CallStack;
import java.util.UUID;

public class Break {
    public static int FORMAT_PAD_LEN = 14;
    private final String id = UUID.randomUUID().toString();
    private final BreakpointFnRef breakpoint;
    private final VncFunction fn;
    private final VncList args;
    private final VncVal retVal;
    private final Exception ex;
    private final Env env;
    private final CallStack callStack;
    private final FunctionScope scope;
    private final String threadName;

    public Break(BreakpointFnRef breakpoint, VncFunction fn, VncList args, Env env, CallStack callStack, FunctionScope scope, String threadName) {
        this(breakpoint, fn, args, null, null, env, callStack, scope, threadName);
    }

    public Break(BreakpointFnRef breakpoint, VncFunction fn, VncList args, VncVal retVal, Exception ex, Env env, CallStack callStack, FunctionScope scope, String threadName) {
        this.breakpoint = breakpoint;
        this.fn = fn;
        this.args = args;
        this.retVal = retVal;
        this.ex = ex;
        this.env = env;
        this.callStack = callStack;
        this.scope = scope;
        this.threadName = threadName;
    }

    public BreakpointFnRef getBreakpoint() {
        return this.breakpoint;
    }

    public VncFunction getFn() {
        return this.fn;
    }

    public VncList getArgs() {
        return this.args;
    }

    public VncVal getRetVal() {
        return this.retVal;
    }

    public Exception getException() {
        return this.ex;
    }

    public Env getEnv() {
        return this.env;
    }

    public CallStack getCallStack() {
        return this.callStack;
    }

    public FunctionScope getBreakpointScope() {
        return this.scope;
    }

    public boolean isInScope(FunctionScope ... scopes) {
        return CollectionUtil.toList(scopes).contains((Object)this.scope);
    }

    public boolean isBreakInSpecialForm() {
        return this.fn instanceof SpecialFormVirtualFunction;
    }

    public boolean isBreakInNativeFn() {
        return this.fn.isNative();
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getBreakFnInfo(boolean pad) {
        int padLen;
        int n = padLen = pad ? FORMAT_PAD_LEN : 0;
        if (this.isBreakInSpecialForm()) {
            return String.format("%s %s", StringUtil.padRight("Special Form:", padLen), this.fn.getQualifiedName());
        }
        if (this.fn.isMacro()) {
            SourcePos pos = SourcePos.fromVal(this.fn);
            return String.format("%s %s defined in %s at line %d", StringUtil.padRight("Macro:", padLen), this.fn.getQualifiedName(), pos.getFile(), pos.getLine());
        }
        if (this.fn.isNative()) {
            return String.format("%s %s (native, no source line info)", StringUtil.padRight("Function:", padLen), this.fn.getQualifiedName());
        }
        SourcePos pos = SourcePos.fromVal(this.fn);
        return String.format("%s %s defined in %s at line %d", StringUtil.padRight("Function:", padLen), this.fn.getQualifiedName(), pos.getFile(), pos.getLine());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s %s", StringUtil.padRight("Breakpoint:", FORMAT_PAD_LEN), this.breakpoint.toString()));
        sb.append("\n");
        sb.append(this.getBreakFnInfo(true));
        sb.append("\n");
        sb.append(String.format("%s %s", new Object[]{StringUtil.padRight("Scope:", FORMAT_PAD_LEN), this.scope}));
        sb.append("\n");
        sb.append(String.format("%s %s", StringUtil.padRight("Thread:", FORMAT_PAD_LEN), this.threadName));
        sb.append("\n");
        sb.append(String.format("%s %d frames", StringUtil.padRight("Callstack:", FORMAT_PAD_LEN), this.getCallStack().size()));
        return sb.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Break other = (Break)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

