/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.repl.ReplConfig;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.repackage.org.jline.utils.OSUtils;

public class ReplInstaller {
    public static boolean install(String[] args) {
        try {
            AcceptAllInterceptor interceptor = new AcceptAllInterceptor();
            ThreadContext.setInterceptor(interceptor);
            System.out.println("Venice REPL setup...");
            System.out.println("Venice REPL: V" + Venice.getVersion());
            System.out.println("Java: " + System.getProperty("java.version"));
            CommandLineArgs cli = new CommandLineArgs(args);
            ReplConfig config = ReplConfig.load(cli);
            File installDir = new File(cli.switchValue("-dir", "."));
            installDir = Files.createDirectories(installDir.toPath(), new FileAttribute[0]).toFile().getCanonicalFile();
            VeniceInterpreter venice = new VeniceInterpreter(interceptor);
            Env env = venice.createEnv(false, false, RunMode.SCRIPT).setGlobal(new Var(new VncSymbol("*ARGV*"), VncList.empty(), false, Var.Scope.Global)).setStdoutPrintStream(System.out).setStderrPrintStream(System.err).setStdinReader(null);
            ReplConfig.ColorMode colorMode = config.isColorModeLight() && OSUtils.IS_WINDOWS ? ReplConfig.ColorMode.Dark : config.getColorMode();
            String script = String.format("(do                                        \n  (load-module :repl-setup)                \n  (repl-setup/setup :color-mode :%s        \n                    :ansi-terminal false   \n                    :install-dir \"%s\"))  ", colorMode.name().toLowerCase(), installDir.getAbsolutePath());
            venice.RE(script, "setup", env);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.err.println();
            System.err.println("REPL setup failed!");
            return false;
        }
    }
}

