/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.concurrent.ConcurrentHashMap;

public class Watchable {
    private final ConcurrentHashMap<VncKeyword, VncFunction> watches = new ConcurrentHashMap();

    public void addWatch(VncKeyword name, VncFunction fn) {
        this.watches.put(name, fn);
    }

    public void removeWatch(VncKeyword name) {
        this.watches.remove(name);
    }

    public void notifyWatches(VncVal ref, VncVal oldVal, VncVal newVal) {
        this.watches.entrySet().forEach(e -> {
            try {
                ((VncFunction)e.getValue()).apply(VncList.of((VncVal)e.getKey(), ref, oldVal, newVal));
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new VncException("Watcher failure!", ex);
            }
        });
    }
}

