/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.excel;

import com.github.jlangch.venice.impl.util.excel.Excel;
import com.github.jlangch.venice.util.excel.ExcelCellStyleBuilder;
import com.github.jlangch.venice.util.excel.ExcelFontBuilder;
import com.github.jlangch.venice.util.excel.ExcelReader;
import com.github.jlangch.venice.util.excel.ExcelSheetWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ExcelWriter {
    private final Excel excel;

    public ExcelWriter(Excel excel) {
        this.excel = excel;
    }

    public static ExcelWriter open(byte[] document) {
        return new ExcelWriter(Excel.open(new ByteArrayInputStream(document)));
    }

    public static ExcelWriter open(ByteBuffer document) {
        return new ExcelWriter(Excel.open(new ByteArrayInputStream(document.array())));
    }

    public static ExcelWriter open(File file) {
        return new ExcelWriter(Excel.open(file));
    }

    public static ExcelWriter open(InputStream is) {
        return new ExcelWriter(Excel.open(is));
    }

    public static ExcelWriter createXls() {
        return new ExcelWriter(Excel.createXls());
    }

    public static ExcelWriter createXlsx() {
        return new ExcelWriter(Excel.createXlsx());
    }

    public int getNumberOfSheets() {
        return this.excel.getNumberOfSheets();
    }

    public void evaluateAllFormulas() {
        this.excel.evaluateAllFormulas();
    }

    public ExcelFontBuilder withFont(String name) {
        return new ExcelFontBuilder(this, this.excel, name);
    }

    public ExcelCellStyleBuilder withCellStyle(String name) {
        return new ExcelCellStyleBuilder(this, this.excel, name);
    }

    public <T> ExcelSheetWriter<T> withSheet(String name, Class<T> type) {
        return new ExcelSheetWriter(this, this.excel.createSheet(name));
    }

    public void write(File file) {
        this.excel.write(file);
    }

    public void write(OutputStream outputStream) {
        this.excel.write(outputStream);
    }

    public byte[] writeToBytes() {
        return this.excel.writeToBytes();
    }

    public ExcelReader reader() {
        this.excel.close();
        return new ExcelReader(this.excel);
    }

    public ExcelWriter end() {
        this.excel.close();
        return this;
    }

    public <T> ExcelSheetWriter<T> getSheet(String name) {
        return new ExcelSheetWriter(this, this.excel.getSheet(name));
    }

    public <T> ExcelSheetWriter<T> getSheetAt(int sheetIdx) {
        return new ExcelSheetWriter(this, this.excel.getSheetAt(sheetIdx - 1));
    }

    public Excel toExcel() {
        return this.excel;
    }
}

