/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.IRepl;
import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.LicenseMgr;
import com.github.jlangch.venice.ParseError;
import com.github.jlangch.venice.SourceCodeRenderer;
import com.github.jlangch.venice.SymbolNotFoundException;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.IVeniceInterpreter;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.debug.agent.DebugAgent;
import com.github.jlangch.venice.impl.docgen.runtime.DocForm;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.EnvUtils;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.functions.JsonFunctions;
import com.github.jlangch.venice.impl.functions.SystemFunctions;
import com.github.jlangch.venice.impl.javainterop.DynamicClassLoader2;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.repl.NullExpander;
import com.github.jlangch.venice.impl.repl.ReplCompleter;
import com.github.jlangch.venice.impl.repl.ReplConfig;
import com.github.jlangch.venice.impl.repl.ReplDebugClient;
import com.github.jlangch.venice.impl.repl.ReplDirs;
import com.github.jlangch.venice.impl.repl.ReplFunctions;
import com.github.jlangch.venice.impl.repl.ReplHelp;
import com.github.jlangch.venice.impl.repl.ReplHighlighter;
import com.github.jlangch.venice.impl.repl.ReplJLineLogHandler;
import com.github.jlangch.venice.impl.repl.ReplParser;
import com.github.jlangch.venice.impl.repl.ReplPrintStream;
import com.github.jlangch.venice.impl.repl.ReplRestart;
import com.github.jlangch.venice.impl.repl.ReplResultHistory;
import com.github.jlangch.venice.impl.repl.ScriptExecuter;
import com.github.jlangch.venice.impl.repl.TerminalPrinter;
import com.github.jlangch.venice.impl.sandbox.SandboxFunctionGroups;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.CollectionUtil;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.CharsetUtil;
import com.github.jlangch.venice.impl.util.io.zip.ZipFileSystemUtil;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import com.github.jlangch.venice.javainterop.LoadPathsFactory;
import com.github.jlangch.venice.javainterop.RejectAllInterceptor;
import com.github.jlangch.venice.javainterop.SandboxInterceptor;
import com.github.jlangch.venice.javainterop.SandboxRules;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.repackage.org.jline.reader.History;
import org.repackage.org.jline.reader.LineReader;
import org.repackage.org.jline.reader.LineReaderBuilder;
import org.repackage.org.jline.reader.MaskingCallback;
import org.repackage.org.jline.reader.UserInterruptException;
import org.repackage.org.jline.reader.impl.history.DefaultHistory;
import org.repackage.org.jline.terminal.Size;
import org.repackage.org.jline.terminal.Terminal;
import org.repackage.org.jline.terminal.TerminalBuilder;
import org.repackage.org.jline.utils.InfoCmp;
import org.repackage.org.jline.utils.OSUtils;

public class REPL
implements IRepl {
    private static final String HISTORY_FILE = ".repl.history";
    private final Semaphore semaphore = new Semaphore(1);
    private Terminal terminal;
    private ReplConfig config;
    private IInterceptor interceptor;
    private volatile IVeniceInterpreter venice;
    private Env env;
    private TerminalPrinter printer;
    private ReplHighlighter highlighter;
    private boolean ansiTerminal = false;
    private boolean highlight = true;
    private boolean javaExceptions = false;
    private boolean restartable = false;
    private String promptVenice;
    private String promptDebug;
    private String prompt;
    private String secondaryPrompt;
    private String resultPrefix = "=> ";
    private ReplDebugClient debugClient = null;
    private ReplDirs replDirs;
    private final ScriptExecuter scriptExec = new ScriptExecuter();

    public REPL(IInterceptor interceptor) {
        this.interceptor = interceptor == null ? new AcceptAllInterceptor() : interceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        if (!this.semaphore.tryAcquire()) {
            throw new VncException("The REPL is already running!");
        }
        try {
            ThreadContext.setInterceptor(this.interceptor);
            CommandLineArgs cli = new CommandLineArgs(args);
            ILoadPaths loadpaths = this.interceptor.getLoadPaths();
            boolean macroexpand = false;
            this.config = ReplConfig.load(cli);
            this.initJLineLogger(this.config);
            this.restartable = this.isRestartable(cli);
            this.ansiTerminal = this.isAnsiTerminal(cli, this.config);
            macroexpand = this.isMacroexpand(cli);
            if (ReplRestart.exists()) {
                try {
                    ReplRestart restart = ReplRestart.read();
                    if (!restart.oudated()) {
                        macroexpand |= restart.hasMacroExpand();
                        if (restart.getColorMode() != ReplConfig.ColorMode.None) {
                            this.config.switchColorMode(restart.getColorMode());
                        }
                    }
                }
                finally {
                    ReplRestart.remove();
                }
            }
            String jansiVersion = this.config.getJansiVersion();
            if (OSUtils.IS_WINDOWS && jansiVersion == null) {
                System.out.print("--------------------------------------------------------------------\nThe Venice REPL requires the Jansi library on Windows.              \nPlease download the jar artifact 'org.fusesource.jansi:jansi:2.4.1' \nfrom a Maven repo and put it on the REPL classpath.                 \n                                                                    \n> curl https://repo1.maven.org/maven2/org/fusesource/jansi/jansi/2.4.1/jansi-2.4.1.jar --output jansi-2.4.1.jar \n--------------------------------------------------------------------\n\n");
            }
            System.out.println("Venice REPL: " + Venice.getVersion());
            System.out.println("Home: " + new File(".").getCanonicalPath());
            System.out.println("Java: " + System.getProperty("java.version"));
            System.out.println("Jansi: " + (jansiVersion == null ? "not detected" : jansiVersion));
            System.out.println("Macro expansion: " + (macroexpand ? "enabled" : "disabled"));
            System.out.println("Configuration: " + this.config.getConfigSource());
            if (loadpaths.active()) {
                System.out.print("Load paths: ");
                System.out.println(loadpaths.isUnlimitedAccess() ? "unrestricted > " : "retricted > ");
                loadpaths.getPaths().forEach(p -> System.out.println("   " + p));
            }
            System.out.println(this.getTerminalInfo());
            System.out.println("Type '!' for help.");
            this.replDirs = ReplDirs.create();
            this.repl(cli, macroexpand);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.semaphore.release();
            ThreadContext.remove();
        }
    }

    @Override
    public void setHandler(Consumer<String> handler) {
    }

    @Override
    public void setPrompt(String prompt) {
    }

    @Override
    public void setPrompt(String prompt, String secondaryPrompt) {
    }

    @Override
    public int getTerminalWidth() {
        return this.terminal.getWidth();
    }

    @Override
    public int getTerminalHeight() {
        return this.terminal.getHeight();
    }

    private void repl(CommandLineArgs cli, boolean macroexpand) throws Exception {
        this.promptVenice = this.config.getPrompt();
        this.promptDebug = "debug> ";
        this.resultPrefix = this.config.getResultPrefix();
        this.changePrompt(this.promptVenice);
        Thread mainThread = Thread.currentThread();
        TerminalBuilder builder = TerminalBuilder.builder().streams(System.in, System.out).system(true).dumb(!this.ansiTerminal).jna(false);
        if (OSUtils.IS_WINDOWS) {
            builder.jansi(this.ansiTerminal);
        } else if (this.isRunningOnLinuxGitPod()) {
            builder.encoding("UTF-8");
            builder.type("xterm-256color");
        } else {
            builder.encoding("UTF-8");
        }
        this.terminal = builder.build();
        this.terminal.handle(Terminal.Signal.INT, signal -> mainThread.interrupt());
        PrintStream out = this.createPrintStream("stdout", this.terminal);
        PrintStream err = this.createPrintStream("stderr", this.terminal);
        BufferedReader in = this.createBufferedReader("stdin", this.terminal);
        this.printer = new TerminalPrinter(this.config, this.terminal, this.ansiTerminal, false);
        this.venice = new VeniceInterpreter(this.interceptor);
        this.env = this.loadEnv(this.venice, cli, this.terminal, out, err, in, false);
        this.venice.setMacroExpandOnLoad(macroexpand);
        if (!this.scriptExec.runInitialLoadFile(this.config.getLoadFile(), this.venice, this.env, this.printer, this.resultPrefix)) {
            this.printer.println("error", "Stopped REPL");
            return;
        }
        this.highlighter = this.config.isSyntaxHighlighting() ? new ReplHighlighter(this.config) : null;
        ReplParser parser = new ReplParser(this.venice);
        parser.setEscapeChars(new char[0]);
        DefaultHistory history = new DefaultHistory();
        ReplResultHistory resultHistory = new ReplResultHistory(3);
        ReplCompleter completer = new ReplCompleter(this.venice, this.env, this.interceptor.getLoadPaths().getPaths());
        LineReader reader = this.createLineReader(this.terminal, history, completer, parser, this.secondaryPrompt);
        this.highlight = this.highlighter != null;
        this.replLoop(cli, this.resultPrefix, this.terminal, reader, history, resultHistory, out, err, in);
    }

    private void replLoop(CommandLineArgs cli, String resultPrefix, Terminal terminal, LineReader reader, History history, ReplResultHistory resultHistory, PrintStream out, PrintStream err, BufferedReader in) {
        while (true) {
            ThreadContext.clearCallStack();
            Thread.interrupted();
            resultHistory.mergeToEnv(this.env);
            try {
                String line;
                block39: {
                    try {
                        line = reader.readLine(this.prompt, null, (MaskingCallback)null, null);
                        if (line == null) {
                        }
                        break block39;
                    }
                    catch (ParseError ex) {
                        this.printer.printex("error", ex);
                        history.add(reader.getBuffer().toString());
                    }
                    catch (UserInterruptException ex) {
                        Thread.interrupted();
                    }
                    continue;
                }
                if (ReplParser.isExitCommand(line)) {
                    this.quitREPL(history);
                    return;
                }
                if (DebugAgent.isAttached()) {
                    DebugAgent agent = DebugAgent.current();
                    if (ReplParser.isCommand(line)) {
                        String cmd;
                        switch (cmd = StringUtil.trimToEmpty(line.trim().substring(1))) {
                            case "attach": {
                                this.printer.println("debug", "The debugger is already attached!");
                                break;
                            }
                            case "detach": {
                                this.switchToRegularREPL();
                                break;
                            }
                            case "terminate": {
                                this.scriptExec.cancelAsyncScripts();
                                agent.clearBreaks();
                                break;
                            }
                            default: {
                                this.debugClient.handleCommand(cmd);
                                break;
                            }
                        }
                        continue;
                    }
                    if (ReplParser.isDroppedVeniceScriptFile(line)) {
                        agent.clearBreaks();
                        this.handleDroppedFileName(line, this.env, history, resultHistory, resultPrefix);
                        continue;
                    }
                    if (agent.hasActiveBreak()) {
                        this.runDebuggerExprAsync(line, this.debugClient.getEnv());
                        continue;
                    }
                    this.runScriptAsync(line, resultPrefix, resultHistory);
                    continue;
                }
                if (ReplParser.isCommand(line)) {
                    String cmd;
                    switch (cmd = StringUtil.trimToEmpty(line.trim().substring(1))) {
                        case "reload": {
                            this.env = this.loadEnv(this.venice, cli, terminal, out, err, in, this.venice.isMacroExpandOnLoad());
                            this.printer.println("system", "reloaded");
                            break;
                        }
                        case "restart": {
                            if (this.restartable) {
                                this.printer.println("system", "Restarting REPL...");
                                ReplRestart.restart(this.venice.isMacroExpandOnLoad(), this.config.getColorMode());
                                return;
                            }
                            this.printer.println("error", "This REPL is not restartable!");
                            break;
                        }
                        case "attach": {
                            this.switchToDebugREPL();
                            break;
                        }
                        case "detach": {
                            this.printer.println("error", "There is no debugger attached!");
                            break;
                        }
                        default: {
                            this.handleReplCommand(cmd, this.env, terminal, history);
                            break;
                        }
                    }
                    continue;
                }
                if (ReplParser.isDroppedVeniceScriptFile(line)) {
                    this.handleDroppedFileName(line, this.env, history, resultHistory, resultPrefix);
                    continue;
                }
                this.runScriptSync(line, resultPrefix, resultHistory);
                continue;
            }
            catch (ContinueException cmd) {
                continue;
            }
            catch (Exception ex) {
                this.handleException(ex);
                continue;
            }
            catch (NoClassDefFoundError ex) {
                this.printer.printex("error", ex);
                continue;
            }
            break;
        }
    }

    private void switchToRegularREPL() {
        this.debugClient = null;
        DebugAgent agent = DebugAgent.current();
        if (agent != null) {
            agent.storeBreakpoints();
            agent.detach();
            DebugAgent.unregister();
            this.printer.println("debug", "Debugger: detached");
        } else {
            this.printer.println("error", "Debugger: not attached");
            this.printer.println("debug", "Attach a debuger first using: $attach");
        }
        this.changePrompt(this.promptVenice);
    }

    private void switchToDebugREPL() {
        if (DebugAgent.isAttached()) {
            this.printer.println("debug", "Debugger: already attached");
        } else {
            DebugAgent agent = new DebugAgent();
            DebugAgent.register(agent);
            agent.restoreBreakpoints();
            this.printer.println("debug", "Debugger: attached");
            this.debugClient = new ReplDebugClient(agent, this.printer, Thread.currentThread());
        }
        this.changePrompt(this.promptDebug);
    }

    private void quitREPL(History history) {
        this.clearCommandHistoryIfRequired(history);
        this.printer.println("interrupt", " good bye ");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void runScript(String line, String resultPrefix, ReplResultHistory resultHistory) throws Exception {
        if (this.hasActiveDebugSession()) {
            this.printer.println("error", "Debugging session is active! Can only run debug commands.");
        } else if (DebugAgent.isAttached()) {
            this.runScriptAsync(line, resultPrefix, resultHistory);
        } else {
            this.runScriptSync(line, resultPrefix, resultHistory);
        }
    }

    private void runScriptSync(String script, String resultPrefix, ReplResultHistory resultHistory) throws Exception {
        this.scriptExec.runSync(script, this.venice, this.env, this.printer, resultPrefix, resultHistory, this::handleException);
    }

    private void runScriptAsync(String script, String resultPrefix, ReplResultHistory resultHistory) throws Exception {
        this.scriptExec.runAsync(script, this.venice, this.env, this.printer, resultPrefix, resultHistory, this::handleException);
    }

    private void runDebuggerExprAsync(String expr, Env env) {
        this.scriptExec.runDebuggerExpressionAsync(expr, this.venice, env, this.printer, this::handleException);
    }

    private LineReader createLineReader(Terminal terminal, History history, ReplCompleter completer, ReplParser parser, String secondaryPrompt) {
        return LineReaderBuilder.builder().appName("Venice").terminal(terminal).history(history).expander(new NullExpander()).completer(completer).highlighter(this.highlighter).parser(parser).option(LineReader.Option.HISTORY_IGNORE_SPACE, false).variable("secondary-prompt-pattern", secondaryPrompt).variable("indentation", 2).variable("list-max", 100).variable("history-file", HISTORY_FILE).variable("features-max-buffer-size", 5000).build();
    }

    private void handleDroppedFileName(String droppedFileName, Env env, History history, ReplResultHistory resultHistory, String resultPrefix) throws Exception {
        String script;
        String file = this.unescapeDroppedFileName(droppedFileName.trim());
        if (!new File(file).exists()) {
            this.printer.println("error", String.format("The file \"%s\" does not exist!", file));
            return;
        }
        List<String> lines = Files.readAllLines(new File(file).toPath());
        if (lines.size() < 20) {
            script = String.join((CharSequence)"\n", lines);
            history.add(script);
            this.printer.println("stdout", DocForm.highlight(new VncString(script), env).getValue());
        }
        ThreadContext.clearCallStack();
        script = String.format("(load-file \"%s\")", file);
        history.add(script);
        this.runScript(script, resultPrefix, resultHistory);
    }

    private void handleReplCommand(String cmdLine, Env env, Terminal terminal, History history) {
        try {
            List<String> items = Arrays.asList(cmdLine.split(" +"));
            String cmd = items.get(0);
            List<String> args = CollectionUtil.drop(items, 1);
            if (this.hasActiveDebugSession()) {
                this.printer.println("error", "Debugging session is active! Can only run debug commands.");
            } else {
                switch (cmd) {
                    case "macroexpand": {
                        this.handleMacroExpandCommand(env);
                        break;
                    }
                    case "me": {
                        this.handleMacroExpandCommand(env);
                        break;
                    }
                    case "": {
                        this.handleHelpCommand();
                        break;
                    }
                    case "?": {
                        this.handleHelpCommand();
                        break;
                    }
                    case "help": {
                        this.handleHelpCommand();
                        break;
                    }
                    case "config": {
                        this.handleConfigCommand();
                        break;
                    }
                    case "dark": {
                        this.handleColorModeCommand(ReplConfig.ColorMode.Dark);
                        break;
                    }
                    case "darkmode": {
                        this.handleColorModeCommand(ReplConfig.ColorMode.Dark);
                        break;
                    }
                    case "light": {
                        this.handleColorModeCommand(ReplConfig.ColorMode.Light);
                        break;
                    }
                    case "lightmode": {
                        this.handleColorModeCommand(ReplConfig.ColorMode.Light);
                        break;
                    }
                    case "restartable": {
                        this.handleRestartableCommand();
                        break;
                    }
                    case "classpath": {
                        this.handleReplClasspathCommand();
                        break;
                    }
                    case "cp": {
                        this.handleReplClasspathCommand();
                        break;
                    }
                    case "loadpath": {
                        this.handleLoadPathsCommand(this.interceptor.getLoadPaths());
                        break;
                    }
                    case "launcher": {
                        this.handleLauncherCommand();
                        break;
                    }
                    case "app": {
                        this.handleAppCommand(args, terminal, env);
                        break;
                    }
                    case "manifest": {
                        this.handleAppManifestCommand(args, terminal, env);
                        break;
                    }
                    case "env": {
                        this.handleEnvCommand(args, env);
                        break;
                    }
                    case "hist": {
                        this.handleHistoryCommand(args, terminal, history);
                        break;
                    }
                    case "sandbox": {
                        this.handleSandboxCommand(args, terminal, env);
                        break;
                    }
                    case "colors": {
                        this.handleConfiguredColorsCommand();
                        break;
                    }
                    case "info": {
                        this.handleInfoCommand(terminal);
                        break;
                    }
                    case "highlight": {
                        this.handleHighlightCommand(args);
                        break;
                    }
                    case "java-ex": {
                        this.handleJavaExCommand(args);
                        break;
                    }
                    case "debug": {
                        this.handleDebugHelpCommand();
                        break;
                    }
                    case "source-pdf": {
                        this.handleSourcePdfCommand(args);
                        break;
                    }
                    case "license": {
                        this.handleLicenseCommand(args);
                        break;
                    }
                    default: {
                        this.handleInvalidCommand(cmd);
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            this.handleFailedCommand(ex);
        }
    }

    private void handleConfigCommand() {
        this.printer.println("stdout", "Sample REPL configuration. Save it as 'repl.json'");
        this.printer.println("stdout", "to the REPL's working directory:");
        this.printer.println();
        this.printer.println("stdout", ReplConfig.getDefaultClasspathConfig());
    }

    private void handleColorModeCommand(ReplConfig.ColorMode mode) {
        this.config.switchColorMode(mode);
        if (this.highlighter != null) {
            this.highlighter.reloadColors();
        }
    }

    private void handleMacroExpandCommand(Env env) {
        this.venice.setMacroExpandOnLoad(true);
        this.printer.println("system", "Macro expansion enabled");
    }

    private void handleHelpCommand() {
        this.printer.println("stdout", ReplHelp.COMMANDS);
    }

    private void handleDebugHelpCommand() {
        ReplDebugClient.pringHelp(this.printer);
    }

    private void handleLauncherCommand() {
        String name = ReplConfig.getLauncherScriptName();
        this.printer.println("stdout", "Sample REPL launcher script. Save it as '" + name + "'");
        this.printer.println("stdout", "to the REPL's working directory:");
        this.printer.println();
        this.printer.println("stdout", ReplConfig.getDefaultClasspathLauncherScript());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAppCommand(List<String> params, Terminal terminal, Env env) {
        if (params.size() != 1) {
            this.printer.println("stdout", "Please pass an app name:\n   !app {app-name}\n");
            return;
        }
        File appArchive = new File(this.addZipFileExt(params.get(0)));
        if (!appArchive.exists()) {
            this.printer.println("error", String.format("App archive '%s' not found!", appArchive));
            return;
        }
        IInterceptor oldInterceptor = this.interceptor;
        VncKeyword oldRunMode = (VncKeyword)env.getGlobalOrNull(new VncSymbol("*run-mode*"));
        try {
            VncMap manifest = this.getAppManifest(appArchive);
            String appName = Coerce.toVncString(manifest.get(new VncString("app-name"))).getValue();
            String mainFile = Coerce.toVncString(manifest.get(new VncString("main-file"))).getValue();
            String mainFileBasename = StringUtil.removeEnd(mainFile, ".venice");
            ArrayList<File> mergedLoadPaths = new ArrayList<File>();
            mergedLoadPaths.add(appArchive.getAbsoluteFile());
            mergedLoadPaths.addAll(this.interceptor.getLoadPaths().getPaths());
            ILoadPaths appLoadPaths = LoadPathsFactory.of(mergedLoadPaths, this.interceptor.getLoadPaths().isUnlimitedAccess());
            this.printer.println("stdout", String.format("Launching Venice application '%s' ...", appName));
            this.reconfigureVenice(new AcceptAllInterceptor(appLoadPaths), this.venice.isMacroExpandOnLoad());
            env.removeGlobalSymbol(new VncSymbol("*run-mode*"));
            env.setGlobal(new Var(new VncSymbol("*run-mode*"), RunMode.APP.mode, Var.Scope.Global));
            env.setGlobal(new Var(new VncSymbol("*app-name*"), new VncString(appName), false, Var.Scope.Global));
            env.setGlobal(new Var(new VncSymbol("*app-archive*"), new VncJavaObject(appArchive), false, Var.Scope.Global));
            String expr = String.format("(do (load-file \"%s\") nil)", mainFileBasename);
            this.runScriptSync(expr, this.resultPrefix, null);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            this.reconfigureVenice(oldInterceptor, this.venice.isMacroExpandOnLoad());
            env.removeGlobalSymbol(new VncSymbol("*run-mode*"));
            env.setGlobal(new Var(new VncSymbol("*run-mode*"), oldRunMode, Var.Scope.Global));
            env.removeGlobalSymbol(new VncSymbol("*app-name*"));
            env.removeGlobalSymbol(new VncSymbol("*app-archive*"));
        }
    }

    private void handleAppManifestCommand(List<String> params, Terminal terminal, Env env) {
        if (params.size() != 1) {
            this.printer.println("stdout", "Please pass an app name:\n   !app {app-name}\n");
            return;
        }
        File appArchive = new File(this.addZipFileExt(params.get(0)));
        if (!appArchive.exists()) {
            this.printer.println("error", String.format("App archive '%s' not found!", appArchive));
            return;
        }
        try {
            VncMap manifest = this.getAppManifest(appArchive);
            this.printer.println("stdout", manifest.toString(true));
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void handleEnvCommand(List<String> params, Env env) {
        if (params.isEmpty()) {
            this.printer.println("stdout", "Please choose from:\n   !env print {symbol-name}\n   !env global\n   !env global io/*\n   !env global *file*\n");
            return;
        }
        if (CollectionUtil.first(params).equals("print")) {
            if (params.size() == 2) {
                VncVal val = env.get(new VncSymbol(CollectionUtil.second(params)));
                this.printer.println("stdout", this.venice.PRINT(val));
                return;
            }
        } else if (CollectionUtil.first(params).equals("global")) {
            if (params.size() == 1) {
                this.printer.println("stdout", EnvUtils.envGlobalsToString(env, null));
                return;
            }
            if (params.size() == 2) {
                String filter = StringUtil.trimToNull(CollectionUtil.second(params));
                filter = filter == null ? null : filter.replaceAll("[*]", ".*");
                this.printer.println("stdout", EnvUtils.envGlobalsToString(env, filter));
                return;
            }
        }
        this.printer.println("error", "Invalid env command");
    }

    private void handleSandboxCommand(List<String> params, Terminal terminal, Env env) {
        if (params.isEmpty()) {
            terminal.writer().println("Please choose from:\n   !sandbox status\n   !sandbox config\n   !sandbox accept-all\n   !sandbox reject-all\n   !sandbox customized\n   !sandbox fn-group *print*\n   !sandbox add-rule class:java.lang.Math:*\n   !sandbox add-rule system.property:os.name\n   !sandbox add-rule blacklist:venice:func:io/exists-dir?\n   !sandbox add-rule blacklist:venice:func:*io*\n   !sandbox add-rule whitelist:venice:func:println\n   !sandbox add-rule venice:module:shell\n");
            return;
        }
        String interceptorName = this.interceptor.getClass().getSimpleName();
        if (params.size() == 1) {
            if (CollectionUtil.first(params).equals("status")) {
                if (this.interceptor instanceof AcceptAllInterceptor) {
                    this.printer.println("stdout", "No sandbox active (" + interceptorName + ")");
                    return;
                }
                if (this.interceptor instanceof RejectAllInterceptor) {
                    this.printer.println("stdout", "Sandbox active (" + interceptorName + "). Rejects all Java calls and default blacklisted Venice functions");
                    return;
                }
                if (this.interceptor instanceof SandboxInterceptor) {
                    this.printer.println("stdout", "Customized sandbox active (" + interceptorName + ")");
                    return;
                }
                this.printer.println("stdout", "Sandbox: " + interceptorName);
                return;
            }
            if (CollectionUtil.first(params).equals("accept-all")) {
                this.reconfigureVenice(new AcceptAllInterceptor(LoadPathsFactory.of(this.interceptor.getLoadPaths().getPaths(), true)), this.venice.isMacroExpandOnLoad());
                return;
            }
            if (CollectionUtil.first(params).equals("reject-all")) {
                this.reconfigureVenice(new RejectAllInterceptor(), this.venice.isMacroExpandOnLoad());
                return;
            }
            if (CollectionUtil.first(params).equals("customized")) {
                this.reconfigureVenice(new SandboxInterceptor(new SandboxRules(), LoadPathsFactory.of(this.interceptor.getLoadPaths().getPaths(), true)), this.venice.isMacroExpandOnLoad());
                return;
            }
            if (CollectionUtil.first(params).equals("config")) {
                if (this.interceptor instanceof AcceptAllInterceptor) {
                    this.printer.println("stdout", "[accept-all] NO sandbox active");
                    this.printer.println("stdout", "Java calls:                     No restriction");
                    this.printer.println("stdout", "Venice functions:               No restriction");
                    this.printer.println("stdout", "System properties:              No restriction");
                    this.printer.println("stdout", "System environment variables:   No restriction");
                    return;
                }
                if (this.interceptor instanceof RejectAllInterceptor) {
                    this.printer.println("stdout", "[reject-all] SAFE restricted sandbox");
                    this.printer.println("stdout", "Java calls:\n   All rejected!");
                    this.printer.println("stdout", "Whitelisted Venice modules:\n" + ((RejectAllInterceptor)this.interceptor).getWhitelistedVeniceModules().stream().map(s -> "   " + s).collect(Collectors.joining("\n")));
                    this.printer.println("stdout", "Blacklisted Venice functions:\n" + ((RejectAllInterceptor)this.interceptor).getBlacklistedVeniceFunctions().stream().map(s -> "   " + s).collect(Collectors.joining("\n")));
                    this.printer.println("stdout", "System properties:\n   All rejected!");
                    this.printer.println("stdout", "System environment variables:\n   All rejected!");
                    return;
                }
                if (this.interceptor instanceof SandboxInterceptor) {
                    this.printer.println("stdout", "[customized] Customized sandbox");
                    this.printer.println("stdout", "Sandbox rules:\n" + ((SandboxInterceptor)this.interceptor).getRules().toString());
                    return;
                }
                this.printer.println("stdout", "[" + interceptorName + "]");
                this.printer.println("stdout", "no info");
                return;
            }
            if (CollectionUtil.first(params).equals("fn-group")) {
                this.printer.println("stdout", "Groups: " + String.join((CharSequence)", ", SandboxFunctionGroups.getGroups()));
                return;
            }
        } else if (params.size() == 2) {
            if (CollectionUtil.first(params).equals("fn-group")) {
                String group = CollectionUtil.second(params);
                if (SandboxFunctionGroups.isValidGroup(group)) {
                    SandboxFunctionGroups.groupFunctionsSorted(group).forEach(f -> this.printer.println("stdout", "   " + f));
                } else {
                    this.printer.println("error", "invalid sandbox function group: " + group + ". Use one of " + String.join((CharSequence)", ", SandboxFunctionGroups.getGroups()));
                }
                return;
            }
            if (CollectionUtil.first(params).equals("add-rule")) {
                String rule = CollectionUtil.second(params);
                if (!(this.interceptor instanceof SandboxInterceptor)) {
                    this.printer.println("system", "rules can only be added to a customized sandbox");
                    return;
                }
                SandboxRules rules = ((SandboxInterceptor)this.interceptor).getRules();
                if (rule.startsWith("class:")) {
                    rules.withClasses(rule);
                } else if (rule.startsWith("system.property:")) {
                    rules.withSystemProperties(rule);
                } else if (rule.startsWith("system.env:")) {
                    rules.withSystemEnvs(rule);
                } else if (rule.startsWith("venice:module:")) {
                    rules.withVeniceModules(rule);
                } else if (rule.startsWith("blacklist:venice:func:")) {
                    rules.rejectVeniceFunctions(rule);
                } else if (rule.startsWith("whitelist:venice:func:")) {
                    rules.whitelistVeniceFunctions(rule);
                } else {
                    terminal.writer().println("Please choose from:\n   !sandbox status\n   !sandbox config\n   !sandbox accept-all\n   !sandbox reject-all\n   !sandbox customized\n   !sandbox fn-group *print*\n   !sandbox add-rule class:java.lang.Math:*\n   !sandbox add-rule system.property:os.name\n   !sandbox add-rule blacklist:venice:func:io/exists-dir?\n   !sandbox add-rule blacklist:venice:func:*io*\n   !sandbox add-rule whitelist:venice:func:println\n   !sandbox add-rule venice:module:shell\n");
                    return;
                }
                this.reconfigureVenice(new SandboxInterceptor(rules, LoadPathsFactory.of(this.interceptor.getLoadPaths().getPaths(), true)), this.venice.isMacroExpandOnLoad());
                return;
            }
        }
        this.printer.println("error", "invalid sandbox command: " + Arrays.asList(params));
    }

    private void handleHighlightCommand(List<String> params) {
        if (params.isEmpty()) {
            this.printer.println("stdout", "Highlighting: " + (this.highlight ? "on" : "off"));
        } else {
            switch (StringUtil.trimToEmpty(CollectionUtil.first(params))) {
                case "on": {
                    this.highlight = true;
                    if (this.highlighter == null) break;
                    this.highlighter.enable(true);
                    break;
                }
                case "off": {
                    this.highlight = false;
                    if (this.highlighter == null) break;
                    this.highlighter.enable(false);
                    break;
                }
                default: {
                    this.printer.println("error", "Invalid parameter. Use !highlight {on|off}.");
                }
            }
        }
    }

    private void handleJavaExCommand(List<String> params) {
        if (params.isEmpty()) {
            this.printer.println("stdout", "Java Exceptions: " + (this.javaExceptions ? "on" : "off"));
        } else {
            switch (StringUtil.trimToEmpty(CollectionUtil.first(params))) {
                case "on": {
                    this.javaExceptions = true;
                    this.printer.setPrintJavaEx(this.javaExceptions);
                    this.printer.println("stdout", "Printing Java exceptions");
                    break;
                }
                case "off": {
                    this.javaExceptions = false;
                    this.printer.setPrintJavaEx(this.javaExceptions);
                    this.printer.println("stdout", "Printing Venice exceptions");
                    break;
                }
                default: {
                    this.printer.println("error", "Invalid parameter. Use !java-ex {on|off}.");
                }
            }
        }
    }

    private void handleSourcePdfCommand(List<String> params) {
        if (params.size() == 1) {
            String sourceFile = StringUtil.trimToEmpty(CollectionUtil.first(params));
            String destDir = ".";
            String fontDir = this.replDirs.getFontsDir().getAbsolutePath();
            SourceCodeRenderer.render(sourceFile, ".", fontDir, true, true);
        } else if (params.size() == 2) {
            String sourceFile = StringUtil.trimToEmpty(CollectionUtil.first(params));
            String destDir = StringUtil.trimToEmpty(CollectionUtil.second(params));
            String fontDir = this.replDirs.getFontsDir().getAbsolutePath();
            SourceCodeRenderer.render(sourceFile, destDir, fontDir, true, true);
        } else {
            this.printer.println("error", "Invalid parameter. Use !source-pdf {source-file} {dest-dir}");
        }
    }

    private void handleLicenseCommand(List<String> params) {
        try {
            if (params.size() == 0) {
                this.printer.println("stdout", LicenseMgr.loadVeniceLicenseText());
            } else if ("all".equals(StringUtil.trimToEmpty(CollectionUtil.first(params)))) {
                this.printer.println("stdout", LicenseMgr.loadAll());
            } else {
                this.printer.println("error", "Invalid parameter. Use !license or !license all");
            }
        }
        catch (Exception ex) {
            this.printer.println("error", "Failed to display Venice license info");
        }
    }

    private void handleConfiguredColorsCommand() {
        this.printer.println("default", "default");
        this.printer.println("command", "command");
        this.printer.println("result", "result");
        this.printer.println("stdout", "stdout");
        this.printer.println("stderr", "stderr");
        this.printer.println("debug", "debug");
        this.printer.println("error", "error");
        this.printer.println("system", "system");
        this.printer.println("interrupt", "interrupt");
    }

    private void handleRestartableCommand() {
        this.printer.println("stdout", "restartable: " + (this.restartable ? "yes" : "no"));
    }

    private void handleLoadPathsCommand(ILoadPaths loadPaths) {
        this.printer.println("stdout", "Restricted to load paths: " + (loadPaths.isUnlimitedAccess() ? "no" : "yes"));
        this.printer.println("stdout", "Paths: ");
        loadPaths.getPaths().forEach(p -> this.printer.println("stdout", "   " + p.getPath()));
    }

    private void handleInfoCommand(Terminal terminal) {
        Integer maxColors = terminal.getNumericCapability(InfoCmp.Capability.max_colors);
        Size size = terminal.getSize();
        String jansiVersion = SystemFunctions.getJansiVersion();
        this.printer.println("stdout", "Terminal Name:   " + terminal.getName());
        this.printer.println("stdout", "Terminal Type:   " + terminal.getType());
        this.printer.println("stdout", "Terminal Size:   " + size.getRows() + "x" + size.getColumns());
        this.printer.println("stdout", "Terminal Colors: " + maxColors);
        this.printer.println("stdout", "Terminal Class:  " + terminal.getClass().getSimpleName());
        this.printer.println("stdout", "Jansi Library:   " + (jansiVersion == null ? "n/a" : jansiVersion));
        this.printer.println("stdout", "");
        this.printer.println("stdout", "Color Mode:      " + this.config.getColorMode().toString().toLowerCase());
        this.printer.println("stdout", "Highlighting:    " + (this.config.isSyntaxHighlighting() ? "on" : "off"));
        this.printer.println("stdout", "Java Exceptions: " + (this.javaExceptions ? "on" : "off"));
        this.printer.println("stdout", "Macro Expansion: " + (this.venice.isMacroExpandOnLoad() ? "on" : "off"));
        this.printer.println("stdout", "Restartable:     " + (this.restartable ? "yes" : "no"));
        this.printer.println("stdout", "Debugger:        " + this.getDebuggerStatus());
        this.printer.println("stdout", "");
        this.printer.println("stdout", "Home dir:        " + this.replDirs.getHomeDir());
        this.printer.println("stdout", "Libs dir:        " + this.replDirs.getLibsDir());
        this.printer.println("stdout", "Fonts dir:       " + this.replDirs.getFontsDir());
        this.printer.println("stdout", "Scripts dir:     " + this.replDirs.getScriptsDir());
        this.printer.println("stdout", "");
        this.printer.println("stdout", "Env TERM:        " + System.getenv("TERM"));
        this.printer.println("stdout", "Env GITPOD:      " + this.isRunningOnLinuxGitPod());
        this.printer.println("stdout", "");
        this.printer.println("stdout", "OS Arch:         " + System.getProperty("os.arch"));
        this.printer.println("stdout", "OS Name:         " + System.getProperty("os.name"));
        this.printer.println("stdout", "OS Version:      " + System.getProperty("os.version"));
        this.printer.println("stdout", "");
        this.printer.println("stdout", "Java Version:    " + System.getProperty("java.version"));
        this.printer.println("stdout", "Java Vendor:     " + System.getProperty("java.vendor"));
        this.printer.println("stdout", "Java VM Version: " + System.getProperty("java.vm.version"));
        this.printer.println("stdout", "Java VM Name:    " + System.getProperty("java.vm.name"));
        this.printer.println("stdout", "Java VM Vendor:  " + System.getProperty("java.vm.vendor"));
    }

    private void handleInvalidCommand(String cmd) {
        if (ReplDebugClient.isDebugCommand(cmd)) {
            this.printer.println("error", "This debugging command requires an attached debugger! Use the !attach command first.");
        } else {
            this.printer.println("error", "Invalid command");
        }
    }

    private void handleFailedCommand(Exception ex) {
        this.printer.println("error", "Failed to handle REPL command");
        this.printer.println("error", ex.getMessage());
    }

    private void handleException(Exception ex) {
        if (ex instanceof InterruptedException) {
            this.printer.println("stdout", "\nRunning interrupt hooks");
            Thread.interrupted();
            SystemFunctions.runInterruptHooks();
            this.printer.printex("error", ex);
        } else if (ex instanceof SymbolNotFoundException) {
            this.handleSymbolNotFoundException((SymbolNotFoundException)ex);
        } else {
            this.printer.printex("error", ex);
        }
    }

    private void handleSymbolNotFoundException(SymbolNotFoundException ex) {
        boolean nsLoaded;
        String ns;
        VncSymbol sym = new VncSymbol(ex.getSymbol());
        if (sym.hasNamespace() && !Namespaces.isCoreNS(ns = sym.getNamespace()) && !(nsLoaded = this.env.getAllGlobalFunctionSymbols().stream().anyMatch(s -> ns.equals(s.getNamespace())))) {
            this.printer.println("error", String.format("Symbol '%s' not found!\n*** Have you loaded the module or file that defines the namespace '%s'? ***\n\n", sym, sym.getNamespace()));
        }
        this.printer.printex("error", ex);
    }

    private Env loadEnv(IVeniceInterpreter venice, CommandLineArgs cli, Terminal terminal, PrintStream out, PrintStream err, BufferedReader in, boolean macroexpand) {
        Env env = venice.createEnv(macroexpand, this.ansiTerminal, RunMode.REPL).setGlobal(new Var(new VncSymbol("*ARGV*"), cli.argsAsList(), false, Var.Scope.Global)).setStdoutPrintStream(out).setStderrPrintStream(err).setStdinReader(in);
        return ReplFunctions.register(env, this, terminal, this.config, venice.isMacroExpandOnLoad(), this.replDirs);
    }

    private void reconfigureVenice(IInterceptor interceptor, boolean macroExpandOnLoad) {
        DebugAgent agent = DebugAgent.current();
        this.interceptor = interceptor;
        this.venice = new VeniceInterpreter(interceptor);
        this.venice.setMacroExpandOnLoad(macroExpandOnLoad);
        DebugAgent.register(agent);
    }

    private PrintStream createPrintStream(String context, Terminal terminal) {
        return new ReplPrintStream(terminal, this.ansiTerminal ? this.config.getColor(context) : null);
    }

    private BufferedReader createBufferedReader(String context, Terminal terminal) {
        return new BufferedReader(terminal.reader());
    }

    private String getTerminalInfo() {
        if (this.ansiTerminal) {
            switch (this.config.getColorMode()) {
                case Light: {
                    return "Using Ansi terminal (light color mode turned on)\nUse the commands !lightmode or !darkmode to adapt to the terminal's colors";
                }
                case Dark: {
                    return "Using Ansi terminal (dark color mode turned on)\nUse the commands !lightmode or !darkmode to adapt to the terminal's colors";
                }
            }
            return "Using Ansi terminal (colors turned off, turn on with option '-colors')";
        }
        return "Using dumb terminal (colors turned off)";
    }

    private boolean isAnsiTerminal(CommandLineArgs cli, ReplConfig config) {
        String jansiVersion = config.getJansiVersion();
        boolean dumbTerminal = OSUtils.IS_WINDOWS && jansiVersion == null || cli.switchPresent("-dumb") || config.isJLineDumbTerminal();
        return !dumbTerminal;
    }

    private void initJLineLogger(ReplConfig config) {
        Level jlineLogLevel = config.getJLineLogLevel();
        if (jlineLogLevel != null) {
            Logger.getLogger("org.repackage.org.jline").setLevel(jlineLogLevel);
        }
    }

    private void handleReplClasspathCommand() {
        this.printer.println("stdout", "REPL classpath:");
        Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).sorted().forEach(f -> this.printer.println("stdout", "  " + f));
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl instanceof DynamicClassLoader2) {
            this.printer.println("stdout", "REPL dynamic classpath:");
            Arrays.stream(((URLClassLoader)cl).getURLs()).map(u -> u.toString()).sorted().forEach(u -> this.printer.println("stdout", "  " + u));
        }
    }

    private boolean isRestartable(CommandLineArgs cli) {
        return cli.switchPresent("-restartable");
    }

    private boolean isMacroexpand(CommandLineArgs cli) {
        return cli.switchPresent("-macroexpand");
    }

    private boolean isRunningOnLinuxGitPod() {
        return "Linux".equals(System.getProperty("os.name")) && System.getenv("GITPOD_REPO_ROOT") != null;
    }

    private void clearCommandHistoryIfRequired(History history) {
        if (this.config.isClearCommandHistoryOnExit()) {
            this.clearCommandHistory(history);
        }
    }

    private void clearCommandHistory(History history) {
        try {
            this.printer.println("stdout", "Cleared REPL command history");
            history.purge();
        }
        catch (IOException ex) {
            this.printer.println("stderr", "Failed to clear REPL command history!");
        }
    }

    private void handleHistoryCommand(List<String> params, Terminal terminal, History history) {
        if (params.isEmpty()) {
            this.printer.println("stdout", String.format("History: size: %d, first: %d, last: %d, index: %d", history.size(), history.first(), history.last(), history.index()));
        } else if (CollectionUtil.first(params).equals("clear")) {
            this.clearCommandHistory(history);
        } else if (CollectionUtil.first(params).equals("load")) {
            try {
                history.load();
            }
            catch (IOException ex) {
                this.printer.println("stderr", "Failed to reload REPL command history!");
            }
        } else if (CollectionUtil.first(params).equals("log")) {
            Logger logger = Logger.getLogger("org.repackage.org.jline");
            logger.setLevel(Level.INFO);
            for (Handler h : logger.getHandlers()) {
                logger.removeHandler(h);
            }
            logger.addHandler(new ReplJLineLogHandler(this.printer));
            this.printer.println("stdout", "Enabled REPL JLine logging");
        } else {
            this.printer.println("error", "Invalid hist command");
        }
    }

    private String unescapeDroppedFileName(String fileName) {
        String osType = REPL.osType();
        if ("windows".equals(osType)) {
            return fileName;
        }
        return fileName.replace("\\", "");
    }

    private static String osType() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return "windows";
        }
        if (osName.startsWith("Mac OS X")) {
            return "mac-osx";
        }
        if (osName.startsWith("Linux")) {
            return "linux";
        }
        return "unknown";
    }

    private boolean hasActiveDebugSession() {
        DebugAgent agent = DebugAgent.current();
        return agent != null && agent.hasActiveBreak();
    }

    private String getDebuggerStatus() {
        return DebugAgent.isAttached() ? "attached" : "not attached";
    }

    private void changePrompt(String prompt) {
        this.prompt = prompt;
        this.secondaryPrompt = this.ansiTerminal ? StringUtil.repeat(' ', prompt.length()) : "";
    }

    private String addZipFileExt(String s) {
        return s.endsWith(".zip") ? s : s + ".zip";
    }

    private VncMap getAppManifest(File app) {
        if (app.exists()) {
            try {
                String manifest = ZipFileSystemUtil.loadTextFileFromZip(app, new File("MANIFEST.MF"), CharsetUtil.charset("UTF-8"));
                return Coerce.toVncMap(JsonFunctions.read_str.apply(VncList.of(new VncString(manifest))));
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to load manifest from Venice application archive '%s'.", app.getPath()));
            }
        }
        throw new VncException(String.format("The Venice application archive '%s' does not exist", app.getPath()));
    }
}

