/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.crypt;

import com.github.jlangch.venice.util.crypt.FileEncryptor_AES256_CBC;
import com.github.jlangch.venice.util.crypt.FileEncryptor_AES256_GCM;
import com.github.jlangch.venice.util.crypt.FileEncryptor_ChaCha20;
import com.github.jlangch.venice.util.crypt.FileEncryptor_ChaCha20_BouncyCastle;
import com.github.jlangch.venice.util.crypt.Util;
import java.io.File;
import java.nio.file.Files;
import java.security.Provider;
import java.security.Security;

public class FileEncryptor {
    private static boolean AVAILABLE_CHACHA20 = Util.hasClass("javax.crypto.spec.ChaCha20ParameterSpec");
    private static boolean AVAILABLE_CHACHA20_BC = Util.hasClass("org.bouncycastle.crypto.engines.ChaChaEngine");

    public static void encryptFileWithPassphrase(String algorithm, String passphrase, File inputFile, File outputFile) throws Exception {
        switch (FileEncryptor.trimToEmpty(algorithm).toUpperCase()) {
            case "AES256-CBC": {
                FileEncryptor_AES256_CBC.encryptFileWithPassphrase(passphrase, inputFile, outputFile);
                break;
            }
            case "AES256-GCM": {
                FileEncryptor_AES256_GCM.encryptFileWithPassphrase(passphrase, inputFile, outputFile);
                break;
            }
            case "CHACHA20": {
                FileEncryptor_ChaCha20.encryptFileWithPassphrase(passphrase, inputFile, outputFile);
                break;
            }
            case "CHACHA20-BC": {
                FileEncryptor_ChaCha20_BouncyCastle.encryptFileWithPassphrase(passphrase, inputFile, outputFile);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported algorithm '" + algorithm + "'!");
            }
        }
    }

    public static byte[] encryptFileWithPassphrase(String algorithm, String passphrase, byte[] fileData) throws Exception {
        switch (FileEncryptor.trimToEmpty(algorithm).toUpperCase()) {
            case "AES256-CBC": {
                return FileEncryptor_AES256_CBC.encryptFileWithPassphrase(passphrase, fileData);
            }
            case "AES256-GCM": {
                return FileEncryptor_AES256_GCM.encryptFileWithPassphrase(passphrase, fileData);
            }
            case "CHACHA20": {
                return FileEncryptor_ChaCha20.encryptFileWithPassphrase(passphrase, fileData);
            }
            case "CHACHA20-BC": {
                return FileEncryptor_ChaCha20_BouncyCastle.encryptFileWithPassphrase(passphrase, fileData);
            }
        }
        throw new RuntimeException("Unsupported algorithm '" + algorithm + "'!");
    }

    public static void encryptFileWithKey(String algorithm, byte[] key, File inputFile, File outputFile) throws Exception {
        switch (FileEncryptor.trimToEmpty(algorithm).toUpperCase()) {
            case "AES256-CBC": {
                FileEncryptor_AES256_CBC.encryptFileWithKey(key, inputFile, outputFile);
                break;
            }
            case "AES256-GCM": {
                FileEncryptor_AES256_GCM.encryptFileWithKey(key, inputFile, outputFile);
                break;
            }
            case "CHACHA20": {
                FileEncryptor_ChaCha20.encryptFileWithKey(key, inputFile, outputFile);
                break;
            }
            case "CHACHA20-BC": {
                FileEncryptor_ChaCha20_BouncyCastle.encryptFileWithKey(key, inputFile, outputFile);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported algorithm '" + algorithm + "'!");
            }
        }
    }

    public static byte[] encryptFileWithKey(String algorithm, byte[] key, byte[] fileData) throws Exception {
        switch (FileEncryptor.trimToEmpty(algorithm).toUpperCase()) {
            case "AES256-CBC": {
                return FileEncryptor_AES256_CBC.encryptFileWithKey(key, fileData);
            }
            case "AES256-GCM": {
                return FileEncryptor_AES256_GCM.encryptFileWithKey(key, fileData);
            }
            case "CHACHA20": {
                return FileEncryptor_ChaCha20.encryptFileWithKey(key, fileData);
            }
            case "CHACHA20-BC": {
                return FileEncryptor_ChaCha20_BouncyCastle.encryptFileWithKey(key, fileData);
            }
        }
        throw new RuntimeException("Unsupported algorithm '" + algorithm + "'!");
    }

    public static void decryptFileWithPassphrase(String algorithm, String passphrase, File inputFile, File outputFile) throws Exception {
        switch (FileEncryptor.trimToEmpty(algorithm).toUpperCase()) {
            case "AES256-CBC": {
                FileEncryptor_AES256_CBC.decryptFileWithPassphrase(passphrase, inputFile, outputFile);
                break;
            }
            case "AES256-GCM": {
                FileEncryptor_AES256_GCM.decryptFileWithPassphrase(passphrase, inputFile, outputFile);
                break;
            }
            case "CHACHA20": {
                FileEncryptor_ChaCha20.decryptFileWithPassphrase(passphrase, inputFile, outputFile);
                break;
            }
            case "CHACHA20-BC": {
                FileEncryptor_ChaCha20_BouncyCastle.decryptFileWithPassphrase(passphrase, inputFile, outputFile);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported algorithm '" + algorithm + "'!");
            }
        }
    }

    public static byte[] decryptFileWithPassphrase(String algorithm, String passphrase, byte[] fileData) throws Exception {
        switch (FileEncryptor.trimToEmpty(algorithm).toUpperCase()) {
            case "AES256-CBC": {
                return FileEncryptor_AES256_CBC.decryptFileWithPassphrase(passphrase, fileData);
            }
            case "AES256-GCM": {
                return FileEncryptor_AES256_GCM.decryptFileWithPassphrase(passphrase, fileData);
            }
            case "CHACHA20": {
                return FileEncryptor_ChaCha20.decryptFileWithPassphrase(passphrase, fileData);
            }
            case "CHACHA20-BC": {
                return FileEncryptor_ChaCha20_BouncyCastle.decryptFileWithPassphrase(passphrase, fileData);
            }
        }
        throw new RuntimeException("Unsupported algorithm '" + algorithm + "'!");
    }

    public static void decryptFileWithKey(String algorithm, byte[] key, File inputFile, File outputFile) throws Exception {
        switch (FileEncryptor.trimToEmpty(algorithm).toUpperCase()) {
            case "AES256-CBC": {
                FileEncryptor_AES256_CBC.decryptFileWithKey(key, inputFile, outputFile);
                break;
            }
            case "AES256-GCM": {
                FileEncryptor_AES256_GCM.decryptFileWithKey(key, inputFile, outputFile);
                break;
            }
            case "CHACHA20": {
                FileEncryptor_ChaCha20.decryptFileWithKey(key, inputFile, outputFile);
                break;
            }
            case "CHACHA20-BC": {
                FileEncryptor_ChaCha20_BouncyCastle.decryptFileWithKey(key, inputFile, outputFile);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported algorithm '" + algorithm + "'!");
            }
        }
    }

    public static byte[] decryptFileWithKey(String algorithm, byte[] key, byte[] fileData) throws Exception {
        switch (FileEncryptor.trimToEmpty(algorithm).toUpperCase()) {
            case "AES256-CBC": {
                return FileEncryptor_AES256_CBC.decryptFileWithKey(key, fileData);
            }
            case "AES256-GCM": {
                return FileEncryptor_AES256_GCM.decryptFileWithKey(key, fileData);
            }
            case "CHACHA20": {
                return FileEncryptor_ChaCha20.decryptFileWithKey(key, fileData);
            }
            case "CHACHA20-BC": {
                return FileEncryptor_ChaCha20_BouncyCastle.decryptFileWithKey(key, fileData);
            }
        }
        throw new RuntimeException("Unsupported algorithm '" + algorithm + "'!");
    }

    public static boolean supports(String algorithm) throws Exception {
        switch (FileEncryptor.trimToEmpty(algorithm).toUpperCase()) {
            case "AES256-CBC": {
                return true;
            }
            case "AES256-GCM": {
                return true;
            }
            case "CHACHA20": {
                return AVAILABLE_CHACHA20;
            }
            case "CHACHA20-BC": {
                return AVAILABLE_CHACHA20_BC;
            }
        }
        throw new RuntimeException("Unsupported algorithm '" + algorithm + "'!");
    }

    public static boolean hasProvider(String name) {
        return Security.getProvider(FileEncryptor.trimToEmpty(name)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addBouncyCastleProvider() {
        Class<FileEncryptor> clazz = FileEncryptor.class;
        synchronized (FileEncryptor.class) {
            if (Security.getProvider("BC") != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return false;
            }
            try {
                Security.addProvider((Provider)Util.classForName("org.bouncycastle.jce.provider.BouncyCastleProvider").getConstructor(new Class[0]).newInstance(new Object[0]));
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
            catch (Exception ex) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return false;
            }
        }
    }

    public static boolean identical(File file1, File file2) throws Exception {
        return FileEncryptor.identical(Files.readAllBytes(file1.toPath()), Files.readAllBytes(file2.toPath()));
    }

    public static boolean identical(byte[] buf1, byte[] buf2) throws Exception {
        if (buf1.length == buf2.length) {
            for (int ii = 0; ii < buf1.length; ++ii) {
                if (buf1[ii] == buf2[ii]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String trimToEmpty(String s) {
        return s == null ? "" : s.trim();
    }
}

