/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.excel;

import com.github.jlangch.venice.impl.util.excel.Excel;
import com.github.jlangch.venice.util.excel.ExcelFacade;
import com.github.jlangch.venice.util.pdf.HtmlColor;
import java.awt.Color;
import org.apache.poi.ss.usermodel.IndexedColors;

public class ExcelFontBuilder {
    private final ExcelFacade parentBuilder;
    private final Excel managedExcel;
    private final String id;
    private String fontName;
    private Integer heightInPoints;
    private boolean bold;
    private boolean italic;
    private Short colorIndex;
    private Color color;

    public ExcelFontBuilder(ExcelFacade excelBuilder, Excel managedExcel, String id) {
        this.parentBuilder = excelBuilder;
        this.managedExcel = managedExcel;
        this.id = id;
    }

    public ExcelFontBuilder name(String fontName) {
        this.fontName = fontName;
        return this;
    }

    public ExcelFontBuilder heightInPoints(int heightInPoints) {
        this.heightInPoints = heightInPoints;
        return this;
    }

    public ExcelFontBuilder bold() {
        this.bold = true;
        return this;
    }

    public ExcelFontBuilder italic() {
        this.italic = true;
        return this;
    }

    public ExcelFontBuilder color(IndexedColors color) {
        this.colorIndex = color.index;
        return this;
    }

    public ExcelFontBuilder color(short colorIndex) {
        this.colorIndex = colorIndex;
        return this;
    }

    public ExcelFontBuilder color(Color color) {
        this.color = color;
        return this;
    }

    public ExcelFontBuilder colorHtml(String color) {
        this.color = HtmlColor.getColor(color);
        return this;
    }

    public ExcelFacade end() {
        if (this.colorIndex != null) {
            this.managedExcel.registerFont(this.id, this.fontName, this.heightInPoints, this.bold, this.italic, this.colorIndex);
        } else if (this.color != null) {
            this.managedExcel.registerFont(this.id, this.fontName, this.heightInPoints, this.bold, this.italic, this.color);
        } else {
            this.managedExcel.registerFont(this.id, this.fontName, this.heightInPoints, this.bold, this.italic, (Short)null);
        }
        return this.parentBuilder;
    }
}

