/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.xml;

import com.github.jlangch.venice.util.xml.IXMLHandler;
import com.github.jlangch.venice.util.xml.XMLHandler;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUtil {
    public static void parse(InputSource is, boolean namespaceAware, IXMLHandler handler) {
        XMLUtil.parse(is, namespaceAware, new XMLHandler(handler));
    }

    public static void parse(InputStream is, boolean namespaceAware, IXMLHandler handler) {
        XMLUtil.parse(is, namespaceAware, new XMLHandler(handler));
    }

    public static void parse(File f, boolean namespaceAware, IXMLHandler handler) {
        XMLUtil.parse(f, namespaceAware, new XMLHandler(handler));
    }

    public static void parse(String uri, boolean namespaceAware, IXMLHandler handler) {
        XMLUtil.parse(uri, namespaceAware, new XMLHandler(handler));
    }

    public static void parse(InputSource is, boolean namespaceAware, XMLHandler handler) {
        try {
            XMLUtil.newParser(namespaceAware).parse(is, (DefaultHandler)handler);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void parse(InputStream is, boolean namespaceAware, XMLHandler handler) {
        try {
            XMLUtil.newParser(namespaceAware).parse(is, (DefaultHandler)handler);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void parse(File f, boolean namespaceAware, XMLHandler handler) {
        try {
            XMLUtil.newParser(namespaceAware).parse(f, (DefaultHandler)handler);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void parse(String uri, boolean namespaceAware, XMLHandler handler) {
        try {
            XMLUtil.newParser(namespaceAware).parse(uri, (DefaultHandler)handler);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static SAXParser newParser(boolean namespaceAware) throws Exception {
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setFeature("http://xml.org/sax/features/external-general-entities", false);
        f.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        f.setNamespaceAware(namespaceAware);
        return f.newSAXParser();
    }
}

