/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.DynamicInvocationHandler;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncAtom;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.util.Agent;
import com.github.jlangch.venice.impl.util.Delay;
import com.github.jlangch.venice.impl.util.ThreadLocalMap;
import com.github.jlangch.venice.impl.util.ThreadPoolUtil;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class ConcurrencyFunctions {
    public static VncFunction deref = new VncFunction("deref"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(deref x)", "(deref x timeout-ms timeout-val)");
            this.setDoc("Dereferences an atom or a Future object. When applied to an atom, returns its current state. When applied to a future, will block if computation not complete. The variant taking a timeout can be used for futures and will return timeout-val if the timeout (in milliseconds) is reached before a value is available. \nAlso reader macro: @atom/@future/@promise.");
            this.setExamples("(do                             \n   (def counter (atom 10))      \n   (deref counter))               ", "(do                             \n   (def counter (atom 10))      \n   @counter)                      ", "(do                             \n   (def task (fn [] 100))       \n   (let [f (future task)]       \n        (deref f)))               ", "(do                             \n   (def task (fn [] 100))       \n   (let [f (future task)]       \n        @f))                      ", "(do                             \n   (def task (fn [] 100))       \n   (let [f (future task)]       \n        (deref f 300 :timeout)))  ", "(do                                              \n   (def x (delay (println \"working...\") 100))  \n   @x)                                             ");
        }

        @Override
        public VncVal apply(VncList args) {
            block12: {
                FunctionsUtil.assertArity("deref", args, 1, 3);
                if (Types.isVncAtom(args.first())) {
                    VncAtom atm = (VncAtom)args.first();
                    return atm.deref();
                }
                if (Types.isVncJavaObject(args.first())) {
                    Object delegate = ((VncJavaObject)args.first()).getDelegate();
                    if (delegate instanceof Future) {
                        try {
                            Future future = (Future)((VncJavaObject)args.first()).getDelegate();
                            if (args.size() == 1) {
                                return JavaInteropUtil.convertToVncVal(future.get());
                            }
                            long timeout = Coerce.toVncLong(args.nth(1)).getValue();
                            try {
                                return JavaInteropUtil.convertToVncVal(future.get(timeout, TimeUnit.MILLISECONDS));
                            }
                            catch (TimeoutException ex) {
                                return args.nth(2);
                            }
                        }
                        catch (ExecutionException ex) {
                            if (ex.getCause() != null && ex.getCause() instanceof SecurityException) {
                                throw (SecurityException)ex.getCause();
                            }
                            break block12;
                        }
                        catch (Exception ex) {
                            throw new VncException("Failed to deref future", ex);
                        }
                    }
                    if (delegate instanceof Delay) {
                        return ((Delay)delegate).deref();
                    }
                    if (delegate instanceof Agent) {
                        return ((Agent)delegate).deref();
                    }
                }
            }
            throw new VncException(String.format("Function 'deref' does not allow type %s as parameter.", Types.getClassName(args.first())));
        }
    };
    public static VncFunction realized_Q = new VncFunction("realized?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(realized? x)");
            this.setDoc("Returns true if a value has been produced for a promise, delay, or future.");
            this.setExamples("(do                                \n   (def task (fn [] 100))          \n   (let [f (future task)]          \n        (println (realized? f))    \n        (println @f)               \n        (println (realized? f))))    ", "(do                                \n   (def p (promise))               \n   (println (realized? p))         \n   (deliver p 123)                 \n   (println @p)                    \n   (println (realized? p)))          ", "(do                                \n   (def x (delay 100))             \n   (println (realized? x))         \n   (println @x)                    \n   (println (realized? x)))          ");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("realized?", args, 1);
            if (Types.isVncJavaObject(args.first())) {
                Object delegate = ((VncJavaObject)args.first()).getDelegate();
                if (delegate instanceof Future) {
                    return ((Future)delegate).isDone() ? Constants.True : Constants.False;
                }
                if (delegate instanceof CompletableFuture) {
                    return ((CompletableFuture)delegate).isDone() ? Constants.True : Constants.False;
                }
                if (delegate instanceof Delay) {
                    return ((Delay)delegate).isRealized() ? Constants.True : Constants.False;
                }
            }
            return Constants.True;
        }
    };
    public static VncFunction add_watch = new VncFunction("add-watch"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(add-watch ref key fn)");
            this.setDoc("Adds a watch function to an agent/atom reference. The watch fn must be a fn of 4 args: a key, the reference, its old-state, its new-state.");
            this.setExamples("(do                                      \n   (def x (agent 10))                    \n   (defn watcher [key ref old new]       \n         (println \"watcher: \" key))    \n   (add-watch x :test watcher))            ");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("add-watch", args, 3);
            VncVal ref = args.nth(0);
            VncKeyword key = Coerce.toVncKeyword(args.nth(1));
            VncFunction fn = Coerce.toVncFunction(args.nth(2));
            if (Types.isVncJavaObject(ref)) {
                Object delegate = ((VncJavaObject)args.first()).getDelegate();
                if (delegate instanceof Agent) {
                    ((Agent)delegate).addWatch(key, fn);
                    return Constants.Nil;
                }
            } else if (Types.isVncAtom(ref)) {
                ((VncAtom)ref).addWatch(key, fn);
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'add-watch' does not allow type %s as ref.", Types.getClassName(ref)));
        }
    };
    public static VncFunction remove_watch = new VncFunction("remove-watch"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(remove-watch ref key)");
            this.setDoc("Removes a watch function from an agent/atom reference.");
            this.setExamples("(do                                      \n   (def x (agent 10))                    \n   (defn watcher [key ref old new]       \n         (println \"watcher: \" key))    \n   (add-watch x :test watcher)           \n   (remove-watch x :test))                 ");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("remove-watch", args, 2);
            VncVal ref = args.nth(0);
            VncKeyword key = Coerce.toVncKeyword(args.nth(1));
            if (Types.isVncJavaObject(ref)) {
                Object delegate = ((VncJavaObject)args.first()).getDelegate();
                if (delegate instanceof Agent) {
                    ((Agent)delegate).removeWatch(key);
                    return Constants.Nil;
                }
            } else if (Types.isVncAtom(ref)) {
                ((VncAtom)ref).removeWatch(key);
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'remove-watch' does not allow type %s as ref.", Types.getClassName(ref)));
        }
    };
    public static VncFunction new_atom = new VncFunction("atom"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(atom x)");
            this.setDoc("Creates an atom with the initial value x");
            this.setExamples("(do\n   (def counter (atom 0))\n   (deref counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("atom", args, 1);
            return new VncAtom(args.nth(0));
        }
    };
    public static VncFunction atom_Q = new VncFunction("atom?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(atom? x)");
            this.setDoc("Returns true if x is an atom, otherwise false");
            this.setExamples("(do\n   (def counter (atom 0))\n   (atom? counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("atom?", args, 1);
            return Types.isVncAtom(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction reset_BANG = new VncFunction("reset!"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(reset! atom newval)");
            this.setDoc("Sets the value of atom to newval without regard for the current value. Returns newval.");
            this.setExamples("(do\n   (def counter (atom 0))\n   (reset! counter 99)\n   (deref counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reset!", args, 2);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            return atm.reset(args.nth(1));
        }
    };
    public static VncFunction swap_BANG = new VncFunction("swap!"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(swap! atom f & args)");
            this.setDoc("Atomically swaps the value of atom to be: (apply f current-value-of-atom args). Note that f may be called multiple times, and thus should be free of side effects.  Returns the value that was swapped in.");
            this.setExamples("(do\n   (def counter (atom 0))\n   (swap! counter inc)\n   (deref counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("swap!", args, 2);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            VncFunction fn = Coerce.toVncFunction(args.nth(1));
            VncList swapArgs = args.slice(2);
            return atm.swap(fn, swapArgs);
        }
    };
    public static VncFunction compare_and_set_BANG = new VncFunction("compare-and-set!"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(compare-and-set! atom oldval newval)");
            this.setDoc("Atomically sets the value of atom to newval if and only if the current value of the atom is identical to oldval. Returns true if set happened, else false");
            this.setExamples("(do\n   (def counter (atom 2))\n   (compare-and-set! counter 2 4)\n   (deref counter))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("compare-and-set!", args, 3);
            VncAtom atm = Coerce.toVncAtom(args.nth(0));
            return atm.compare_and_set(args.nth(1), args.nth(2));
        }
    };
    public static VncFunction agent = new VncFunction("agent"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(agent state options)");
            this.setDoc("Creates and returns an agent with an initial value of state and zero or more options. \n  :error-handler handler-fn \n  :error-mode mode-keyword \nThe handler-fn is called if an action throws an exception. It's afunction taking two args the agent and the exception. The mode-keyword may be either :continue (the default) or :fail");
            this.setExamples("(do                         \n   (def x (agent 100))      \n   (send x + 5)             \n   (sleep 100)              \n   (deref x))                 ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("agent");
            FunctionsUtil.assertMinArity("agent", args, 1);
            return new VncJavaObject(new Agent(args.nth(0), args.slice(1)));
        }
    };
    public static VncFunction send = new VncFunction("send"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(send agent action-fn args)");
            this.setDoc("Dispatch an action to an agent. Returns the agent immediately.The state of the agent will be set to the value of:\n (apply action-fn state-of-agent args)");
            this.setExamples("(do                         \n   (def x (agent 100))      \n   (send x + 5)             \n   (sleep 100)              \n   (deref x))                 ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("send");
            FunctionsUtil.assertMinArity("send", args, 2);
            if (Types.isVncJavaObject(args.nth(0), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                VncFunction fn = Coerce.toVncFunction(args.nth(1));
                VncList fnArgs = args.slice(2);
                agent.send(fn, fnArgs);
                return args.nth(0);
            }
            throw new VncException(String.format("Function 'send' does not allow type %s as agent parameter", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction send_off = new VncFunction("send-off"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(send-off agent fn args)");
            this.setDoc("Dispatch a potentially blocking action to an agent. Returns the agent immediately. The state of the agent will be set to the value of:\n (apply action-fn state-of-agent args)");
            this.setExamples("(do                         \n   (def x (agent 100))      \n   (send-off x + 5)         \n   (sleep 100)              \n   (deref x))                 ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("send-off");
            FunctionsUtil.assertArity("send-off", args, 3);
            if (Types.isVncJavaObject(args.nth(0), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                VncFunction fn = Coerce.toVncFunction(args.nth(1));
                VncList fnArgs = args.slice(2);
                agent.send_off(fn, fnArgs);
                return args.nth(0);
            }
            throw new VncException(String.format("Function 'send-off' does not allow type %s as agent parameter", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction restart_agent = new VncFunction("restart-agent"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(restart-agent agent state)");
            this.setDoc("When an agent is failed, changes the agent state to new-state and then un-fails the agent so that sends are allowed again.");
            this.setExamples("(do                          \n   (def x (agent 100))       \n   (restart-agent x 200)     \n   (deref x))                  ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("restart-agent");
            FunctionsUtil.assertArity("restart-agent", args, 2);
            if (Types.isVncJavaObject(args.nth(0), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                VncVal state = args.nth(1);
                agent.restart(state);
                return args.nth(0);
            }
            throw new VncException(String.format("Function 'restart-agent' does not allow type %s as agent parameter", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction set_error_handler = new VncFunction("set-error-handler!"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(set-error-handler! agent handler-fn)");
            this.setDoc("Sets the error-handler of an agent to handler-fn. If an action being run by the agent throws an exception handler-fn will be called with two arguments: the agent and the exception.");
            this.setExamples("(do                                          \n   (def x (agent 100))                       \n   (defn err-handler-fn [ag ex]              \n      (println \"error occured: \"           \n               (:message ex)                 \n               \" and we still have value\"  \n               @ag))                         \n   (set-error-handler! x err-handler-fn)     \n   (send x (fn [n] (/ n 0))))                  ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("set-error-handler!");
            FunctionsUtil.assertArity("set-error-handler!", args, 2);
            if (Types.isVncJavaObject(args.nth(0), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                agent.setErrorHandler(Coerce.toVncFunction(args.nth(1)));
                return args.nth(0);
            }
            throw new VncException(String.format("Function 'set-error-handler!' does not allow type %s as agent parameter", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction agent_error = new VncFunction("agent-error"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(agent-error agent)");
            this.setDoc("Returns the exception thrown during an asynchronous action of the agent if the agent is failed. Returns nil if the agent is not failed.");
            this.setExamples("(do                                              \n   (def x (agent 100 :error-mode :fail))         \n   (send x (fn [n] (/ n 0)))                     \n   (sleep 500)                                   \n   (agent-error x))                                ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("agent-error");
            FunctionsUtil.assertArity("agent-error", args, 1);
            if (Types.isVncJavaObject(args.nth(0), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                RuntimeException ex = agent.getError();
                return ex == null ? Constants.Nil : new VncJavaObject(ex);
            }
            throw new VncException(String.format("Function 'agent-error' does not allow type %s as agent parameter", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction agent_error_mode = new VncFunction("agent-error-mode"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(agent-error-mode agent)");
            this.setDoc("Returns the agent's error mode");
            this.setExamples("(do                                              \n   (def x (agent 100 :error-mode :fail))         \n   (agent-mode x))                                 ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("agent-error-mode");
            FunctionsUtil.assertArity("agent-error-mode", args, 1);
            if (Types.isVncJavaObject(args.nth(0), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.nth(0)).getDelegate();
                return agent.getErrorMode();
            }
            throw new VncException(String.format("Function 'agent-error-mode' does not allow type %s as agent parameter", Types.getClassName(args.nth(0))));
        }
    };
    public static VncFunction await = new VncFunction("await"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(await agents)");
            this.setDoc("Blocks the current thread (indefinitely) until all actions dispatched thus far (from this thread or agent) to the agents have occurred. ");
            this.setExamples("(do                           \n   (def x1 (agent 100))       \n   (def x2 (agent 100))       \n   (await x1 x2))               ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("await");
            FunctionsUtil.assertMinArity("await", args, 1);
            List<Agent> agents = args.getList().stream().map(a -> (Agent)Coerce.toVncJavaObject(a).getDelegate()).collect(Collectors.toList());
            return agents.isEmpty() ? Constants.True : (Agent.await(agents, -1L) ? Constants.True : Constants.False);
        }
    };
    public static VncFunction await_for = new VncFunction("await-for"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(await-for timeout-ms agents)");
            this.setDoc("Blocks the current thread until all actions dispatched thus far (from this thread or agent) to the agents have occurred, or the timeout (in milliseconds) has elapsed. Returns logical false if returning due to timeout, logical true otherwise.");
            this.setExamples("(do                           \n   (def x1 (agent 100))       \n   (def x2 (agent 100))       \n   (await-for 500 x1 x2))       ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("await-for");
            FunctionsUtil.assertMinArity("await-for", args, 2);
            long timeoutMillis = Coerce.toVncLong(args.nth(0)).getValue();
            List<Agent> agents = args.slice(1).getList().stream().map(a -> (Agent)Coerce.toVncJavaObject(a).getDelegate()).collect(Collectors.toList());
            return agents.isEmpty() ? Constants.True : (Agent.await(agents, timeoutMillis) ? Constants.True : Constants.False);
        }
    };
    public static VncFunction shutdown_agents = new VncFunction("shutdown-agents"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(shutdown-agents )");
            this.setDoc("Initiates a shutdown of the thread pools that back the agent system. Running actions will complete, but no new actions will been accepted");
            this.setExamples("(do                           \n   (def x1 (agent 100))       \n   (def x2 (agent 100))       \n   (shutdown-agents ))          ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("shutdown-agents");
            FunctionsUtil.assertArity("shutdown-agents", args, 0);
            Agent.shutdown();
            return Constants.Nil;
        }
    };
    public static VncFunction shutdown_agents_Q = new VncFunction("shutdown-agents?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(shutdown-agents?)");
            this.setDoc("Returns true if the thread-pool that backs the agents is shut down");
            this.setExamples("(do                           \n   (def x1 (agent 100))       \n   (def x2 (agent 100))       \n   (shutdown-agents )         \n   (sleep 300)                \n   (shutdown-agents? ))         ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("shutdown-agents?");
            FunctionsUtil.assertArity("shutdown-agents?", args, 0);
            return Agent.isShutdown() ? Constants.True : Constants.False;
        }
    };
    public static VncFunction await_termination_agents = new VncFunction("await-termination-agents"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(shutdown-agents )");
            this.setDoc("Blocks until all actions have completed execution after a shutdown request, or the timeout occurs, or the current thread is interrupted, whichever happens first.");
            this.setExamples("(do                                   \n   (def x1 (agent 100))               \n   (def x2 (agent 100))               \n   (shutdown-agents )                 \n   (await-termination-agents 1000))     ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("await-termination-agents");
            FunctionsUtil.assertArity("await-termination-agents", args, 1);
            long timeoutMillis = Coerce.toVncLong(args.nth(0)).getValue();
            Agent.awaitTermination(timeoutMillis);
            return Constants.Nil;
        }
    };
    public static VncFunction await_termination_agents_Q = new VncFunction("await-termination-agents?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(await-termination-agents?)");
            this.setDoc("Returns true if all tasks have been completed following agent shut down");
            this.setExamples("(do                                  \n   (def x1 (agent 100))              \n   (def x2 (agent 100))              \n   (shutdown-agents )                \n   (await-termination-agents 1000))  \n   (sleep 300)                       \n   (await-termination-agents? ))      ");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("await-termination-agents?");
            FunctionsUtil.assertArity("await-termination-agents?", args, 0);
            return Agent.isShutdown() ? Constants.True : Constants.False;
        }
    };
    public static VncFunction deliver = new VncFunction("deliver"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(deliver ref value)");
            this.setDoc("Delivers the supplied value to the promise, releasing any pending derefs. A subsequent call to deliver on a promise will have no effect.");
            this.setExamples("(do                   \n   (def p (promise))  \n   (deliver p 123))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("deliver");
            FunctionsUtil.assertArity("deliver", args, 2);
            Object promise = Coerce.toVncJavaObject(args.first()).getDelegate();
            VncVal value = args.second();
            if (promise instanceof CompletableFuture) {
                ((CompletableFuture)promise).complete(value);
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'deliver' does not allow type %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction promise = new VncFunction("promise"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(promise)");
            this.setDoc("Returns a promise object that can be read with deref, and set, once only, with deliver. Calls to deref prior to delivery will block, unless the variant of deref with timeout is used. All subsequent derefs will return the same delivered value without blocking.");
            this.setExamples("(do                                        \n   (def p (promise))                       \n   (def task (fn []                        \n                 (do                       \n                    (sleep 500)            \n                    (deliver p 123))))     \n                                           \n   (future task)                           \n   (deref p))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("promise");
            FunctionsUtil.assertArity("promise", args, 0);
            return new VncJavaObject(new CompletableFuture());
        }
    };
    public static VncFunction promise_Q = new VncFunction("promise?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(promise? p)");
            this.setDoc("Returns true if f is a Promise otherwise false");
            this.setExamples("(promise? (promise)))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("promise?");
            FunctionsUtil.assertArity("promise?", args, 1);
            return Types.isVncJavaObject(args.first(), CompletableFuture.class) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction future = new VncFunction("future"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(future fn)");
            this.setDoc("Takes a function and yields a future object that will invoke the function in another thread, and will cache the result and return it on all subsequent calls to deref. If the computation has not yet finished, calls to deref will block, unless the variant of deref with timeout is used.");
            this.setExamples("(do                                         \n   (def wait (fn [] (do (sleep 500) 100)))  \n                                            \n   (let [f (future wait)]                   \n        (deref f))                          \n)");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("future");
            FunctionsUtil.assertArity("future", args, 1);
            final VncFunction fn = Coerce.toVncFunction(args.first());
            VncFunction wrapped = new VncFunction(){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    return new VncJavaObject(fn.apply(args));
                }
            };
            Callable task = (Callable)DynamicInvocationHandler.proxify(Callable.class, new VncHashMap(new VncKeyword("call"), wrapped));
            IInterceptor parentInterceptor = JavaInterop.getInterceptor();
            Callable<Object> taskWrapper = () -> {
                try {
                    ThreadLocalMap.clearCallStack();
                    JavaInterop.register(parentInterceptor);
                    Object v = task.call();
                    return v;
                }
                finally {
                    JavaInterop.unregister();
                    ThreadLocalMap.remove();
                }
            };
            Future<Object> future = executor.submit(taskWrapper);
            return new VncJavaObject(future);
        }
    };
    public static VncFunction future_Q = new VncFunction("future?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(future? f)");
            this.setDoc("Returns true if f is a Future otherwise false");
            this.setExamples("(future? (future (fn [] 100)))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("future?");
            FunctionsUtil.assertArity("future?", args, 1);
            return Types.isVncJavaObject(args.first(), Future.class) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction future_done_Q = new VncFunction("future-done?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(future-done? f)");
            this.setDoc("Returns true if f is a Future is done otherwise false");
            this.setExamples("(future-done? (future (fn [] 100)))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("future-done?");
            FunctionsUtil.assertArity("future-done?", args, 1);
            if (Types.isVncJavaObject(args.first(), Future.class)) {
                try {
                    Future future = (Future)((VncJavaObject)args.first()).getDelegate();
                    return future.isDone() ? Constants.True : Constants.False;
                }
                catch (Exception ex) {
                    throw new VncException("Failed to check if future is done", ex);
                }
            }
            throw new VncException(String.format("Function 'future-done?' does not allow type %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction future_cancel = new VncFunction("future-cancel"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(future-cancel f)");
            this.setDoc("Cancels the future");
            this.setExamples("(future-cancel (future (fn [] 100)))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("future-cancel");
            FunctionsUtil.assertArity("future-cancel", args, 1);
            if (Types.isVncJavaObject(args.first(), Future.class)) {
                try {
                    Future future = (Future)((VncJavaObject)args.first()).getDelegate();
                    future.cancel(true);
                    return args.first();
                }
                catch (Exception ex) {
                    throw new VncException("Failed to cancel future", ex);
                }
            }
            throw new VncException(String.format("Function 'future-cancel' does not allow type %s as parameter.", Types.getClassName(args.first())));
        }
    };
    public static VncFunction future_cancelled_Q = new VncFunction("future-cancelled?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(future-cancelled? f)");
            this.setDoc("Returns true if f is a Future is cancelled otherwise false");
            this.setExamples("(future-cancelled? (future (fn [] 100)))");
        }

        @Override
        public VncVal apply(VncList args) {
            JavaInterop.getInterceptor().validateBlackListedVeniceFunction("future-cancelled?");
            FunctionsUtil.assertArity("future-cancelled?", args, 1);
            if (Types.isVncJavaObject(args.first(), Future.class)) {
                try {
                    Future future = (Future)((VncJavaObject)args.first()).getDelegate();
                    return future.isCancelled() ? Constants.True : Constants.False;
                }
                catch (Exception ex) {
                    throw new VncException("Failed to check if future is cancelled", ex);
                }
            }
            throw new VncException(String.format("Function 'future-cancelled?' does not allow type %s as parameter", Types.getClassName(args.first())));
        }
    };
    public static VncFunction delay_Q = new VncFunction("delay?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(delay? x)");
            this.setDoc("Returns true if x is a Delay created with delay");
            this.setExamples("(do                                              \n   (def x (delay (println \"working...\") 100))  \n   (delay? x))                                     ");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("delay?", args, 1);
            return Types.isVncJavaObject(args.first(), Delay.class) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction force = new VncFunction("force"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(force x)");
            this.setDoc("If x is a Delay, returns its value, else returns x");
            this.setExamples("(do                                              \n   (def x (delay (println \"working...\") 100))  \n   (force x))                                      ");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("force", args, 1);
            if (Types.isVncJavaObject(args.first(), Delay.class)) {
                Delay delay = (Delay)((VncJavaObject)args.first()).getDelegate();
                return delay.deref();
            }
            return args.first();
        }
    };
    public static VncFunction new_thread_local = new VncFunction("thread-local"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(thread-local)");
            this.setDoc("Creates a new thread-local accessor");
            this.setExamples("(thread-local :a 1 :b 2)", "(thread-local { :a 1 :b 2 })", "(do \n   (thread-local-clear) \n   (assoc (thread-local) :a 1 :b 2) \n   (dissoc (thread-local) :a) \n   (get (thread-local) :b 100) \n)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.nth(0))) {
                return new VncThreadLocal(((VncMap)args.nth(0)).getMap());
            }
            return new VncThreadLocal(args);
        }
    };
    public static VncFunction thread_local_Q = new VncFunction("thread-local?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(thread-local? x)");
            this.setDoc("Returns true if x is a thread-local, otherwise false");
            this.setExamples("(do\n   (def x (thread-local))\n   (thread-local? x))");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-local?", args, 1);
            return Types.isVncThreadLocal(args.nth(0)) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction thread_local_clear = new VncFunction("thread-local-clear"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(thread-local-clear)");
            this.setDoc("Removes all thread local vars");
            this.setExamples("(thread-local-clear)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-local-clear", args, 0);
            new VncThreadLocal().clear();
            return this;
        }
    };
    public static VncFunction thread_id = new VncFunction("thread-id"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(thread-id)");
            this.setDoc("Returns the identifier of this Thread. The thread ID is a positive number generated when this thread was created. The thread ID  is unique and remains unchanged during its lifetime. When a thread is terminated, this thread ID may be reused.");
            this.setExamples("(thread-id)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-id", args, 0);
            return new VncLong(Thread.currentThread().getId());
        }
    };
    public static VncFunction thread_name = new VncFunction("thread-name"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(thread-name)");
            this.setDoc("Returns this thread's name.");
            this.setExamples("(thread-name)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-name", args, 0);
            return new VncString(Thread.currentThread().getName());
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("deref", (VncVal)deref).put("realized?", (VncVal)realized_Q).put("add-watch", (VncVal)add_watch).put("remove-watch", (VncVal)remove_watch).put("atom", (VncVal)new_atom).put("atom?", (VncVal)atom_Q).put("reset!", (VncVal)reset_BANG).put("swap!", (VncVal)swap_BANG).put("compare-and-set!", (VncVal)compare_and_set_BANG).put("agent", (VncVal)agent).put("send", (VncVal)send).put("send-off", (VncVal)send_off).put("restart-agent", (VncVal)restart_agent).put("set-error-handler!", (VncVal)set_error_handler).put("agent-error", (VncVal)agent_error).put("agent-error-mode", (VncVal)agent_error_mode).put("await", (VncVal)await).put("await-for", (VncVal)await_for).put("shutdown-agents", (VncVal)shutdown_agents).put("shutdown-agents?", (VncVal)shutdown_agents_Q).put("await-termination-agents", (VncVal)await_termination_agents).put("await-termination-agents?", (VncVal)await_termination_agents_Q).put("promise", (VncVal)promise).put("promise?", (VncVal)promise_Q).put("deliver", (VncVal)deliver).put("future", (VncVal)future).put("future?", (VncVal)future_Q).put("future-done?", (VncVal)future_done_Q).put("future-cancel", (VncVal)future_cancel).put("future-cancelled?", (VncVal)future_cancelled_Q).put("delay?", (VncVal)delay_Q).put("force", (VncVal)force).put("thread-id", (VncVal)thread_id).put("thread-name", (VncVal)thread_name).put("thread-local", (VncVal)new_thread_local).put("thread-local?", (VncVal)thread_local_Q).put("thread-local-clear", (VncVal)thread_local_clear).toMap();
    private static final AtomicLong futureThreadPoolCounter = new AtomicLong(0L);
    private static final ExecutorService executor = Executors.newCachedThreadPool(ThreadPoolUtil.createThreadFactory("venice-future-pool-%d", futureThreadPoolCounter, true));

    public static void shutdown() {
        executor.shutdown();
    }

    public static void shutdownNow() {
        executor.shutdownNow();
    }
}

