/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class VncJavaList
extends VncSequence
implements IVncJavaObject {
    private static final long serialVersionUID = -1848883965231344442L;
    private final List<Object> value;

    public VncJavaList(List<Object> val) {
        this.value = val;
    }

    @Override
    public Object getDelegate() {
        return this.value;
    }

    public void forEach(Consumer<? super VncVal> action) {
        this.value.forEach((? super T v) -> action.accept(JavaInteropUtil.convertToVncVal(v)));
    }

    @Override
    public VncList copy() {
        VncList v = new VncList(this.getList());
        v.setMeta(this.getMeta());
        return v;
    }

    @Override
    public List<VncVal> getList() {
        return this.value.stream().map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList());
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.value.size()) {
            throw new VncException("nth: index out of range");
        }
        return JavaInteropUtil.convertToVncVal(this.value.get(idx));
    }

    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        return idx >= 0 && idx < this.value.size() ? this.nth(idx) : defaultVal;
    }

    public VncVal first() {
        return this.isEmpty() ? Constants.Nil : this.nth(0);
    }

    public VncVal second() {
        return this.size() < 2 ? Constants.Nil : this.nth(1);
    }

    public VncVal last() {
        return this.isEmpty() ? Constants.Nil : this.nth(this.value.size() - 1);
    }

    public VncList rest() {
        if (this.isEmpty()) {
            return new VncList(new VncVal[0]);
        }
        return new VncList(this.value.subList(1, this.value.size()).stream().map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList()));
    }

    public VncList slice(int start, int end) {
        return new VncList(this.value.subList(start, end).stream().map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList()));
    }

    public VncList slice(int start) {
        return this.slice(start, this.value.size());
    }

    @Override
    public VncList empty() {
        return new VncList(new VncVal[0]);
    }

    public VncVector toVncVector() {
        return new VncVector(this.getList());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.getList());
    }

    public VncSet toVncSet() {
        return new VncSet(this.toVncList());
    }

    public VncJavaList addAtStart(VncVal val) {
        this.value.add(0, JavaInteropUtil.convertToJavaObject(val));
        return this;
    }

    public VncJavaList addAtStart(VncJavaList list) {
        List<VncVal> items = list.getList();
        for (int ii = items.size() - 1; ii >= 0; ++ii) {
            this.value.add(0, JavaInteropUtil.convertToJavaObject(items.get(ii)));
        }
        return this;
    }

    public VncJavaList addAtEnd(VncVal val) {
        this.value.add(JavaInteropUtil.convertToJavaObject(val));
        return this;
    }

    public VncJavaList addAtEnd(VncList list) {
        list.getList().forEach((? super T v) -> this.value.add(JavaInteropUtil.convertToJavaObject(v)));
        return this;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncList(o)) {
            for (int ii = 0; ii < Math.min(this.size(), ((VncJavaList)o).size()); ++ii) {
                int c = this.nth(ii).compareTo(((VncJavaList)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncJavaList other = (VncJavaList)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "(" + Printer.join(this.getList(), " ", true) + ")";
    }

    @Override
    public String toString(boolean print_readably) {
        return "(" + Printer.join(this.getList(), " ", print_readably) + ")";
    }
}

