/*   __    __         _
 *   \ \  / /__ _ __ (_) ___ ___ 
 *    \ \/ / _ \ '_ \| |/ __/ _ \
 *     \  /  __/ | | | | (_|  __/
 *      \/ \___|_| |_|_|\___\___|
 *
 *
 * Copyright 2017-2019 Venice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.jlangch.venice.util;

import com.github.jlangch.venice.impl.util.StopWatch;


public class ScriptElapsedTime {

	public void loadDone() {
		loadElapsedNanos = sw.splitTime();
	}

	public void readDone() {
		readElapsedNanos = sw.splitTime() - loadElapsedNanos;
	}

	public void evalDone() {
		evalElapsedNanos = sw.splitTime() - readElapsedNanos - loadElapsedNanos;
	}

	public long getLoadElapsedNanos() {
		return loadElapsedNanos;
	}
	
	public long getReadElapsedNanos() {
		return readElapsedNanos;
	}
	
	public long getEvalElapsedNanos() {
		return evalElapsedNanos;
	}
	

	@Override
	public String toString() {
		return String.format(
				"Elapsed: load: %s, read: %s, eval: %s", 
				StopWatch.formatNanos(loadElapsedNanos), 
				StopWatch.formatNanos(readElapsedNanos), 
				StopWatch.formatNanos(evalElapsedNanos));
	}

	
	final StopWatch sw = StopWatch.nanos();
	
	private long loadElapsedNanos = -1L;	
	private long readElapsedNanos = -1L;	
	private long evalElapsedNanos = -1L;
}
