/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.Readline;
import com.github.jlangch.venice.impl.ValueException;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.FileUtil;
import com.github.jlangch.venice.impl.util.ThreadLocalMap;
import com.github.jlangch.venice.util.CommandLineArgs;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;

public class REPL {
    private static final String PROMPT = "venice> ";

    public static void main(String[] args) {
        CommandLineArgs cli = new CommandLineArgs(args);
        if (cli.switchPresent("-file") || cli.switchPresent("-script")) {
            REPL.exec(cli);
        } else {
            REPL.repl(args);
        }
    }

    private static void repl(String[] args) {
        VeniceInterpreter venice = new VeniceInterpreter();
        VncList argv = REPL.toList(args);
        Env env = venice.createEnv();
        env.setGlobal(new Var(new VncSymbol("*ARGV*"), argv));
        while (true) {
            String line;
            try {
                while ((line = Readline.readline(PROMPT)) == null) {
                }
            }
            catch (EofException e) {
                break;
            }
            catch (VncException e) {
                e.printVeniceStackTrace();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
            try {
                ThreadLocalMap.clearCallStack();
                System.out.println("=> " + venice.PRINT(venice.RE(line, "repl", env, null)));
            }
            catch (ContinueException e) {
            }
            catch (ValueException e) {
                System.out.println(e.getMessage());
                System.out.println("Value: " + Printer._pr_str(e.getValue(), false));
            }
            catch (VncException e) {
                e.printVeniceStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void exec(CommandLineArgs cli) {
        VncList argv = REPL.toList(cli.args());
        VeniceInterpreter venice = new VeniceInterpreter();
        Env env = venice.createEnv();
        env.setGlobal(new Var(new VncSymbol("*ARGV*"), argv));
        if (cli.switchPresent("-file")) {
            String file = cli.switchValue("-file");
            String script = new String(FileUtil.load(new File(file)));
            System.out.println(venice.PRINT(venice.RE(script, new File(file).getName(), env, null)));
        } else if (cli.switchPresent("-script")) {
            String script = cli.switchValue("-script");
            System.out.println(venice.PRINT(venice.RE(script, "script", env, null)));
        }
    }

    private static VncList toList(String[] args) {
        return new VncList(Arrays.asList(args).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
    }
}

