/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.DynamicVar;
import com.github.jlangch.venice.impl.Symbols;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.util.CallFrameBuilder;
import com.github.jlangch.venice.impl.util.ThreadLocalMap;
import java.io.Serializable;

public class Env
implements Serializable {
    private static final long serialVersionUID = 9002640180394221858L;
    private final Env outer;
    private final int level;
    private final Symbols globalSymbols;
    private final Symbols symbols = new Symbols();

    public Env() {
        this(null);
    }

    public Env(Env outer) {
        this.outer = outer;
        this.level = outer == null ? 0 : outer.level() + 1;
        this.globalSymbols = outer == null ? new Symbols() : outer.globalSymbols;
    }

    public Env findEnv(VncSymbol key) {
        if (this.symbols.contains(key)) {
            return this;
        }
        if (this.outer != null) {
            return this.outer.findEnv(key);
        }
        if (this.globalSymbols.contains(key)) {
            return this;
        }
        return null;
    }

    public VncVal get(VncSymbol key) {
        Env e = this.findEnv(key);
        if (e == null) {
            ThreadLocalMap.getCallStack().push(CallFrameBuilder.fromVal(key));
            throw new VncException(String.format("Symbol '" + key.getName() + "' not found.", new Object[0]));
        }
        if (e.symbols.contains(key)) {
            return e.symbols.get(key).getVal();
        }
        if (this.globalSymbols.contains(key)) {
            Var v = this.globalSymbols.get(key);
            return v instanceof DynamicVar ? ((DynamicVar)v).peekVal(key) : v.getVal();
        }
        ThreadLocalMap.getCallStack().push(CallFrameBuilder.fromVal(key));
        throw new VncException(String.format("Symbol '" + key.getName() + "' not found.", new Object[0]));
    }

    public int level() {
        return this.level;
    }

    public Env set(VncSymbol name, VncVal val) {
        this.symbols.set(new Var(name, val));
        return this;
    }

    public Env setGlobal(Var val) {
        Var v = this.globalSymbols.get(val.getName());
        if (v != null && !v.isOverwritable()) {
            ThreadLocalMap.getCallStack().push(CallFrameBuilder.fromVal(val.getName()));
            throw new VncException(String.format("The existing var %s must not overwritten!", val.getName()));
        }
        this.globalSymbols.set(val);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Env pushGlobalDynamic(Var val) {
        Var dv = this.globalSymbols.get(val.getName());
        if (dv == null) {
            DynamicVar nv = new DynamicVar(val.getName(), Constants.Nil);
            this.globalSymbols.set(nv);
            nv.pushVal(val.getVal());
            return this;
        }
        if (dv instanceof DynamicVar) {
            ((DynamicVar)dv).pushVal(val.getVal());
            return this;
        }
        ThreadLocalMap.getCallStack().push(CallFrameBuilder.fromVal(val.getName()));
        throw new VncException(String.format("The var %s is not defined as dynamic", val.getName()));
    }

    public VncVal popGlobalDynamic(VncSymbol sym) {
        Var dv = this.globalSymbols.get(sym);
        if (dv != null) {
            if (dv instanceof DynamicVar) {
                return ((DynamicVar)dv).popVal(sym);
            }
            ThreadLocalMap.getCallStack().push(CallFrameBuilder.fromVal(sym));
            throw new VncException(String.format("The var %s is not defined as dynamic", sym.getName()));
        }
        return Constants.Nil;
    }

    public VncVal peekGlobalDynamic(VncSymbol sym) {
        Var dv = this.globalSymbols.get(sym);
        if (dv != null) {
            if (dv instanceof DynamicVar) {
                return ((DynamicVar)dv).peekVal(sym);
            }
            ThreadLocalMap.getCallStack().push(CallFrameBuilder.fromVal(sym));
            throw new VncException(String.format("The var %s is not defined as dynamic", sym.getName()));
        }
        return Constants.Nil;
    }

    public boolean hasGlobalSymbol(VncSymbol key) {
        return this.globalSymbols.contains(key);
    }

    public Env getRootEnv() {
        Env env = this;
        while (env.outer != null) {
            env = env.outer;
        }
        return env;
    }

    public String toString() {
        return String.format("level %d: %s\n\nglobal: %s", this.level, this.symbols, this.globalSymbols);
    }
}

