/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.ParseError;
import com.github.jlangch.venice.impl.AnonymousFnArgs;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.Token;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Reader {
    private static final Pattern atom_pattern = Pattern.compile("(?s)(^-?[0-9]+$)|(^-?[0-9][0-9.]*$)|(^-?[0-9][0-9.]*M$)|(^nil$)|(^true$)|(^false$)|^\"{3}(.*)\"{3}$|^\"(.*)\"$|:(.*)|(^[^\"]*$)");
    private static final Pattern tokenize_pattern = Pattern.compile("[\\s ,]*(~@|[\\[\\]{}()'`~@]|\"{3}(?:[\\s\\S]*?)\"{3}|\"(?:[\\\\].|[^\\\\\"])*\"|;.*|[^\\s \\[\\]{}()'\"`~@,;]*)");
    private final String filename;
    private final String form;
    private ArrayList<Token> tokens;
    private int position;
    private final AnonymousFnArgs anonymousFnArgs = new AnonymousFnArgs();

    private Reader(String filename, String form, ArrayList<Token> formTokens) {
        this.filename = filename;
        this.form = form;
        this.tokens = formTokens;
        this.position = 0;
    }

    public static Reader reader(String str, String filename) {
        return new Reader(filename, str, Reader.tokenize(str, filename));
    }

    public static VncVal read_str(String str, String filename) {
        return Reader.read_form(Reader.reader(str, filename));
    }

    public String unprocessedRest() {
        return this.lastReadPos() < 0 ? this.form : this.form.substring(this.lastReadPos());
    }

    public int lastReadPos() {
        return this.position == 0 ? -1 : this.tokens.get(this.position - 1).getFileEndPos();
    }

    public String toString() {
        return this.tokens.stream().map(t -> String.format("%-8s %s", String.format("%d,%d:", t.getLine(), t.getColumn()), t.getToken())).collect(Collectors.joining("\n"));
    }

    private Token peek() {
        return this.position >= this.tokens.size() ? null : this.tokens.get(this.position);
    }

    private Token next() {
        return this.tokens.get(this.position++);
    }

    public static ArrayList<Token> tokenize(String str, String filename) {
        char[] strArr = str.toCharArray();
        Matcher matcher = tokenize_pattern.matcher(str);
        int[] lastPos = new int[]{1, 1};
        int lastStartPos = 0;
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (matcher.find()) {
            String token = matcher.group(1);
            if (token == null || token.equals("") || token.charAt(0) == ';') continue;
            int tokenStartPos = matcher.start(1);
            int[] pos = Reader.getTextPosition(strArr, tokenStartPos, lastStartPos, lastPos[0], lastPos[1]);
            tokens.add(new Token(token, filename, tokenStartPos, pos[0], pos[1]));
            lastStartPos = tokenStartPos;
            lastPos = pos;
        }
        return tokens;
    }

    private static VncVal read_atom(Reader rdr) {
        Token token = rdr.next();
        Matcher matcher = atom_pattern.matcher(token.getToken());
        if (!matcher.find()) {
            throw new ParseError(String.format("Unrecognized token '%s'. %s", token.getToken(), ErrorMessage.buildErrLocation(token)));
        }
        if (matcher.group(1) != null) {
            return MetaUtil.withTokenPos(new VncLong(Long.parseLong(matcher.group(1))), token);
        }
        if (matcher.group(2) != null) {
            return MetaUtil.withTokenPos(new VncDouble(Double.parseDouble(matcher.group(2))), token);
        }
        if (matcher.group(3) != null) {
            String dec = matcher.group(3);
            dec = dec.substring(0, dec.length() - 1);
            return MetaUtil.withTokenPos(new VncBigDecimal(new BigDecimal(dec)), token);
        }
        if (matcher.group(4) != null) {
            return Constants.Nil;
        }
        if (matcher.group(5) != null) {
            return Constants.True;
        }
        if (matcher.group(6) != null) {
            return Constants.False;
        }
        if (matcher.group(7) != null) {
            String s = Reader.unescapeAndDecodeUnicode(matcher.group(7));
            return MetaUtil.withTokenPos(Reader.interpolate(s, rdr.filename), token);
        }
        if (matcher.group(8) != null) {
            String s = Reader.unescapeAndDecodeUnicode(matcher.group(8));
            return MetaUtil.withTokenPos(Reader.interpolate(s, rdr.filename), token);
        }
        if (matcher.group(9) != null) {
            return MetaUtil.withTokenPos(new VncKeyword(matcher.group(9)), token);
        }
        if (matcher.group(10) != null) {
            VncSymbol sym = new VncSymbol(matcher.group(10));
            rdr.anonymousFnArgs.addSymbol(sym);
            return MetaUtil.withTokenPos(sym, token);
        }
        throw new ParseError(String.format("Unrecognized '%s'. %s", matcher.group(0), ErrorMessage.buildErrLocation(token)));
    }

    private static VncList read_list(Reader rdr, VncList lst, char start, char end) {
        Token lstToken = rdr.next();
        MetaUtil.withTokenPos(lst, lstToken);
        if (lstToken.charAt(0) != start) {
            throw new ParseError(String.format("Expected '%s'. %s", Character.valueOf(start), ErrorMessage.buildErrLocation(lstToken)));
        }
        Token token = lstToken;
        while ((token = rdr.peek()) != null && token.charAt(0) != end) {
            lst.addAtEnd(Reader.read_form(rdr));
        }
        if (token == null) {
            throw new ParseError(String.format("Expected '" + end + "', got EOF. %s", ErrorMessage.buildErrLocation(lstToken)));
        }
        rdr.next();
        return lst;
    }

    private static VncHashMap read_hash_map(Reader rdr) {
        Token refToken = rdr.peek();
        VncList lst = Reader.read_list(rdr, new VncList(new VncVal[0]), '{', '}');
        return (VncHashMap)MetaUtil.withTokenPos(new VncHashMap(lst), refToken);
    }

    private static VncVal read_form(Reader rdr) {
        VncVal form;
        Token token = rdr.peek();
        if (token == null) {
            throw new ContinueException();
        }
        switch (token.charAt(0)) {
            case '\'': {
                rdr.next();
                return MetaUtil.withTokenPos(new VncList(new VncSymbol("quote"), Reader.read_form(rdr)), token);
            }
            case '`': {
                rdr.next();
                return MetaUtil.withTokenPos(new VncList(new VncSymbol("quasiquote"), Reader.read_form(rdr)), token);
            }
            case '~': {
                if (token.equals("~")) {
                    rdr.next();
                    return MetaUtil.withTokenPos(new VncList(new VncSymbol("unquote"), Reader.read_form(rdr)), token);
                }
                rdr.next();
                return MetaUtil.withTokenPos(new VncList(new VncSymbol("splice-unquote"), Reader.read_form(rdr)), token);
            }
            case '^': {
                rdr.next();
                VncVal meta = Reader.read_form(rdr);
                return MetaUtil.withTokenPos(new VncList(new VncSymbol("with-meta"), Reader.read_form(rdr), meta), token);
            }
            case '@': {
                rdr.next();
                return MetaUtil.withTokenPos(new VncList(new VncSymbol("deref"), Reader.read_form(rdr)), token);
            }
            case '#': {
                rdr.next();
                Token t = rdr.peek();
                if (t.charAt(0) == '{') {
                    form = new VncSet(Reader.read_list(rdr, new VncList(new VncVal[0]), '{', '}'));
                    break;
                }
                if (t.charAt(0) == '(') {
                    if (rdr.anonymousFnArgs.isCapturing()) {
                        throw new ParseError(String.format(" #() forms cannot be nested. %s", ErrorMessage.buildErrLocation(t)));
                    }
                    rdr.anonymousFnArgs.startCapture();
                    VncList body = Reader.read_list(rdr, new VncList(new VncVal[0]), '(', ')');
                    VncVector argsDef = rdr.anonymousFnArgs.buildArgDef();
                    form = new VncList(new VncSymbol("fn"), argsDef, body);
                    rdr.anonymousFnArgs.stopCapture();
                    break;
                }
                throw new ParseError(String.format("Expected '{' or '('. %s", ErrorMessage.buildErrLocation(t)));
            }
            case '(': {
                form = Reader.read_list(rdr, new VncList(new VncVal[0]), '(', ')');
                break;
            }
            case ')': {
                throw new ParseError(String.format("Unexpected ')'. %s", ErrorMessage.buildErrLocation(token)));
            }
            case '[': {
                form = Reader.read_list(rdr, new VncVector(new VncVal[0]), '[', ']');
                break;
            }
            case ']': {
                throw new ParseError(String.format("Unexpected ']'. %s", ErrorMessage.buildErrLocation(token)));
            }
            case '{': {
                form = Reader.read_hash_map(rdr);
                break;
            }
            case '}': {
                throw new ParseError(String.format("Unexpected '}'. %s", ErrorMessage.buildErrLocation(token)));
            }
            default: {
                form = Reader.read_atom(rdr);
            }
        }
        return form;
    }

    private static VncVal interpolate(String s, String filename) {
        int pos = Reader.getFirsInterpolationFormStartPos(s);
        if (pos < 0) {
            return new VncString(s);
        }
        ArrayList<VncVal> list = new ArrayList<VncVal>();
        list.add(CoreFunctions.str);
        String str = s;
        while (true) {
            String rest;
            if (pos > 0) {
                list.add(new VncString(str.substring(0, pos)));
            }
            int offset = (rest = str.substring(pos)).startsWith("~{") ? 2 : 1;
            Reader rdr = Reader.reader(rest.substring(offset), filename);
            list.add(Reader.read_form(rdr));
            String tail = rdr.unprocessedRest().substring(offset);
            pos = Reader.getFirsInterpolationFormStartPos(tail);
            if (pos < 0) {
                if (!tail.isEmpty()) {
                    list.add(new VncString(tail));
                }
                return new VncList(list);
            }
            str = tail;
        }
    }

    private static int getFirsInterpolationFormStartPos(String s) {
        return Stream.of(s.indexOf("~{"), s.indexOf("~(")).filter(p -> p >= 0).sorted().findFirst().orElse(-1);
    }

    private static String unescapeAndDecodeUnicode(String s) {
        return Reader.unescape(StringUtil.decodeUnicode(s));
    }

    private static String unescape(String text) {
        if (text == null) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = text.toCharArray();
        int len = chars.length;
        int ii = 0;
        block10: while (ii < len) {
            char c;
            if ((c = chars[ii++]) == '\\' && ii < len) {
                switch (chars[ii++]) {
                    case 'n': {
                        sb.append('\n');
                        continue block10;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block10;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block10;
                    }
                    case '\"': {
                        sb.append('\"');
                        continue block10;
                    }
                    case '\'': {
                        sb.append('\'');
                        continue block10;
                    }
                    case '\\': {
                        sb.append('\\');
                        continue block10;
                    }
                    case '\r': {
                        if (ii < len && chars[ii] == '\n') {
                            ++ii;
                            continue block10;
                        }
                        sb.append("\\\r");
                        continue block10;
                    }
                    case '\n': {
                        continue block10;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static int[] getTextPosition(char[] text, int pos, int startPos, int startRow, int startCol) {
        int row = startRow;
        int col = startCol;
        block5: for (int ii = startPos; ii < pos; ++ii) {
            switch (text[ii]) {
                case '\n': {
                    ++row;
                    col = 1;
                    continue block5;
                }
                case '\r': {
                    continue block5;
                }
                case '\t': {
                    col += 4;
                    continue block5;
                }
                default: {
                    ++col;
                }
            }
        }
        return new int[]{row, col};
    }
}

