/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.util.ThreadLocalMap;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.util.concurrent.Callable;

public class SandboxedCallable<T>
implements Callable<T> {
    private final IInterceptor interceptor;
    private final Callable<T> callable;

    public SandboxedCallable(IInterceptor interceptor, Callable<T> callable) {
        this.interceptor = interceptor;
        this.callable = callable;
    }

    @Override
    public T call() throws Exception {
        try {
            ThreadLocalMap.remove();
            JavaInterop.register(this.interceptor);
            T t = this.callable.call();
            return t;
        }
        finally {
            JavaInterop.unregister();
            ThreadLocalMap.remove();
        }
    }
}

