/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.ArityException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Coerce;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.Types;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;

public class MathFunctions {
    public static VncFunction add = new VncFunction("+"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(+)", "(+ x)", "(+ x y)", "(+ x y & more)");
            this.setDoc("Returns the sum of the numbers. (+) returns 0.");
            this.setExamples("(+)", "(+ 1)", "(+ 1 2)", "(+ 1 2 3 4)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                return new VncLong(0);
            }
            if (args.size() == 1) {
                return args.nth(0);
            }
            VncVal val = args.first();
            for (VncVal v : args.slice(1).getList()) {
                val = Numeric.add(val, v);
            }
            return val;
        }
    };
    public static VncFunction subtract = new VncFunction("-"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(- x)", "(- x y)", "(- x y & more)");
            this.setDoc("If one number is supplied, returns the negation, else subtracts the numbers from x and returns the result.");
            this.setExamples("(- 4)", "(- 8 3 -2 -1)", "(- 8 2.5)", "(- 8 1.5M)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                throw new ArityException(args, 0, "-");
            }
            if (args.size() == 1) {
                VncVal first = args.nth(0);
                if (Types.isVncLong(first)) {
                    return Numeric.mul(first, new VncLong(-1L));
                }
                if (Types.isVncDouble(first)) {
                    return Numeric.mul(first, new VncDouble(-1.0));
                }
                if (Types.isVncBigDecimal(first)) {
                    return Numeric.mul(first, new VncBigDecimal(new BigDecimal("-1.0")));
                }
                return first;
            }
            VncVal val = args.first();
            for (VncVal v : args.slice(1).getList()) {
                val = Numeric.sub(val, v);
            }
            return val;
        }
    };
    public static VncFunction multiply = new VncFunction("*"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(*)", "(* x)", "(* x y)", "(* x y & more)");
            this.setDoc("Returns the product of numbers. (*) returns 1");
            this.setExamples("(*)", "(* 4)", "(* 4 3)", "(* 4 3 2)", "(* 6.0 2)", "(* 6 1.5M)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                return new VncLong(1);
            }
            if (args.size() == 1) {
                return args.nth(0);
            }
            VncVal val = args.first();
            for (VncVal v : args.slice(1).getList()) {
                val = Numeric.mul(val, v);
            }
            return val;
        }
    };
    public static VncFunction divide = new VncFunction("/"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(/ x)", "(/ x y)", "(/ x y & more)");
            this.setDoc("If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators.");
            this.setExamples("(/ 2.0)", "(/ 12 2 3)", "(/ 12 3)", "(/ 6.0 2)", "(/ 6 1.5M)");
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                throw new ArityException(args, 0, "/");
            }
            if (args.size() == 1) {
                VncVal first = args.nth(0);
                if (Types.isVncLong(first)) {
                    return Numeric.div(new VncLong(1L), first);
                }
                if (Types.isVncDouble(first)) {
                    return Numeric.div(new VncDouble(1.0), first);
                }
                if (Types.isVncBigDecimal(first)) {
                    return Numeric.div(new VncBigDecimal(BigDecimal.ONE), first);
                }
                return first;
            }
            VncVal val = args.first();
            for (VncVal v : args.slice(1).getList()) {
                val = Numeric.div(val, v);
            }
            return val;
        }
    };
    public static VncFunction modulo = new VncFunction("mod"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(mod n d)");
            this.setDoc("Modulus of n and d.");
            this.setExamples("(mod 10 4)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("mod", args, 2);
            if (!Types.isVncLong(args.nth(0))) {
                throw new VncException(String.format("Function 'mod' does not allow %s as numerator", Types.getClassName(args.nth(0))));
            }
            if (!Types.isVncLong(args.nth(1))) {
                throw new VncException(String.format("Function 'mod' does not allow %s as denominator", Types.getClassName(args.nth(1))));
            }
            return new VncLong(((VncLong)args.nth(0)).getValue() % ((VncLong)args.nth(1)).getValue());
        }
    };
    public static VncFunction inc = new VncFunction("inc"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(inc x)");
            this.setDoc("Increments the number x");
            this.setExamples("(inc 10)", "(inc 10.1)", "(inc 10.12M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("inc", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncLong(arg)) {
                return new VncLong(((VncLong)arg).getValue() + 1L);
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(((VncDouble)arg).getValue() + 1.0);
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(((VncBigDecimal)arg).getValue().add(new BigDecimal(1)));
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'inc'", Types.getClassName(arg)));
        }
    };
    public static VncFunction dec = new VncFunction("dec"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(dec x)");
            this.setDoc("Decrements the number x");
            this.setExamples("(dec 10)", "(dec 10.1)", "(dec 10.12M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncLong(arg)) {
                return new VncLong(((VncLong)arg).getValue() - 1L);
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(((VncDouble)arg).getValue() - 1.0);
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(((VncBigDecimal)arg).getValue().subtract(new BigDecimal(1)));
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'dec'", Types.getClassName(arg)));
        }
    };
    public static VncFunction max = new VncFunction("max"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(max x)", "(max x y)", "(max x y & more)");
            this.setDoc("Returns the greatest of the values");
            this.setExamples("(max 1)", "(max 1 2)", "(max 4 3 2 1)", "(max 1.0)", "(max 1.0 2.0)", "(max 4.0 3.0 2.0 1.0)", "(max 1.0M)", "(max 1.0M 2.0M)", "(max 4.0M 3.0M 2.0M 1.0M)", "(max 1.0M 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal op1;
            if (args.isEmpty()) {
                throw new ArityException(args, 0, "max");
            }
            VncVal max = op1 = args.nth(0);
            for (VncVal op : args.rest().getList()) {
                if (Types.isVncNumber(op)) {
                    max = op.compareTo(max) > 0 ? op : max;
                    continue;
                }
                throw new VncException(String.format("Function 'max' does not allow %s as operand", Types.getClassName(max)));
            }
            return max;
        }
    };
    public static VncFunction min = new VncFunction("min"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(min x)", "(min x y)", "(min x y & more)");
            this.setDoc("Returns the smallest of the values");
            this.setExamples("(min 1)", "(min 1 2)", "(min 4 3 2 1)", "(min 1.0)", "(min 1.0 2.0)", "(min 4.0 3.0 2.0 1.0)", "(min 1.0M)", "(min 1.0M 2.0M)", "(min 4.0M 3.0M 2.0M 1.0M)", "(min 1.0M 2)");
        }

        @Override
        public VncVal apply(VncList args) {
            VncVal op1;
            if (args.isEmpty()) {
                throw new ArityException(args, 0, "min");
            }
            VncVal min = op1 = args.nth(0);
            for (VncVal op : args.rest().getList()) {
                if (Types.isVncNumber(op)) {
                    min = op.compareTo(min) < 0 ? op : min;
                    continue;
                }
                throw new VncException(String.format("Function 'min' does not allow %s as operand", Types.getClassName(min)));
            }
            return min;
        }
    };
    public static VncFunction abs = new VncFunction("abs"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(abs x)");
            this.setDoc("Returns the absolute value of the number");
            this.setExamples("(abs 10)", "(abs -10)", "(abs -10.1)", "(abs -10.12M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("abs", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncLong(arg)) {
                return new VncLong(Math.abs(((VncLong)arg).getValue()));
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(Math.abs(((VncDouble)arg).getValue()));
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(((VncBigDecimal)arg).getValue().abs());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'abs'", Types.getClassName(arg)));
        }
    };
    public static VncFunction negate = new VncFunction("negate"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(negate x)");
            this.setDoc("Negates x");
            this.setExamples("(negate 10)", "(negate 1.23)", "(negate 1.23M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("negate", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncLong(arg)) {
                return new VncLong(Math.negateExact(((VncLong)arg).getValue()));
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(((VncDouble)arg).getValue() * -1.0);
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(Coerce.toVncBigDecimal(args.first()).getValue().negate());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'negate'", Types.getClassName(arg)));
        }
    };
    public static VncFunction sqrt = new VncFunction("sqrt"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(sqrt x)");
            this.setDoc("Square root of x");
            this.setExamples("(sqrt 10)", "(sqrt 10.23)", "(sqrt 10.23M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sqrt", args, 1);
            VncVal arg = args.nth(0);
            if (Types.isVncLong(arg)) {
                return new VncDouble(Math.sqrt(((VncLong)arg).getValue().doubleValue()));
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(Math.sqrt(((VncDouble)arg).getValue()));
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(new BigDecimal(Math.sqrt(Coerce.toVncBigDecimal(args.first()).getValue().doubleValue())));
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'sqrt'", Types.getClassName(arg)));
        }
    };
    public static VncFunction rand_long = new VncFunction("rand-long"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(rand-long)", "(rand-long max)");
            this.setDoc("Without argument returns a random long between 0 and MAX_LONG. Without argument max returns a random long between 0 and max exclusive.");
            this.setExamples("(rand-long)", "(rand-long 100)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rand-long", args, 0, 1);
            if (args.isEmpty()) {
                return new VncLong(Math.abs(random.nextLong()));
            }
            long max = Coerce.toVncLong(args.first()).getValue();
            if (max < 2L) {
                throw new VncException("Function 'rand-long' does not allow negative max values");
            }
            return new VncLong(Math.abs(random.nextLong()) % max);
        }
    };
    public static VncFunction rand_double = new VncFunction("rand-double"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(rand-double)", "(rand-double max)");
            this.setDoc("Without argument returns a double between 0.0 and 1.0. Without argument max returns a random double between 0.0 and max.");
            this.setExamples("(rand-double)", "(rand-double 100.0)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rand-double", args, 0, 1);
            if (args.isEmpty()) {
                return new VncDouble(random.nextDouble());
            }
            double max = Coerce.toVncDouble(args.first()).getValue();
            if (max < 0.0) {
                throw new VncException("Function 'rand-double' does not allow negative max values");
            }
            return new VncDouble(random.nextDouble() * max);
        }
    };
    public static VncFunction rand_gaussian = new VncFunction("rand-gaussian"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(rand-gaussian)", "(rand-gaussian mean stddev)");
            this.setDoc("Without argument returns a Gaussion distributed double value with mean 0.0 and standard deviation 1.0. With argument mean and stddev returns a Gaussion distributed double value with the given mean and standard deviation.");
            this.setExamples("(rand-gaussian)", "(rand-gaussian 0.0 5.0)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rand-gaussian", args, 0, 2);
            if (args.isEmpty()) {
                return new VncDouble(random.nextGaussian());
            }
            double mean = Coerce.toVncDouble(args.first()).getValue();
            double stddev = Coerce.toVncDouble(args.second()).getValue();
            return new VncDouble(mean + stddev * random.nextGaussian());
        }
    };
    public static VncFunction zero_Q = new VncFunction("zero?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(zero? x)");
            this.setDoc("Returns true if x zero else false");
            this.setExamples("(zero? 0)", "(zero? 2)", "(zero? 0.0)", "(zero? 0.0M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("zero?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() == 0L ? Constants.True : Constants.False;
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).getValue() == 0.0 ? Constants.True : Constants.False;
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) == 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'zero' does not allow %s as operand 1", Types.getClassName(op1)));
        }
    };
    public static VncFunction pos_Q = new VncFunction("pos?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(pos? x)");
            this.setDoc("Returns true if x greater than zero else false");
            this.setExamples("(pos? 3)", "(pos? -3)", "(pos? 3.2)", "(pos? 3.2M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("pos?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() > 0L ? Constants.True : Constants.False;
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).getValue() > 0.0 ? Constants.True : Constants.False;
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) > 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'pos' does not allow %s as operand 1", Types.getClassName(op1)));
        }
    };
    public static VncFunction neg_Q = new VncFunction("neg?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(neg? x)");
            this.setDoc("Returns true if x smaller than zero else false");
            this.setExamples("(neg? -3)", "(neg? 3)", "(neg? -3.2)", "(neg? -3.2M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("neg?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() < 0L ? Constants.True : Constants.False;
            }
            if (Types.isVncDouble(op1)) {
                return ((VncDouble)op1).getValue() < 0.0 ? Constants.True : Constants.False;
            }
            if (Types.isVncBigDecimal(op1)) {
                return ((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) < 0 ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'neg?' does not allow %s as operand 1s", Types.getClassName(op1)));
        }
    };
    public static VncFunction even_Q = new VncFunction("even?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(even? n)");
            this.setDoc("Returns true if n is even, throws an exception if n is not an integer");
            this.setExamples("(even? 4)", "(even? 3)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("even?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() % 2L == 0L ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'even' does not allow %s as operand.", Types.getClassName(op1)));
        }
    };
    public static VncFunction odd_Q = new VncFunction("odd?"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(odd? n)");
            this.setDoc("Returns true if n is odd, throws an exception if n is not an integer");
            this.setExamples("(odd? 3)", "(odd? 4)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("odd?", args, 1);
            VncVal op1 = args.nth(0);
            if (Types.isVncLong(op1)) {
                return ((VncLong)op1).getValue() % 2L == 1L ? Constants.True : Constants.False;
            }
            throw new VncException(String.format("Function 'odd' does not allow %s as operand", Types.getClassName(op1)));
        }
    };
    public static VncFunction dec_add = new VncFunction("dec/add"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(dec/add x y scale rounding-mode)");
            this.setDoc("Adds two decimals and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
            this.setExamples("(dec/add 2.44697M 1.79882M 3 :HALF_UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/add", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.nth(0));
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.nth(1));
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().add(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction dec_sub = new VncFunction("dec/sub"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(dec/sub x y scale rounding-mode)");
            this.setDoc("Subtract y from x and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
            this.setExamples("(dec/sub 2.44697M 1.79882M 3 :HALF_UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/sub", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.nth(0));
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.nth(1));
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().subtract(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction dec_mul = new VncFunction("dec/mul"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(dec/mul x y scale rounding-mode)");
            this.setDoc("Multiplies two decimals and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
            this.setExamples("(dec/mul 2.44697M 1.79882M 5 :HALF_UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/mul", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.nth(0));
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.nth(1));
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().multiply(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction dec_div = new VncFunction("dec/div"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(dec/div x y scale rounding-mode)");
            this.setDoc("Divides x by y and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
            this.setExamples("(dec/div 2.44697M 1.79882M 5 :HALF_UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/div", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.nth(0));
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.nth(1));
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().divide(op2.getValue(), scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction dec_scale = new VncFunction("dec/scale"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(dec/scale x scale rounding-mode)");
            this.setDoc("Scales a decimal. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)");
            this.setExamples("(dec/scale 2.44697M 0 :HALF_UP)", "(dec/scale 2.44697M 1 :HALF_UP)", "(dec/scale 2.44697M 2 :HALF_UP)", "(dec/scale 2.44697M 3 :HALF_UP)", "(dec/scale 2.44697M 10 :HALF_UP)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/scale", args, 3);
            VncVal arg = args.nth(0);
            VncLong scale = Coerce.toVncLong(args.nth(1));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode((VncString)args.nth(2));
            if (Types.isVncBigDecimal(arg)) {
                BigDecimal val = ((VncBigDecimal)arg).getValue();
                return new VncBigDecimal(val.setScale(scale.getValue().intValue(), roundingMode));
            }
            throw new VncException(String.format("Function 'dec/scale' does not allow %s as operand 1s", Types.getClassName(arg)));
        }
    };
    public static VncFunction range = new VncFunction("range"){
        private static final long serialVersionUID = -1848883965231344442L;
        {
            this.setArgLists("(range end)", "(range start end)", "(range start end step)");
            this.setDoc("Returns a collection of numbers from start (inclusive) to end (exclusive), by step, where start defaults to 0 and step defaults to 1. When start is equal to end, returns empty list.");
            this.setExamples("(range 10)", "(range 10 20)", "(range 10 20 3)", "(range 10 15 0.5)", "(range 1.1M 2.2M 0.1M)");
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("range", args, 1, 2, 3);
            VncVal start = new VncLong(0);
            VncVal end = new VncLong(0);
            VncVal step = new VncLong(1);
            switch (args.size()) {
                case 1: {
                    end = args.nth(0);
                    break;
                }
                case 2: {
                    start = args.nth(0);
                    end = args.nth(1);
                    break;
                }
                case 3: {
                    start = args.nth(0);
                    end = args.nth(1);
                    step = args.nth(2);
                }
            }
            if (!Types.isVncNumber(start)) {
                throw new VncException("range: start value must be a number");
            }
            if (!Types.isVncNumber(end)) {
                throw new VncException("range: end value must be a number");
            }
            if (!Types.isVncNumber(step)) {
                throw new VncException("range: step value must be a number");
            }
            ArrayList<VncVal> values = new ArrayList<VncVal>();
            if (zero_Q.apply(new VncList(step)) == Constants.True) {
                throw new VncException("range: a step value must not be 0");
            }
            if (pos_Q.apply(new VncList(step)) == Constants.True) {
                if (CoreFunctions.lt.apply(new VncList(end, start)) == Constants.True) {
                    throw new VncException("range positive step: end must not be lower than start");
                }
                VncVal val = start;
                while (CoreFunctions.lt.apply(new VncList(val, end)) == Constants.True) {
                    values.add(val);
                    val = (VncVal)add.apply(new VncList(val, step));
                }
            } else {
                if (CoreFunctions.gt.apply(new VncList(end, start)) == Constants.True) {
                    throw new VncException("range negative step: end must not be greater than start");
                }
                VncVal val = start;
                while (CoreFunctions.gt.apply(new VncList(val, end)) == Constants.True) {
                    values.add(val);
                    val = (VncVal)add.apply(new VncList(val, step));
                }
            }
            return new VncList(values);
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("+", (VncVal)add).put("-", (VncVal)subtract).put("*", (VncVal)multiply).put("/", (VncVal)divide).put("mod", (VncVal)modulo).put("inc", (VncVal)inc).put("dec", (VncVal)dec).put("abs", (VncVal)abs).put("min", (VncVal)min).put("max", (VncVal)max).put("negate", (VncVal)negate).put("sqrt", (VncVal)sqrt).put("dec/add", (VncVal)dec_add).put("dec/sub", (VncVal)dec_sub).put("dec/mul", (VncVal)dec_mul).put("dec/div", (VncVal)dec_div).put("dec/scale", (VncVal)dec_scale).put("zero?", (VncVal)zero_Q).put("pos?", (VncVal)pos_Q).put("neg?", (VncVal)neg_Q).put("even?", (VncVal)even_Q).put("odd?", (VncVal)odd_Q).put("rand-long", (VncVal)rand_long).put("rand-double", (VncVal)rand_double).put("rand-gaussian", (VncVal)rand_gaussian).put("range", (VncVal)range).toMap();
    private static final Random random = new Random();
}

